/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.string;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Objects;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.StringValueConversionException;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.time.Duration;
import org.apache.wicket.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringValue
implements IClusterable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(StringValue.class);
    private final Locale locale;
    private final String text;

    public static StringValue repeat(int times, char c) {
        AppendingStringBuffer buffer = new AppendingStringBuffer(times);
        for (int i = 0; i < times; ++i) {
            buffer.append(c);
        }
        return StringValue.valueOf(buffer);
    }

    public static StringValue repeat(int times, String s) {
        AppendingStringBuffer buffer = new AppendingStringBuffer(times);
        for (int i = 0; i < times; ++i) {
            buffer.append(s);
        }
        return StringValue.valueOf(buffer);
    }

    public static StringValue valueOf(double value) {
        return StringValue.valueOf(value, Locale.getDefault(Locale.Category.FORMAT));
    }

    public static StringValue valueOf(double value, int places, Locale locale) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            return StringValue.valueOf("N/A");
        }
        DecimalFormat format = new DecimalFormat("#." + StringValue.repeat(places, '#'), new DecimalFormatSymbols(locale));
        return StringValue.valueOf(format.format(value));
    }

    public static StringValue valueOf(double value, Locale locale) {
        return StringValue.valueOf(value, 1, locale);
    }

    public static StringValue valueOf(Object object) {
        return StringValue.valueOf(Strings.toString(object));
    }

    public static StringValue valueOf(Object object, Locale locale) {
        return StringValue.valueOf(Strings.toString(object), locale);
    }

    public static StringValue valueOf(String string) {
        return new StringValue(string);
    }

    public static StringValue valueOf(String string, Locale locale) {
        return new StringValue(string, locale);
    }

    public static StringValue valueOf(AppendingStringBuffer buffer) {
        return StringValue.valueOf(buffer.toString());
    }

    protected StringValue(String text) {
        this(text, Locale.getDefault());
    }

    protected StringValue(String text, Locale locale) {
        this.text = text;
        this.locale = locale;
    }

    public final String afterFirst(char c) {
        return Strings.afterFirst(this.text, c);
    }

    public final String afterLast(char c) {
        return Strings.afterLast(this.text, c);
    }

    public final String beforeFirst(char c) {
        return Strings.beforeFirst(this.text, c);
    }

    public final String beforeLast(char c) {
        return Strings.afterLast(this.text, c);
    }

    public final CharSequence replaceAll(CharSequence searchFor, CharSequence replaceWith) {
        return Strings.replaceAll(this.text, searchFor, replaceWith);
    }

    public final <T> T to(Class<T> type) throws StringValueConversionException {
        if (type == null) {
            return null;
        }
        if (type == String.class) {
            return (T)this.toString();
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return (T)this.toInteger();
        }
        if (type == Long.TYPE || type == Long.class) {
            return (T)this.toLongObject();
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return (T)this.toBooleanObject();
        }
        if (type == Double.TYPE || type == Double.class) {
            return (T)this.toDoubleObject();
        }
        if (type == Character.TYPE || type == Character.class) {
            return (T)this.toCharacter();
        }
        if (type == Time.class) {
            return (T)this.toTime();
        }
        if (type == Duration.class) {
            return (T)this.toDuration();
        }
        if (type.isEnum()) {
            return (T)this.toEnum((T)((Object)type));
        }
        throw new StringValueConversionException("Cannot convert '" + this.toString() + "'to type " + type);
    }

    public final <T> T toOptional(Class<T> type) throws StringValueConversionException {
        return Strings.isEmpty(this.text) ? null : (T)this.to(type);
    }

    public final boolean toBoolean() throws StringValueConversionException {
        return Strings.isTrue(this.text);
    }

    public final boolean toBoolean(boolean defaultValue) {
        block3: {
            if (this.text != null) {
                try {
                    return this.toBoolean();
                }
                catch (StringValueConversionException x) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug(String.format("An error occurred while converting '%s' to a boolean: %s", this.text, x.getMessage()), (Throwable)x);
                }
            }
        }
        return defaultValue;
    }

    public final Boolean toBooleanObject() throws StringValueConversionException {
        return Strings.toBoolean(this.text);
    }

    public final char toChar() throws StringValueConversionException {
        return Strings.toChar(this.text);
    }

    public final char toChar(char defaultValue) {
        block3: {
            if (this.text != null) {
                try {
                    return this.toChar();
                }
                catch (StringValueConversionException x) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug(String.format("An error occurred while converting '%s' to a character: %s", this.text, x.getMessage()), (Throwable)x);
                }
            }
        }
        return defaultValue;
    }

    public final Character toCharacter() throws StringValueConversionException {
        return Character.valueOf(this.toChar());
    }

    public final double toDouble() throws StringValueConversionException {
        try {
            return NumberFormat.getNumberInstance(this.locale).parse(this.text).doubleValue();
        }
        catch (ParseException e) {
            throw new StringValueConversionException("Unable to convert '" + this.text + "' to a double value", e);
        }
    }

    public final double toDouble(double defaultValue) {
        block3: {
            if (this.text != null) {
                try {
                    return this.toDouble();
                }
                catch (Exception x) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug(String.format("An error occurred while converting '%s' to a double: %s", this.text, x.getMessage()), (Throwable)x);
                }
            }
        }
        return defaultValue;
    }

    public final Double toDoubleObject() throws StringValueConversionException {
        return this.toDouble();
    }

    public final Duration toDuration() throws StringValueConversionException {
        return Duration.valueOf(this.text, this.locale);
    }

    public final Duration toDuration(Duration defaultValue) {
        block3: {
            if (this.text != null) {
                try {
                    return this.toDuration();
                }
                catch (Exception x) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug(String.format("An error occurred while converting '%s' to a Duration: %s", this.text, x.getMessage()), (Throwable)x);
                }
            }
        }
        return defaultValue;
    }

    public final int toInt() throws StringValueConversionException {
        try {
            return Integer.parseInt(this.text);
        }
        catch (NumberFormatException e) {
            throw new StringValueConversionException("Unable to convert '" + this.text + "' to an int value", e);
        }
    }

    public final int toInt(int defaultValue) {
        block3: {
            if (this.text != null) {
                try {
                    return this.toInt();
                }
                catch (StringValueConversionException x) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug(String.format("An error occurred while converting '%s' to an integer: %s", this.text, x.getMessage()), (Throwable)x);
                }
            }
        }
        return defaultValue;
    }

    public final Integer toInteger() throws StringValueConversionException {
        try {
            return Integer.parseInt(this.text, 10);
        }
        catch (NumberFormatException e) {
            throw new StringValueConversionException("Unable to convert '" + this.text + "' to an Integer value", e);
        }
    }

    public final long toLong() throws StringValueConversionException {
        try {
            return Long.parseLong(this.text);
        }
        catch (NumberFormatException e) {
            throw new StringValueConversionException("Unable to convert '" + this.text + "' to a long value", e);
        }
    }

    public final long toLong(long defaultValue) {
        block3: {
            if (this.text != null) {
                try {
                    return this.toLong();
                }
                catch (StringValueConversionException x) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug(String.format("An error occurred while converting '%s' to a long: %s", this.text, x.getMessage()), (Throwable)x);
                }
            }
        }
        return defaultValue;
    }

    public final Long toLongObject() throws StringValueConversionException {
        try {
            return Long.parseLong(this.text, 10);
        }
        catch (NumberFormatException e) {
            throw new StringValueConversionException("Unable to convert '" + this.text + "' to a Long value", e);
        }
    }

    public final Boolean toOptionalBoolean() throws StringValueConversionException {
        return Strings.isEmpty(this.text) ? null : this.toBooleanObject();
    }

    public final Character toOptionalCharacter() throws StringValueConversionException {
        return Strings.isEmpty(this.text) ? null : this.toCharacter();
    }

    public final Double toOptionalDouble() throws StringValueConversionException {
        return Strings.isEmpty(this.text) ? null : this.toDoubleObject();
    }

    public final Duration toOptionalDuration() throws StringValueConversionException {
        return Strings.isEmpty(this.text) ? null : this.toDuration();
    }

    public final Integer toOptionalInteger() throws StringValueConversionException {
        return Strings.isEmpty(this.text) ? null : this.toInteger();
    }

    public final Long toOptionalLong() throws StringValueConversionException {
        return Strings.isEmpty(this.text) ? null : this.toLongObject();
    }

    public final String toOptionalString() {
        return this.text;
    }

    public final Time toOptionalTime() throws StringValueConversionException {
        return Strings.isEmpty(this.text) ? null : this.toTime();
    }

    public final String toString() {
        return this.text;
    }

    public final String toString(String defaultValue) {
        return this.text == null ? defaultValue : this.text;
    }

    public final Time toTime() throws StringValueConversionException {
        try {
            return Time.valueOf(this.text);
        }
        catch (ParseException e) {
            throw new StringValueConversionException("Unable to convert '" + this.text + "' to a Time value", e);
        }
    }

    public final Time toTime(Time defaultValue) {
        block3: {
            if (this.text != null) {
                try {
                    return this.toTime();
                }
                catch (StringValueConversionException x) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug(String.format("An error occurred while converting '%s' to a Time: %s", this.text, x.getMessage()), (Throwable)x);
                }
            }
        }
        return defaultValue;
    }

    public final <T extends Enum<T>> T toEnum(Class<T> eClass) throws StringValueConversionException {
        return Strings.toEnum(this.text, eClass);
    }

    public final <T extends Enum<T>> T toEnum(T defaultValue) {
        Args.notNull(defaultValue, "defaultValue");
        return (T)this.toEnum(defaultValue.getClass(), defaultValue);
    }

    public final <T extends Enum<T>> T toEnum(Class<T> eClass, T defaultValue) {
        block3: {
            if (this.text != null) {
                try {
                    return (T)this.toEnum((T)((Object)eClass));
                }
                catch (StringValueConversionException x) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug(String.format("An error occurred while converting '%s' to a %s: %s", this.text, eClass, x.getMessage()), (Throwable)x);
                }
            }
        }
        return defaultValue;
    }

    public final <T extends Enum<T>> T toOptionalEnum(Class<T> eClass) throws StringValueConversionException {
        return (T)(Strings.isEmpty(this.text) ? null : this.toEnum((T)((Object)eClass)));
    }

    public boolean isNull() {
        return this.text == null;
    }

    public boolean isEmpty() {
        return Strings.isEmpty(this.text);
    }

    public int hashCode() {
        return Objects.hashCode(this.locale, this.text);
    }

    public boolean equals(Object obj) {
        if (obj instanceof StringValue) {
            StringValue stringValue = (StringValue)obj;
            return Objects.isEqual(this.text, stringValue.text) && this.locale.equals(stringValue.locale);
        }
        return false;
    }
}

