/*******************************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *  
 *   http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 *  
 *******************************************************************************/
//
// This file was generated by the JavaTM Architecture for XML Binding(JAXB) Reference Implementation, v2.1.1-b02-fcs 
// See <a href="http://java.sun.com/xml/jaxb">http://java.sun.com/xml/jaxb</a> 
// Any modifications to this file will be lost upon recompilation of the source schema. 
// Generated on: 2008.05.27 at 11:24:25 AM IDT 
//

package org.apache.wink.common.model.atom;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;

import org.apache.wink.common.model.synd.SyndLink;

/**
 * The "atom:link" elementPer RFC4287
 * 
 * <pre>
 *  The &quot;atom:link&quot; element defines a reference from an entry or feed to
 *  a Web resource.  This specification assigns no meaning to the content
 *  (if any) of this element.
 * 
 *  atomLink =
 *     element atom:link {
 *        atomCommonAttributes,
 *        attribute href { atomUri },
 *        attribute rel { atomNCName | atomUri }?,
 *        attribute type { atomMediaType }?,
 *        attribute hreflang { atomLanguageTag }?,
 *        attribute title { text }?,
 *        attribute length { text }?,
 *        undefinedContent
 *     }
 * </pre>
 * 
 * <ul>
 * <li> The "href" Attribute.
 * <pre>
 * The "href" attribute contains the link's IRI. 
 * atom:link elements MUST have an href attribute, whose value MUST be a IRI reference [RFC3987].
 * </pre>
 * </li>
 * <li> The "rel" Attribute
 * <pre>
 * atom:link elements MAY have a "rel" attribute that indicates the link relation type. 
 * If the "rel" attribute is not present, 
 * the link element MUST be interpreted as if the link relation type is "alternate".
 * 
 * The value of "rel" MUST be a string that is non-empty and matches either the 
 * "isegment-nz-nc" or the "IRI" production in [RFC3987]. 
 * Note that use of a relative reference other than a simple name is not allowed. 
 * If a name is given, implementations MUST consider the link relation type equivalent to the same 
 * name registered within the IANA Registry of Link Relations (Section 7), and thus to the IRI 
 * that would be obtained by appending the value of the rel attribute to the string 
 * "http://www.iana.org/assignments/relation/". The value of "rel" describes the 
 * meaning of the link, but does not impose any behavioral requirements on Atom Processors.
 * 
 * This document defines five initial values for the Registry of Link Relations:
 * 
 *    1. The value "alternate" signifies that the IRI in the value of the href attribute identifies an alternate version of the resource described by the containing element.
 *    2. The value "related" signifies that the IRI in the value of the href attribute identifies a resource related to the resource described by the containing element. For example, the feed for a site that discusses the performance of the search engine at "http://search.example.com" might contain, as a child of atom:feed:
 * 
 *           &lt;link rel="related" href="http://search.example.com/"/&gt;
 * 
 *       An identical link might appear as a child of any atom:entry whose content contains a discussion of that same search engine.
 *    3. The value "self" signifies that the IRI in the value of the href attribute identifies a resource equivalent to the containing element.
 *    4. The value "enclosure" signifies that the IRI in the value of the href attribute identifies a related resource that is potentially large in size and might require special handling. For atom:link elements with rel="enclosure", the length attribute SHOULD be provided.
 *    5. The value "via" signifies that the IRI in the value of the href attribute identifies a resource that is the source of the information provided in the containing element.
 * </pre>
 * </li>
 * <li> The "type" Attribute
 * <pre>
 * On the link element, the "type" attribute's value is an advisory media type: 
 * it is a hint about the type of the representation that is expected to be returned when the value of the 
 * href attribute is dereferenced. Note that the type attribute does not override the actual 
 * media type returned with the representation. Link elements MAY have a type attribute, 
 * whose value MUST conform to the syntax of a MIME media type [MIMEREG].
 * </pre>
 * </li>
 * <li> The "hreflang" Attribute
 * <pre>
 * The "hreflang" attribute's content describes the language of the resource pointed to by the href attribute. 
 * When used together with the rel="alternate", it implies a translated version of the entry. 
 * Link elements MAY have an hreflang attribute, whose value MUST be a language tag [RFC3066].
 * </pre>
 * </li>
 * <li> The "title" Attribute
 * <pre>
 * The "title" attribute conveys human-readable information about the link. 
 * The content of the "title" attribute is Language-Sensitive. 
 * Entities such as "&amp;" and "&lt;" represent their corresponding characters ("&" and "<", respectively), not markup. 
 * Link elements MAY have a title attribute.
 * </pre>
 * </li>
 * <li> The "length" Attribute
 * <pre>
 * The "length" attribute indicates an advisory length of the linked content in octets; 
 * it is a hint about the content length of the representation returned when the IRI in the href attribute is 
 * mapped to a URI and dereferenced. Note that the length attribute does not override the actual content 
 * length of the representation as reported by the underlying protocol. Link elements MAY have a length attribute.
 * </pre>
 * </li>
 * </ul>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "atomLink")
public class AtomLink extends AtomCommonAttributes {

    @XmlAttribute
    protected String length;
    @XmlAttribute
    protected String title;
    @XmlAttribute
    protected String hreflang;
    @XmlAttribute
    protected String rel;
    @XmlAttribute
    protected String type;
    @XmlAttribute(required = true)
    @XmlSchemaType(name = "anyURI")
    protected String href;

    public AtomLink() {
    }

    public AtomLink(SyndLink value) {
        super(value);
        if (value == null) {
            return;
        }
        setHref(value.getHref());
        setHreflang(value.getHreflang());
        setLength(value.getLength());
        setRel(value.getRel());
        setTitle(value.getTitle());
        setType(value.getType());
    }

    public SyndLink toSynd(SyndLink value) {
        if (value == null) {
            return value;
        }
        super.toSynd(value);
        value.setHref(getHref());
        value.setHreflang(getHreflang());
        value.setLength(getLength());
        value.setRel(getRel());
        value.setTitle(getTitle());
        value.setType(getType());
        return value;
    }

    /**
     * Gets the value of length.
     */
    public String getLength() {
        return length;
    }

    /**
     * Sets the value of length.
     */
    public void setLength(String value) {
        this.length = value;
    }

    /**
     * Gets the value of title.
     */
    public String getTitle() {
        return title;
    }

    /**
     * Sets the value of title.
     */
    public void setTitle(String value) {
        this.title = value;
    }

    /**
     * Gets the value of hreflang.
     */
    public String getHreflang() {
        return hreflang;
    }

    /**
     * Sets the value of hreflang.
     */
    public void setHreflang(String value) {
        this.hreflang = value;
    }

    /**
     * Gets the value of rel.
     */
    public String getRel() {
        return rel;
    }

    /**
     * Sets the value of rel.
     */
    public void setRel(String value) {
        this.rel = value;
    }

    /**
     * Gets the value of type.
     */
    public String getType() {
        return type;
    }

    /**
     * Sets the value of type.
     */
    public void setType(String value) {
        this.type = value;
    }

    /**
     * Gets the value of href.
     */
    public String getHref() {
        return href;
    }

    /**
     * Sets the value of href.
     */
    public void setHref(String value) {
        this.href = value;
    }

}
