/*******************************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *  
 *   http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 *  
 *******************************************************************************/
//
// This file was generated by the JavaTM Architecture for XML Binding(JAXB) Reference Implementation, v2.1.1-b02-fcs 
// See <a href="http://java.sun.com/xml/jaxb">http://java.sun.com/xml/jaxb</a> 
// Any modifications to this file will be lost upon recompilation of the source schema. 
// Generated on: 2008.09.15 at 04:04:57 PM IDT 
//

package org.apache.wink.common.model.atom;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlMixed;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

import org.apache.wink.common.internal.model.AnyContentHandler;
import org.apache.wink.common.internal.model.ModelUtils;
import org.apache.wink.common.model.synd.SyndText;
import org.apache.wink.common.model.synd.SyndTextType;

/**
 * Text Construct Per RFC4287
 * 
 * <pre>
 * A Text construct contains human-readable text, usually in small quantities. The content of Text
 * constructs is Language-Sensitive.
 * 
 * atomPlainTextConstruct =
 *       atomCommonAttributes,
 *       attribute type { &quot;text&quot; | &quot;html&quot; }?,
 *       text
 * 
 *    atomXHTMLTextConstruct =
 *       atomCommonAttributes,
 *       attribute type { &quot;xhtml&quot; },
 *       xhtmlDiv
 * 
 *    atomTextConstruct = atomPlainTextConstruct | atomXHTMLTextConstruct
 * 
 * o The &quot;type&quot; Attribute
 * 
 * Text constructs MAY have a &quot;type&quot; attribute. When present, the value MUST be one of &quot;text&quot;,
 * &quot;html&quot;, or &quot;xhtml&quot;. If the &quot;type&quot; attribute is not provided, Atom Processors MUST behave as
 * though it were present with a value of &quot;text&quot;. Unlike the atom:content element defined in Section
 * 4.1.3, MIME media types [MIMEREG] MUST NOT be used as values for the &quot;type&quot; attribute on Text
 * constructs.
 * 
 *   o Text
 * 
 *     Example atom:title with text content:
 * 
 *     ... &lt;title type=&quot;text&quot;&gt; Less: &lt; &lt;/title&gt; ...
 * 
 *     If the value is &quot;text&quot;, the content of the Text construct MUST NOT contain child elements. Such
 *     text is intended to be presented to humans in a readable fashion. Thus, Atom Processors MAY
 *     collapse white space (including line breaks) and display the text using typographic techniques
 *     such as justification and proportional fonts.
 * 
 *   o HTML
 * 
 *     Example atom:title with HTML content:
 * 
 *     ... &lt;title type=&quot;html&quot;&gt; Less: &lt;em&gt; &amp;lt; &lt;/em&gt; &lt;/title&gt; ...
 * 
 *     If the value of &quot;type&quot; is &quot;html&quot;, the content of the Text construct MUST NOT contain child
 *     elements and SHOULD be suitable for handling as HTML [HTML]. Any markup within MUST be escaped;
 *     for example, &quot;&lt;br&gt;
 *     &quot; as &quot;&lt;br&gt;&quot;. HTML markup within SHOULD be such that it could validly appear directly within an
 *     HTML &lt;DIV&gt; element, after unescaping. Atom Processors that display such content MAY use that
 *     markup to aid in its display.
 * 
 * 
 *   o XHTML
 * 
 *     Example atom:title with XHTML content:
 * 
 *     ... &lt;title type=&quot;xhtml&quot; xmlns:xhtml=&quot;http://www.w3.org/1999/xhtml&quot;&gt; &lt;xhtml:div&gt; Less: &lt;xhtml:em&gt;
 *     &lt; &lt;/xhtml:em&gt; &lt;/xhtml:div&gt; &lt;/title&gt; ...
 * 
 *     If the value of &quot;type&quot; is &quot;xhtml&quot;, the content of the Text construct MUST be a single XHTML div
 *     element [XHTML] and SHOULD be suitable for handling as XHTML. The XHTML div element itself MUST
 *     NOT be considered part of the content. Atom Processors that display the content MAY use the
 *     markup to aid in displaying it. The escaped versions of characters such as &quot;&amp;&quot; and &quot;&gt;&quot; represent
 *     those characters, not markup.
 * 
 * 
 *     Examples of valid XHTML content:
 * 
 *     ... &lt;summary type=&quot;xhtml&quot;&gt; &lt;div xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt; This is &lt;b&gt;XHTML&lt;/b&gt;
 *     content. &lt;/div&gt; &lt;/summary&gt; ... &lt;summary type=&quot;xhtml&quot;&gt; &lt;xhtml:div
 *     xmlns:xhtml=&quot;http://www.w3.org/1999/xhtml&quot;&gt; This is &lt;xhtml:b&gt;XHTML&lt;/xhtml:b&gt; content.
 *     &lt;/xhtml:div&gt; &lt;/summary&gt; ...
 * 
 *     The following example assumes that the XHTML namespace has been bound to the &quot;xh&quot; prefix earlier
 *     in the document:
 * 
 *     ... &lt;summary type=&quot;xhtml&quot;&gt; &lt;xh:div&gt; This is &lt;xh:b&gt;XHTML&lt;/xh:b&gt; content. &lt;/xh:div&gt; &lt;/summary&gt; ...
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "atomText", propOrder = {"any"})
public class AtomText extends AtomCommonAttributes {

    @XmlTransient
    private List<Object>   any;

    @XmlAttribute
    protected AtomTextType type;

    @XmlTransient
    private String         savedValue = null;

    @XmlMixed
    @XmlAnyElement(lax = true, value = AnyContentHandler.class)
    List<Object> getAny() {
        ModelUtils.fixAnyContent(any, type == null ? null : type.name());
        return any;
    }

    void setAny(List<Object> any) {
        this.any = any;
    }

    /**
     * Create an empty AtomText with no type and no value
     */
    public AtomText() {
    }

    /**
     * Create an AtomText with a type of AtomTextType.TEXT
     * 
     * @param value the TEXT value
     */
    public AtomText(String value) {
        this(value, AtomTextType.text);
    }

    /**
     * Create an AtomText with the specified value and type
     * 
     * @param value
     * @param type
     */
    public AtomText(String value, AtomTextType type) {
        setType(type);
        setValue(value);
    }

    public AtomText(SyndText value) {
        super(value);
        if (value == null) {
            return;
        }
        if (value.getType() != null) {
            setType(AtomTextType.valueOf(value.getType().toString()));
        }
        setValue(value.getValue(Object.class));
    }

    public SyndText toSynd(SyndText value) {
        if (value == null) {
            return value;
        }
        super.toSynd(value);
        if (getType() != null) {
            value.setType(SyndTextType.valueOf(getType().toString()));
        }
        value.setValue(getValue(Object.class));
        return value;
    }

    public void setValue(Object value) {
        if (value != null) {
            any = Arrays.asList(value);
        } else {
            any = null;
        }
    }

    /**
     * <p>
     * Gets the content of the "atom:text" element as a String. The "type"
     * attribute should be used to determine how to treat the content.
     * <p>
     * Pay attention that de-serialization occurs each time the method is
     * called, so multiple calls to this method may effect the application
     * performance.
     */
    public String getValue() {
        return getValue(String.class);
    }

    /**
     * <p>
     * Gets the content of the "atom:text" element serialized to provided class.
     * The "type" attribute should be used to determine how to treat the
     * content.
     * <p>
     * Pay attention that de-serialization occurs each time the method is
     * called, so multiple calls to this method may effect the application
     * performance.
     */
    public <T> T getValue(Class<T> cls) {
        try {
            return getValue(cls,
                            cls,
                            null,
                            ModelUtils.EMPTY_ARRAY,
                            ModelUtils.EMPTY_STRING_MAP,
                            ModelUtils.determineMediaType(type == null ? null : type.name()));
        } catch (IOException e) {
            // should never happen
            throw new WebApplicationException(e);
        }
    }

    /**
     * <p>
     * Gets the content of the "atom:text" element serialized to provided class
     * according to provided parameters.
     * <p>
     * Pay attention that de-serialization occurs each time the method is
     * called, so multiple calls to this method may effect the application
     * performance.
     */
    public <T> T getValue(Class<T> cls,
                          Type genericType,
                          Providers providers,
                          Annotation[] annotations,
                          MultivaluedMap<String, String> httpHeaders,
                          MediaType mediaType) throws IOException {
        return ModelUtils.readValue(getAny(),
                                       cls,
                                       providers,
                                       genericType,
                                       annotations,
                                       httpHeaders,
                                       mediaType);
    }

    /**
     * Gets the value of type.
     * 
     * @return possible object is {@link AtomTextType }
     */
    public AtomTextType getType() {
        return type;
    }

    /**
     * Sets the value of type.
     * 
     * @param value allowed object is {@link AtomTextType }
     */
    public void setType(AtomTextType type) {
        this.type = type;
    }

    /* package */void revertValue() {
        setValue(savedValue);
        savedValue = null;
    }

    /* package */String saveValue() {
        this.savedValue = getValue();
        setValue(null);
        return this.savedValue;
    }

}
