/*******************************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *  
 *   http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 *  
 *******************************************************************************/
//
// This file was generated by the JavaTM Architecture for XML Binding(JAXB) Reference Implementation, v2.1.1-b02-fcs 
// See <a href="http://java.sun.com/xml/jaxb">http://java.sun.com/xml/jaxb</a> 
// Any modifications to this file will be lost upon recompilation of the source schema. 
// Generated on: 2008.09.15 at 01:17:47 PM IDT 
//

package org.apache.wink.common.model.opensearch;

import java.math.BigInteger;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;

/**
 * The "Image" element per OpenSearch specification
 * 
 * <pre>
 * The &quot;Image&quot; element
 * 
 * Contains a URL that identifies the location of an image that can be used in association 
 * with this search content.
 * 
 * Image sizes are offered as a hint to the search client. 
 * The search client will chose the most appropriate image for the 
 * available space and should give preference to those listed first in the 
 * OpenSearch description document. Square aspect ratios are recommended. 
 * When possible, search engines should offer a 16x16 image of 
 * type &quot;image/x-icon&quot; or &quot;image/vnd.microsoft.icon&quot; (the Microsoft ICON format) 
 * and a 64x64 image of type &quot;image/jpeg&quot; or &quot;image/png&quot;.
 * 
 *     Parent: OpenSearchDescription 
 *     Attributes:
 * 
 *         height - Contains the height, in pixels, of this image.
 * 
 *             Restrictions: The value must be a non-negative integer. 
 *             Requirements: This attribute is optional. 
 * 
 *         width - Contains the width, in pixels, of this image.
 * 
 *             Restrictions: The value must be a non-negative integer. 
 *             Requirements: This attribute is optional. 
 * 
 *         type - Contains the the MIME type of this image.
 * 
 *             Restrictions: The value must be a valid MIME type. 
 *             Requirements: This attribute is optional. 
 * 
 *     Restrictions: The value must be a URI. 
 *     Requirements: This element may appear zero, one, or more times. 
 * 
 * Examples:
 * 
 *  &lt;Image height=&quot;16&quot; width=&quot;16&quot; type=&quot;image/x-icon&quot;&gt;http://example.com/favicon.ico&lt;/Image&gt;
 *  
 *  &lt;Image height=&quot;64&quot; width=&quot;64&quot; type=&quot;image/png&quot;&gt;http://example.com/websearch.png&lt;/Image&gt;
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "OpenSearchImage", propOrder = {"value"})
public class OpenSearchImage {

    @XmlValue
    @XmlSchemaType(name = "anyURI")
    protected String     value;
    @XmlAttribute
    @XmlSchemaType(name = "positiveInteger")
    protected BigInteger height;
    @XmlAttribute
    @XmlSchemaType(name = "positiveInteger")
    protected BigInteger width;
    @XmlAttribute
    protected String     type;

    /**
     * Default Constructor
     */
    public OpenSearchImage() {
    }

    /**
     * Gets the value of the value property.
     * 
     * @return possible object is {@link String }
     */
    public String getValue() {
        return value;
    }

    /**
     * Sets the value of the value property.
     * 
     * @param value allowed object is {@link String }
     */
    public void setValue(String value) {
        this.value = value;
    }

    /**
     * Gets the value of the height property.
     * 
     * @return possible object is {@link BigInteger }
     */
    public BigInteger getHeight() {
        return height;
    }

    /**
     * Sets the value of the height property.
     * 
     * @param value allowed object is {@link BigInteger }
     */
    public void setHeight(BigInteger value) {
        this.height = value;
    }

    /**
     * Gets the value of the width property.
     * 
     * @return possible object is {@link BigInteger }
     */
    public BigInteger getWidth() {
        return width;
    }

    /**
     * Sets the value of the width property.
     * 
     * @param value allowed object is {@link BigInteger }
     */
    public void setWidth(BigInteger value) {
        this.width = value;
    }

    /**
     * Gets the value of the type property.
     * 
     * @return possible object is {@link String }
     */
    public String getType() {
        return type;
    }

    /**
     * Sets the value of the type property.
     * 
     * @param value allowed object is {@link String }
     */
    public void setType(String value) {
        this.type = value;
    }

}
