/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.common;

import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.impl.common.IDocument;
import org.apache.axiom.om.impl.common.serializer.push.OutputException;
import org.apache.axiom.om.impl.common.serializer.push.Serializer;

public class OMDocumentHelper {
    private OMDocumentHelper() {
    }

    public static void internalSerialize(IDocument document, Serializer serializer, OMOutputFormat format, boolean cache, boolean includeXMLDeclaration) throws OutputException {
        if (includeXMLDeclaration) {
            String version;
            String encoding = format.getCharSetEncoding();
            if (encoding == null || "".equals(encoding)) {
                encoding = document.getCharsetEncoding();
            }
            if ((version = document.getXMLVersion()) == null) {
                version = "1.0";
            }
            if (encoding == null) {
                serializer.writeStartDocument(version);
            } else {
                serializer.writeStartDocument(encoding, version);
            }
        }
        serializer.serializeChildren(document, format, cache);
        serializer.writeEndDocument();
    }
}

