/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom;

import java.io.IOException;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import org.apache.axiom.attachments.utils.DataHandlerUtils;
import org.apache.axiom.core.CoreChildNodeSupport;
import org.apache.axiom.dom.DOMCharacterDataSupport;
import org.apache.axiom.dom.DOMExceptionUtil;
import org.apache.axiom.dom.DOMTextNode;
import org.apache.axiom.dom.DOMTextNodeSupport;
import org.apache.axiom.ext.stax.datahandler.DataHandlerProvider;
import org.apache.axiom.om.OMCloneOptions;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.common.IText;
import org.apache.axiom.om.impl.common.OMNamespaceImpl;
import org.apache.axiom.om.impl.common.OMTextSupport;
import org.apache.axiom.om.impl.common.serializer.push.OutputException;
import org.apache.axiom.om.impl.common.serializer.push.Serializer;
import org.apache.axiom.om.impl.dom.CharacterImpl;
import org.apache.axiom.om.impl.dom.ElementImpl;
import org.apache.axiom.om.impl.dom.ParentNode;
import org.apache.axiom.om.impl.dom.TextImpl;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axiom.util.base64.Base64Utils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Text;

public abstract class TextNodeImpl
extends CharacterImpl
implements DOMTextNode,
OMText,
IText {
    private String mimeType;
    private String contentID;
    protected char[] charArray;
    private Object dataHandlerObject;
    public boolean optimize;
    public boolean binary;

    public TextNodeImpl(String text, OMFactory factory) {
        super(factory);
        OMTextSupport.ajc$interFieldInit$org_apache_axiom_om_impl_common_OMTextSupport$org_apache_axiom_om_impl_common_IText$optimize(this);
        OMTextSupport.ajc$interFieldInit$org_apache_axiom_om_impl_common_OMTextSupport$org_apache_axiom_om_impl_common_IText$binary(this);
        this.textValue = text != null ? text : "";
    }

    public TextNodeImpl(TextNodeImpl source, OMFactory factory) {
        super(factory);
        OMTextSupport.ajc$interFieldInit$org_apache_axiom_om_impl_common_OMTextSupport$org_apache_axiom_om_impl_common_IText$optimize(this);
        OMTextSupport.ajc$interFieldInit$org_apache_axiom_om_impl_common_OMTextSupport$org_apache_axiom_om_impl_common_IText$binary(this);
        if (source.textValue != null) {
            this.textValue = source.textValue;
        }
        if (source.charArray != null) {
            this.charArray = new char[source.charArray.length];
            int i = 0;
            while (i < source.charArray.length) {
                this.charArray[i] = source.charArray[i];
                ++i;
            }
        }
        this.setOptimize(source.isOptimized());
        this.mimeType = source.mimeType;
        this.setBinary(source.isBinary());
        this.contentID = source.contentID;
        this.dataHandlerObject = source.dataHandlerObject;
    }

    public TextNodeImpl(String text, String mimeType, boolean optimize, OMFactory factory) {
        this(text, mimeType, optimize, true, factory);
    }

    public TextNodeImpl(String text, String mimeType, boolean optimize, boolean isBinary, OMFactory factory) {
        this(text, factory);
        this.mimeType = mimeType;
        this.setOptimize(optimize);
        this.setBinary(this.isBinary());
    }

    public TextNodeImpl(Object dataHandler, boolean optimize, OMFactory factory) {
        super(factory);
        OMTextSupport.ajc$interFieldInit$org_apache_axiom_om_impl_common_OMTextSupport$org_apache_axiom_om_impl_common_IText$optimize(this);
        OMTextSupport.ajc$interFieldInit$org_apache_axiom_om_impl_common_OMTextSupport$org_apache_axiom_om_impl_common_IText$binary(this);
        this.dataHandlerObject = dataHandler;
        this.setBinary(true);
        this.setOptimize(optimize);
    }

    public TextNodeImpl(String contentID, DataHandlerProvider dataHandlerProvider, boolean optimize, OMFactory factory) {
        super(factory);
        OMTextSupport.ajc$interFieldInit$org_apache_axiom_om_impl_common_OMTextSupport$org_apache_axiom_om_impl_common_IText$optimize(this);
        OMTextSupport.ajc$interFieldInit$org_apache_axiom_om_impl_common_OMTextSupport$org_apache_axiom_om_impl_common_IText$binary(this);
        this.contentID = contentID;
        this.dataHandlerObject = dataHandlerProvider;
        this.setBinary(true);
        this.setOptimize(optimize);
    }

    public TextNodeImpl(OMFactory factory) {
        super(factory);
        OMTextSupport.ajc$interFieldInit$org_apache_axiom_om_impl_common_OMTextSupport$org_apache_axiom_om_impl_common_IText$optimize(this);
        OMTextSupport.ajc$interFieldInit$org_apache_axiom_om_impl_common_OMTextSupport$org_apache_axiom_om_impl_common_IText$binary(this);
    }

    public TextNodeImpl(char[] value, OMFactory factory) {
        super(factory);
        OMTextSupport.ajc$interFieldInit$org_apache_axiom_om_impl_common_OMTextSupport$org_apache_axiom_om_impl_common_IText$optimize(this);
        OMTextSupport.ajc$interFieldInit$org_apache_axiom_om_impl_common_OMTextSupport$org_apache_axiom_om_impl_common_IText$binary(this);
        this.charArray = value;
    }

    public TextNodeImpl(OMContainer parent, QName text, OMFactory factory) {
        this(parent, text, 4, factory);
    }

    public TextNodeImpl(OMContainer parent, QName text, int nodeType, OMFactory factory) {
        this(factory);
        OMNamespace textNS = ((ElementImpl)parent).handleNamespace(text.getNamespaceURI(), text.getPrefix());
        this.textValue = textNS == null ? text.getLocalPart() : String.valueOf(textNS.getPrefix()) + ":" + text.getLocalPart();
    }

    public Text splitText(int offset) throws DOMException {
        if (offset < 0 || offset > this.textValue.length()) {
            throw DOMExceptionUtil.newDOMException((short)1);
        }
        String newValue = this.textValue.substring(offset);
        DOMCharacterDataSupport.ajc$interMethodDispatch1$org_apache_axiom_dom_DOMCharacterDataSupport$org_apache_axiom_dom_DOMCharacterData$deleteData(this, offset, this.textValue.length());
        TextImpl newText = (TextImpl)this.getOwnerDocument().createTextNode(newValue);
        ParentNode parentNode = (ParentNode)CoreChildNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreGetParent(this);
        if (parentNode != null) {
            this.insertSiblingAfter(newText);
        }
        return newText;
    }

    public String getText() {
        if (this.charArray != null || this.textValue != null) {
            return this.getTextFromProperPlace();
        }
        try {
            return Base64Utils.encode((DataHandler)((DataHandler)this.getDataHandler()));
        }
        catch (Exception e) {
            throw new OMException((Throwable)e);
        }
    }

    public String getData() throws DOMException {
        return this.getText();
    }

    public char[] getTextCharacters() {
        if (this.charArray != null) {
            return this.charArray;
        }
        if (this.textValue != null) {
            return this.textValue.toCharArray();
        }
        try {
            return Base64Utils.encodeToCharArray((DataHandler)((DataHandler)this.getDataHandler()));
        }
        catch (IOException ex) {
            throw new OMException((Throwable)ex);
        }
    }

    public boolean isCharacters() {
        return this.charArray != null;
    }

    private String getTextFromProperPlace() {
        return this.charArray != null ? new String(this.charArray) : this.textValue;
    }

    public QName getTextAsQName() {
        return ((OMElement)CoreChildNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreGetParent(this)).resolveQName(this.getTextFromProperPlace());
    }

    public String getContentID() {
        if (this.contentID == null) {
            this.contentID = UIDGenerator.generateContentId();
        }
        return this.contentID;
    }

    public Object getDataHandler() {
        if ((this.textValue != null || this.charArray != null) & this.isBinary()) {
            return DataHandlerUtils.getDataHandlerFromText((String)this.getTextFromProperPlace(), (String)this.mimeType);
        }
        if (this.dataHandlerObject == null) {
            throw new OMException("No DataHandler available");
        }
        if (this.dataHandlerObject instanceof DataHandlerProvider) {
            try {
                this.dataHandlerObject = ((DataHandlerProvider)this.dataHandlerObject).getDataHandler();
            }
            catch (IOException ex) {
                throw new OMException((Throwable)ex);
            }
        }
        return this.dataHandlerObject;
    }

    public void internalSerialize(Serializer serializer, OMOutputFormat format, boolean cache) throws OutputException {
        if (!this.isBinary()) {
            serializer.writeText(this.getType(), this.getText());
        } else if (this.dataHandlerObject instanceof DataHandlerProvider) {
            serializer.writeDataHandler((DataHandlerProvider)this.dataHandlerObject, this.contentID, this.isOptimized());
        } else {
            serializer.writeDataHandler((DataHandler)this.getDataHandler(), this.contentID, this.isOptimized());
        }
    }

    public boolean isElementContentWhitespace() {
        throw new UnsupportedOperationException("TODO");
    }

    public String toString() {
        return this.textValue != null ? this.textValue : "";
    }

    public void buildWithAttachments() {
        this.build();
        if (this.isOptimized()) {
            ((DataHandler)this.getDataHandler()).getDataSource();
        }
    }

    public OMNamespace getNamespace() {
        QName qname = this.getTextAsQName();
        if (qname == null) {
            return null;
        }
        String namespaceURI = qname.getNamespaceURI();
        return namespaceURI.length() == 0 ? null : new OMNamespaceImpl(namespaceURI, qname.getPrefix());
    }

    public void setContentID(String cid) {
        this.contentID = cid;
    }

    void beforeClone(OMCloneOptions options) {
        if (this.isBinary() && options.isFetchDataHandlers()) {
            ((DataHandler)this.getDataHandler()).getDataSource();
        }
    }

    public /* synthetic */ boolean ajc$interFieldGet$org_apache_axiom_om_impl_common_OMTextSupport$org_apache_axiom_om_impl_common_IText$optimize() {
        return this.optimize;
    }

    public /* synthetic */ void ajc$interFieldSet$org_apache_axiom_om_impl_common_OMTextSupport$org_apache_axiom_om_impl_common_IText$optimize(boolean bl) {
        this.optimize = bl;
    }

    public /* synthetic */ boolean ajc$interFieldGet$org_apache_axiom_om_impl_common_OMTextSupport$org_apache_axiom_om_impl_common_IText$binary() {
        return this.binary;
    }

    public /* synthetic */ void ajc$interFieldSet$org_apache_axiom_om_impl_common_OMTextSupport$org_apache_axiom_om_impl_common_IText$binary(boolean bl) {
        this.binary = bl;
    }

    public /* synthetic */ DOMTextNode ajc$interMethodDispatch2$org_apache_axiom_dom_DOMTextNodeSupport$getWholeTextEndNode() {
        return DOMTextNodeSupport.ajc$interMethod$org_apache_axiom_dom_DOMTextNodeSupport$org_apache_axiom_dom_DOMTextNode$getWholeTextEndNode(this);
    }

    public /* synthetic */ DOMTextNode ajc$interMethodDispatch2$org_apache_axiom_dom_DOMTextNodeSupport$getWholeTextStartNode() {
        return DOMTextNodeSupport.ajc$interMethod$org_apache_axiom_dom_DOMTextNodeSupport$org_apache_axiom_dom_DOMTextNode$getWholeTextStartNode(this);
    }

    public final String getWholeText() {
        return DOMTextNodeSupport.ajc$interMethod$org_apache_axiom_dom_DOMTextNodeSupport$org_apache_axiom_dom_DOMTextNode$getWholeText(this);
    }

    public final boolean isBinary() {
        return OMTextSupport.ajc$interMethod$org_apache_axiom_om_impl_common_OMTextSupport$org_apache_axiom_om_impl_common_IText$isBinary(this);
    }

    public final boolean isOptimized() {
        return OMTextSupport.ajc$interMethod$org_apache_axiom_om_impl_common_OMTextSupport$org_apache_axiom_om_impl_common_IText$isOptimized(this);
    }

    public final Text replaceWholeText(String string) throws DOMException {
        return DOMTextNodeSupport.ajc$interMethod$org_apache_axiom_dom_DOMTextNodeSupport$org_apache_axiom_dom_DOMTextNode$replaceWholeText(this, string);
    }

    public final void setBinary(boolean bl) {
        OMTextSupport.ajc$interMethod$org_apache_axiom_om_impl_common_OMTextSupport$org_apache_axiom_om_impl_common_IText$setBinary(this, bl);
    }

    public final void setOptimize(boolean bl) {
        OMTextSupport.ajc$interMethod$org_apache_axiom_om_impl_common_OMTextSupport$org_apache_axiom_om_impl_common_IText$setOptimize(this, bl);
    }
}

