/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom.factory;

import javax.xml.namespace.QName;
import org.apache.axiom.core.CoreCharacterData;
import org.apache.axiom.core.CoreDocument;
import org.apache.axiom.core.NodeFactory;
import org.apache.axiom.ext.stax.datahandler.DataHandlerProvider;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMDocType;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMEntityReference;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMHierarchyException;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMProcessingInstruction;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.OMContainerEx;
import org.apache.axiom.om.impl.builder.OMFactoryEx;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.common.OMNamespaceImpl;
import org.apache.axiom.om.impl.dom.AttrImpl;
import org.apache.axiom.om.impl.dom.CDATASectionImpl;
import org.apache.axiom.om.impl.dom.CommentImpl;
import org.apache.axiom.om.impl.dom.DocumentImpl;
import org.apache.axiom.om.impl.dom.DocumentTypeImpl;
import org.apache.axiom.om.impl.dom.ElementImpl;
import org.apache.axiom.om.impl.dom.EntityReferenceImpl;
import org.apache.axiom.om.impl.dom.OMDOMException;
import org.apache.axiom.om.impl.dom.ParentNode;
import org.apache.axiom.om.impl.dom.ProcessingInstructionImpl;
import org.apache.axiom.om.impl.dom.TextImpl;
import org.apache.axiom.om.impl.dom.TextNodeImpl;
import org.apache.axiom.om.impl.dom.factory.OMDOMMetaFactory;
import org.apache.axiom.om.impl.util.OMSerializerUtil;

public class OMDOMFactory
implements OMFactoryEx,
NodeFactory {
    private final OMDOMMetaFactory metaFactory;

    public OMDOMFactory(OMDOMMetaFactory metaFactory) {
        this.metaFactory = metaFactory;
    }

    public OMDOMFactory() {
        this(new OMDOMMetaFactory());
    }

    public OMMetaFactory getMetaFactory() {
        return this.metaFactory;
    }

    public OMDocument createOMDocument() {
        return new DocumentImpl((OMFactory)this);
    }

    public OMElement createOMElement(String localName, OMNamespace ns) {
        return new ElementImpl(null, localName, ns, null, (OMFactory)this, true);
    }

    public OMElement createOMElement(String localName, OMNamespace ns, OMContainer parent) throws OMDOMException {
        if (parent == null) {
            return this.createOMElement(localName, ns);
        }
        return new ElementImpl((ParentNode)parent, localName, ns, null, (OMFactory)this, true);
    }

    public OMElement createOMElement(String localName, OMContainer parent, OMXMLParserWrapper builder) {
        return new ElementImpl((ParentNode)parent, localName, null, builder, (OMFactory)this, false);
    }

    public OMSourcedElement createOMElement(OMDataSource source) {
        throw new UnsupportedOperationException("Not supported for DOM");
    }

    public OMElement createOMElement(OMDataSource source, String localName, OMNamespace ns, OMContainer parent) {
        throw new UnsupportedOperationException("Not supported for DOM");
    }

    public OMSourcedElement createOMElement(OMDataSource source, String localName, OMNamespace ns) {
        throw new UnsupportedOperationException("Not supported for DOM");
    }

    public OMSourcedElement createOMElement(OMDataSource source, QName qname) {
        throw new UnsupportedOperationException("Not supported for DOM");
    }

    public OMElement createOMElement(String localName, String namespaceURI, String prefix) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("namespaceURI must not be null");
        }
        if (namespaceURI.length() == 0) {
            if (prefix != null && prefix.length() > 0) {
                throw new IllegalArgumentException("Cannot create a prefixed element with an empty namespace name");
            }
            return this.createOMElement(localName, null);
        }
        return this.createOMElement(localName, this.createOMNamespace(namespaceURI, prefix));
    }

    public OMElement createOMElement(QName qname, OMContainer parent) throws OMException {
        OMNamespaceImpl ns;
        if (qname.getNamespaceURI().length() == 0) {
            if (qname.getPrefix().length() > 0) {
                throw new IllegalArgumentException("Cannot create a prefixed element with an empty namespace name");
            }
            ns = null;
        } else {
            ns = qname.getPrefix().length() != 0 ? new OMNamespaceImpl(qname.getNamespaceURI(), qname.getPrefix()) : new OMNamespaceImpl(qname.getNamespaceURI(), null);
        }
        return this.createOMElement(qname.getLocalPart(), ns, parent);
    }

    public OMElement createOMElement(QName qname) throws OMException {
        return this.createOMElement(qname, null);
    }

    public OMNamespace createOMNamespace(String uri, String prefix) {
        return new OMNamespaceImpl(uri, prefix);
    }

    public OMText createOMText(OMContainer parent, String text) {
        return this.createOMText(parent, text, 4);
    }

    public OMText createOMText(OMContainer parent, QName text) {
        return this.createOMText(parent, text, 4);
    }

    public OMText createOMText(OMContainer parent, QName text, int type) {
        TextImpl txt = new TextImpl(parent, text, type, (OMFactory)this);
        parent.addChild((OMNode)txt);
        return txt;
    }

    public OMText createOMText(OMContainer parent, String text, int type) {
        return this.createOMText(parent, text, type, false);
    }

    public OMText createOMText(OMContainer parent, String text, int type, boolean fromBuilder) {
        if (parent == null) {
            return this.createOMText(text, type);
        }
        if (parent instanceof DocumentImpl) {
            throw new OMHierarchyException("DOM doesn't support text nodes as children of a document");
        }
        TextNodeImpl txt = type == 12 ? new CDATASectionImpl(text, (OMFactory)this) : new TextImpl(text, type, (OMFactory)this);
        ((OMContainerEx)parent).addChild((OMNode)txt, fromBuilder);
        return txt;
    }

    public OMText createOMText(OMContainer parent, OMText source) {
        TextImpl text = new TextImpl((TextImpl)source, (OMFactory)this);
        parent.addChild((OMNode)text);
        return text;
    }

    public OMText createOMText(OMContainer parent, char[] charArary, int type) {
        TextImpl txt = new TextImpl(charArary, (OMFactory)this);
        parent.addChild((OMNode)txt);
        return txt;
    }

    public OMText createOMText(String s) {
        return new TextImpl(s, (OMFactory)this);
    }

    public OMText createOMText(String text, int type) {
        if (type == 12) {
            return new CDATASectionImpl(text, (OMFactory)this);
        }
        return new TextImpl(text, (OMFactory)this);
    }

    public OMText createOMText(String text, String mimeType, boolean optimize) {
        return new TextImpl(text, mimeType, optimize, (OMFactory)this);
    }

    public OMText createOMText(Object dataHandler, boolean optimize) {
        return this.createOMText(null, dataHandler, optimize, false);
    }

    public OMText createOMText(OMContainer parent, Object dataHandler, boolean optimize, boolean fromBuilder) {
        TextImpl text = new TextImpl(dataHandler, optimize, (OMFactory)this);
        if (parent != null) {
            ((OMContainerEx)parent).addChild((OMNode)text, fromBuilder);
        }
        return text;
    }

    public OMText createOMText(String contentID, DataHandlerProvider dataHandlerProvider, boolean optimize) {
        return new TextImpl(contentID, dataHandlerProvider, optimize, (OMFactory)this);
    }

    public OMText createOMText(OMContainer parent, String s, String mimeType, boolean optimize) {
        TextImpl text = new TextImpl(s, mimeType, optimize, (OMFactory)this);
        parent.addChild((OMNode)text);
        return text;
    }

    public OMAttribute createOMAttribute(String localName, OMNamespace ns, String value) {
        if (ns != null && ns.getPrefix() == null) {
            String namespaceURI = ns.getNamespaceURI();
            ns = namespaceURI.length() == 0 ? null : new OMNamespaceImpl(namespaceURI, OMSerializerUtil.getNextNSPrefix());
        }
        return new AttrImpl(null, localName, (OMNamespace)ns, value, (OMFactory)this);
    }

    public OMDocType createOMDocType(OMContainer parent, String rootName, String publicId, String systemId, String internalSubset) {
        return this.createOMDocType(parent, rootName, publicId, systemId, internalSubset, false);
    }

    public OMDocType createOMDocType(OMContainer parent, String rootName, String publicId, String systemId, String internalSubset, boolean fromBuilder) {
        DocumentTypeImpl docType = new DocumentTypeImpl(rootName, publicId, systemId, internalSubset, (OMFactory)this);
        if (parent != null) {
            ((OMContainerEx)parent).addChild((OMNode)docType, fromBuilder);
        }
        return docType;
    }

    public OMProcessingInstruction createOMProcessingInstruction(OMContainer parent, String piTarget, String piData) {
        return this.createOMProcessingInstruction(parent, piTarget, piData, false);
    }

    public OMProcessingInstruction createOMProcessingInstruction(OMContainer parent, String piTarget, String piData, boolean fromBuilder) {
        ProcessingInstructionImpl pi = new ProcessingInstructionImpl(piTarget, piData, (OMFactory)this);
        if (parent != null) {
            ((OMContainerEx)parent).addChild((OMNode)pi, fromBuilder);
        }
        return pi;
    }

    public OMComment createOMComment(OMContainer parent, String content) {
        return this.createOMComment(parent, content, false);
    }

    public OMComment createOMComment(OMContainer parent, String content, boolean fromBuilder) {
        CommentImpl comment = new CommentImpl(content, (OMFactory)this);
        if (parent != null) {
            ((OMContainerEx)parent).addChild((OMNode)comment, fromBuilder);
        }
        return comment;
    }

    public OMDocument createOMDocument(OMXMLParserWrapper builder) {
        return new DocumentImpl(builder, (OMFactory)this);
    }

    public OMEntityReference createOMEntityReference(OMContainer parent, String name) {
        return this.createOMEntityReference(parent, name, null, false);
    }

    public OMEntityReference createOMEntityReference(OMContainer parent, String name, String replacementText, boolean fromBuilder) {
        EntityReferenceImpl node = new EntityReferenceImpl(name, replacementText, (OMFactory)this);
        if (parent != null) {
            ((OMContainerEx)parent).addChild((OMNode)node, fromBuilder);
        }
        return node;
    }

    public OMNode importNode(OMNode child) {
        int type = child.getType();
        switch (type) {
            case 1: {
                OMElement childElement = (OMElement)child;
                OMElement newElement = new StAXOMBuilder((OMFactory)this, childElement.getXMLStreamReader()).getDocumentElement();
                newElement.build();
                return newElement;
            }
            case 4: {
                OMText newText;
                OMText importedText = (OMText)child;
                if (importedText.isBinary()) {
                    boolean isOptimize = importedText.isOptimized();
                    newText = this.createOMText(importedText.getDataHandler(), isOptimize);
                } else {
                    newText = importedText.isCharacters() ? new TextImpl(importedText.getTextCharacters(), (OMFactory)this) : new TextImpl(importedText.getText(), (OMFactory)this);
                }
                return newText;
            }
            case 3: {
                OMProcessingInstruction importedPI = (OMProcessingInstruction)child;
                OMProcessingInstruction newPI = this.createOMProcessingInstruction(null, importedPI.getTarget(), importedPI.getValue());
                return newPI;
            }
            case 5: {
                OMComment importedComment = (OMComment)child;
                OMComment newComment = this.createOMComment(null, importedComment.getValue());
                newComment = new CommentImpl(importedComment.getValue(), (OMFactory)this);
                return newComment;
            }
            case 11: {
                OMDocType importedDocType = (OMDocType)child;
                return this.createOMDocType(null, importedDocType.getRootName(), importedDocType.getPublicId(), importedDocType.getSystemId(), importedDocType.getInternalSubset());
            }
        }
        throw new UnsupportedOperationException("Not Implemented Yet for the given node type");
    }

    public final CoreDocument createDocument() {
        return new DocumentImpl((OMFactory)this);
    }

    public final CoreCharacterData createCharacterData() {
        return new TextImpl((OMFactory)this);
    }
}

