/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom;

import org.apache.axiom.core.CoreChildNode;
import org.apache.axiom.core.CoreChildNodeSupport;
import org.apache.axiom.core.CoreDocument;
import org.apache.axiom.core.CoreDocumentFragment;
import org.apache.axiom.core.CoreNodeSupport;
import org.apache.axiom.core.CoreParentNodeSupport;
import org.apache.axiom.dom.DOMConfigurationImpl;
import org.apache.axiom.dom.DOMExceptionUtil;
import org.apache.axiom.dom.DOMParentNode;
import org.apache.axiom.dom.DOMParentNodeSupport;
import org.apache.axiom.om.OMCloneOptions;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.impl.common.AxiomDocumentSupport;
import org.apache.axiom.om.impl.dom.CommentImpl;
import org.apache.axiom.om.impl.dom.DocumentFragmentImpl;
import org.apache.axiom.om.impl.dom.DocumentImpl;
import org.apache.axiom.om.impl.dom.DocumentTypeImpl;
import org.apache.axiom.om.impl.dom.ElementImpl;
import org.apache.axiom.om.impl.dom.NodeImpl;
import org.apache.axiom.om.impl.dom.ProcessingInstructionImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ParentNode
extends NodeImpl
implements DOMParentNode {
    public CoreChildNode firstChild;
    public CoreChildNode lastChild;

    protected ParentNode(OMFactory factory) {
        super(factory);
        CoreParentNodeSupport.ajc$interFieldInit$org_apache_axiom_core_CoreParentNodeSupport$org_apache_axiom_core_CoreParentNode$firstChild(this);
        CoreParentNodeSupport.ajc$interFieldInit$org_apache_axiom_core_CoreParentNodeSupport$org_apache_axiom_core_CoreParentNode$lastChild(this);
    }

    public final Node appendChild(Node newChild) throws DOMException {
        this.checkNewChild(newChild, null);
        if (newChild instanceof CoreChildNode) {
            CoreParentNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreParentNodeSupport$org_apache_axiom_core_CoreParentNode$coreAppendChild(this, (CoreChildNode)((Object)newChild), false);
        } else if (newChild instanceof CoreDocumentFragment) {
            CoreParentNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreParentNodeSupport$org_apache_axiom_core_CoreParentNode$coreAppendChildren(this, (CoreDocumentFragment)((Object)newChild));
        } else {
            throw DOMExceptionUtil.newDOMException((short)3);
        }
        return newChild;
    }

    private void checkNewChild(Node newChild, Node replacedChild) {
        NodeImpl newDomChild = (NodeImpl)newChild;
        this.checkSameOwnerDocument(newDomChild);
        if (this.isAncestorOrSelf(newChild)) {
            throw DOMExceptionUtil.newDOMException((short)3);
        }
        if (this instanceof Document) {
            if (newDomChild instanceof ElementImpl) {
                if (!(replacedChild instanceof Element) && AxiomDocumentSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomDocumentSupport$org_apache_axiom_om_impl_common_AxiomDocument$getOMDocumentElement((DocumentImpl)this) != null) {
                    throw DOMExceptionUtil.newDOMException((short)3);
                }
                if (newDomChild.parentNode() == null) {
                    newDomChild.setParent(this);
                }
            } else if (!(newDomChild instanceof CommentImpl || newDomChild instanceof ProcessingInstructionImpl || newDomChild instanceof DocumentFragmentImpl || newDomChild instanceof DocumentTypeImpl)) {
                throw DOMExceptionUtil.newDOMException((short)3);
            }
        }
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        if (refChild == null) {
            return this.appendChild(newChild);
        }
        if (!(refChild instanceof CoreChildNode) || CoreChildNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreGetParent((CoreChildNode)((Object)refChild)) != this) {
            throw DOMExceptionUtil.newDOMException((short)8);
        }
        this.checkNewChild(newChild, null);
        if (newChild instanceof CoreChildNode) {
            CoreChildNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreInsertSiblingBefore((CoreChildNode)((Object)refChild), (CoreChildNode)((Object)newChild));
        } else if (newChild instanceof CoreDocumentFragment) {
            CoreChildNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreInsertSiblingsBefore((CoreChildNode)((Object)refChild), (CoreDocumentFragment)((Object)newChild));
        } else {
            throw DOMExceptionUtil.newDOMException((short)3);
        }
        return newChild;
    }

    public final Node replaceChild(Node newChild, Node _oldChild) throws DOMException {
        if (!(_oldChild instanceof CoreChildNode)) {
            throw DOMExceptionUtil.newDOMException((short)8);
        }
        CoreChildNode oldChild = (CoreChildNode)((Object)_oldChild);
        if (CoreChildNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreGetParent(oldChild) != this) {
            throw DOMExceptionUtil.newDOMException((short)8);
        }
        this.checkNewChild(newChild, _oldChild);
        CoreChildNode nextSibling = CoreChildNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreGetNextSibling(oldChild);
        CoreChildNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreDetach(oldChild, CoreNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreNodeSupport$org_apache_axiom_core_CoreNode$coreGetOwnerDocument(this, true));
        if (newChild instanceof CoreChildNode) {
            if (nextSibling == null) {
                CoreParentNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreParentNodeSupport$org_apache_axiom_core_CoreParentNode$coreAppendChild(this, (CoreChildNode)((Object)newChild), false);
            } else {
                CoreChildNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreInsertSiblingBefore(nextSibling, (CoreChildNode)((Object)newChild));
            }
        } else if (newChild instanceof CoreDocumentFragment) {
            if (nextSibling == null) {
                CoreParentNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreParentNodeSupport$org_apache_axiom_core_CoreParentNode$coreAppendChildren(this, (CoreDocumentFragment)((Object)newChild));
            } else {
                CoreChildNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreInsertSiblingsBefore(nextSibling, (CoreDocumentFragment)((Object)newChild));
            }
        } else {
            throw DOMExceptionUtil.newDOMException((short)3);
        }
        return _oldChild;
    }

    private boolean isAncestorOrSelf(Node node) {
        Node currentNode = this;
        do {
            if (currentNode != node) continue;
            return true;
        } while ((currentNode = currentNode.getParentNode()) != null);
        return false;
    }

    final NodeImpl clone(OMCloneOptions options, ParentNode targetParent, boolean deep, boolean namespaceRepairing) {
        ParentNode clone = this.shallowClone(options, targetParent, namespaceRepairing);
        if (deep) {
            Node child = DOMParentNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_dom_DOMParentNodeSupport$org_apache_axiom_dom_DOMParentNode$getFirstChild(this);
            while (child != null) {
                ((NodeImpl)child).clone(options, clone, true, namespaceRepairing);
                child = child.getNextSibling();
            }
        }
        return clone;
    }

    abstract ParentNode shallowClone(OMCloneOptions var1, ParentNode var2, boolean var3);

    public String getTextContent() throws DOMException {
        Node child = DOMParentNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_dom_DOMParentNodeSupport$org_apache_axiom_dom_DOMParentNode$getFirstChild(this);
        if (child != null) {
            Node next = child.getNextSibling();
            if (next == null) {
                return ParentNode.hasTextContent(child) ? ((NodeImpl)child).getTextContent() : "";
            }
            StringBuffer buf = new StringBuffer();
            this.getTextContent(buf);
            return buf.toString();
        }
        return "";
    }

    void getTextContent(StringBuffer buf) throws DOMException {
        Node child = DOMParentNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_dom_DOMParentNodeSupport$org_apache_axiom_dom_DOMParentNode$getFirstChild(this);
        while (child != null) {
            if (ParentNode.hasTextContent(child)) {
                ((NodeImpl)child).getTextContent(buf);
            }
            child = child.getNextSibling();
        }
    }

    private static boolean hasTextContent(Node child) {
        return child.getNodeType() != 8 && child.getNodeType() != 7;
    }

    public void setTextContent(String textContent) throws DOMException {
        CoreParentNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreParentNodeSupport$org_apache_axiom_core_CoreParentNode$coreRemoveChildren(this, CoreNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreNodeSupport$org_apache_axiom_core_CoreNode$coreGetOwnerDocument(this, true));
        if (textContent != null && textContent.length() != 0) {
            CoreParentNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreParentNodeSupport$org_apache_axiom_core_CoreParentNode$coreAppendChild(this, (CoreChildNode)this.getOMFactory().createOMText(textContent), false);
        }
    }

    public /* synthetic */ CoreChildNode ajc$interFieldGet$org_apache_axiom_core_CoreParentNodeSupport$org_apache_axiom_core_CoreParentNode$firstChild() {
        return this.firstChild;
    }

    public /* synthetic */ void ajc$interFieldSet$org_apache_axiom_core_CoreParentNodeSupport$org_apache_axiom_core_CoreParentNode$firstChild(CoreChildNode coreChildNode) {
        this.firstChild = coreChildNode;
    }

    public /* synthetic */ CoreChildNode ajc$interFieldGet$org_apache_axiom_core_CoreParentNodeSupport$org_apache_axiom_core_CoreParentNode$lastChild() {
        return this.lastChild;
    }

    public /* synthetic */ void ajc$interFieldSet$org_apache_axiom_core_CoreParentNodeSupport$org_apache_axiom_core_CoreParentNode$lastChild(CoreChildNode coreChildNode) {
        this.lastChild = coreChildNode;
    }

    public void buildNext() {
        CoreParentNodeSupport.ajc$interMethod$org_apache_axiom_core_CoreParentNodeSupport$org_apache_axiom_core_CoreParentNode$buildNext(this);
    }

    public final void coreAppendChild(CoreChildNode coreChildNode, boolean bl) {
        CoreParentNodeSupport.ajc$interMethod$org_apache_axiom_core_CoreParentNodeSupport$org_apache_axiom_core_CoreParentNode$coreAppendChild(this, coreChildNode, bl);
    }

    public final void coreAppendChildren(CoreDocumentFragment coreDocumentFragment) {
        CoreParentNodeSupport.ajc$interMethod$org_apache_axiom_core_CoreParentNodeSupport$org_apache_axiom_core_CoreParentNode$coreAppendChildren(this, coreDocumentFragment);
    }

    public CoreChildNode coreGetFirstChild() {
        return CoreParentNodeSupport.ajc$interMethod$org_apache_axiom_core_CoreParentNodeSupport$org_apache_axiom_core_CoreParentNode$coreGetFirstChild(this);
    }

    public final CoreChildNode coreGetFirstChildIfAvailable() {
        return CoreParentNodeSupport.ajc$interMethod$org_apache_axiom_core_CoreParentNodeSupport$org_apache_axiom_core_CoreParentNode$coreGetFirstChildIfAvailable(this);
    }

    public final CoreChildNode coreGetLastChild() {
        return CoreParentNodeSupport.ajc$interMethod$org_apache_axiom_core_CoreParentNodeSupport$org_apache_axiom_core_CoreParentNode$coreGetLastChild(this);
    }

    public CoreChildNode coreGetLastKnownChild() {
        return CoreParentNodeSupport.ajc$interMethod$org_apache_axiom_core_CoreParentNodeSupport$org_apache_axiom_core_CoreParentNode$coreGetLastKnownChild(this);
    }

    public final void coreRemoveChildren(CoreDocument coreDocument) {
        CoreParentNodeSupport.ajc$interMethod$org_apache_axiom_core_CoreParentNodeSupport$org_apache_axiom_core_CoreParentNode$coreRemoveChildren(this, coreDocument);
    }

    public void forceExpand() {
        CoreParentNodeSupport.ajc$interMethod$org_apache_axiom_core_CoreParentNodeSupport$org_apache_axiom_core_CoreParentNode$forceExpand(this);
    }

    public final NodeList getChildNodes() {
        return DOMParentNodeSupport.ajc$interMethod$org_apache_axiom_dom_DOMParentNodeSupport$org_apache_axiom_dom_DOMParentNode$getChildNodes(this);
    }

    public final Node getFirstChild() {
        return DOMParentNodeSupport.ajc$interMethod$org_apache_axiom_dom_DOMParentNodeSupport$org_apache_axiom_dom_DOMParentNode$getFirstChild(this);
    }

    public final Node getLastChild() {
        return DOMParentNodeSupport.ajc$interMethod$org_apache_axiom_dom_DOMParentNodeSupport$org_apache_axiom_dom_DOMParentNode$getLastChild(this);
    }

    public final int getLength() {
        return DOMParentNodeSupport.ajc$interMethod$org_apache_axiom_dom_DOMParentNodeSupport$org_apache_axiom_dom_DOMParentNode$getLength(this);
    }

    public final boolean hasChildNodes() {
        return DOMParentNodeSupport.ajc$interMethod$org_apache_axiom_dom_DOMParentNodeSupport$org_apache_axiom_dom_DOMParentNode$hasChildNodes(this);
    }

    public final Node item(int n) {
        return DOMParentNodeSupport.ajc$interMethod$org_apache_axiom_dom_DOMParentNodeSupport$org_apache_axiom_dom_DOMParentNode$item(this, n);
    }

    public void normalize(DOMConfigurationImpl dOMConfigurationImpl) {
        DOMParentNodeSupport.ajc$interMethod$org_apache_axiom_dom_DOMParentNodeSupport$org_apache_axiom_dom_DOMParentNode$normalize(this, dOMConfigurationImpl);
    }

    public final Node removeChild(Node node) throws DOMException {
        return DOMParentNodeSupport.ajc$interMethod$org_apache_axiom_dom_DOMParentNodeSupport$org_apache_axiom_dom_DOMParentNode$removeChild(this, node);
    }
}

