/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap.impl.common;

import javax.xml.namespace.QName;
import org.apache.axiom.soap.SOAP11Version;
import org.apache.axiom.soap.SOAP12Version;
import org.apache.axiom.soap.SOAPVersion;

abstract class SOAPHelper {
    static final SOAPHelper SOAP11 = new SOAPHelper((SOAPVersion)SOAP11Version.getSingleton(), "SOAP 1.1", "actor", null){

        public Boolean parseBoolean(String literal) {
            if (literal.equals("1")) {
                return Boolean.TRUE;
            }
            if (literal.equals("0")) {
                return Boolean.FALSE;
            }
            return null;
        }

        public String formatBoolean(boolean value) {
            return value ? "1" : "0";
        }
    };
    static final SOAPHelper SOAP12 = new SOAPHelper((SOAPVersion)SOAP12Version.getSingleton(), "SOAP 1.2", "role", "relay"){

        public Boolean parseBoolean(String literal) {
            if (literal.equals("true") || literal.equals("1")) {
                return Boolean.TRUE;
            }
            if (literal.equals("false") || literal.equals("0")) {
                return Boolean.FALSE;
            }
            return null;
        }

        public String formatBoolean(boolean value) {
            return String.valueOf(value);
        }
    };
    private final SOAPVersion version;
    private final String specName;
    private final QName mustUnderstandAttributeQName;
    private final QName roleAttributeQName;
    private final QName relayAttributeQName;

    private SOAPHelper(SOAPVersion version, String specName, String roleAttributeLocalName, String relayAttributeLocalName) {
        this.version = version;
        this.specName = specName;
        this.mustUnderstandAttributeQName = new QName(version.getEnvelopeURI(), "mustUnderstand", "soapenv");
        this.roleAttributeQName = new QName(version.getEnvelopeURI(), roleAttributeLocalName, "soapenv");
        this.relayAttributeQName = relayAttributeLocalName == null ? null : new QName(version.getEnvelopeURI(), relayAttributeLocalName, "soapenv");
    }

    final SOAPVersion getVersion() {
        return this.version;
    }

    final String getSpecName() {
        return this.specName;
    }

    final QName getMustUnderstandAttributeQName() {
        return this.mustUnderstandAttributeQName;
    }

    final QName getRoleAttributeQName() {
        return this.roleAttributeQName;
    }

    final QName getRelayAttributeQName() {
        return this.relayAttributeQName;
    }

    abstract Boolean parseBoolean(String var1);

    abstract String formatBoolean(boolean var1);

    /* synthetic */ SOAPHelper(SOAPVersion sOAPVersion, String string, String string2, String string3, SOAPHelper sOAPHelper) {
        this(sOAPVersion, string, string2, string3);
    }
}

