/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom;

import java.util.Hashtable;
import org.apache.axiom.core.ClonePolicy;
import org.apache.axiom.core.CoreDocument;
import org.apache.axiom.core.CoreNode;
import org.apache.axiom.core.CoreNodeSupport;
import org.apache.axiom.dom.DOMConfigurationImpl;
import org.apache.axiom.dom.DOMExceptionTranslator;
import org.apache.axiom.dom.DOMNode;
import org.apache.axiom.dom.DOMNodeSupport;
import org.apache.axiom.dom.Policies;
import org.apache.axiom.om.OMCloneOptions;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMInformationItem;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.dom.DocumentImpl;
import org.apache.axiom.om.impl.dom.ParentNode;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.UserDataHandler;

public abstract class NodeImpl
implements DOMNode {
    private Hashtable userData;
    private OMFactory factory;
    public int flags;

    protected NodeImpl(OMFactory factory) {
        CoreNodeSupport.ajc$interFieldInit$org_apache_axiom_core_CoreNodeSupport$org_apache_axiom_core_CoreNode$flags(this);
        this.factory = factory;
    }

    public void normalize() {
    }

    public final Node cloneNode(boolean deep) {
        OMCloneOptions options = new OMCloneOptions();
        options.setPreserveModel(true);
        NodeImpl clone = this.clone(options, null, deep ? Policies.DEEP_CLONE : Policies.SHALLOW_CLONE);
        if (!(clone instanceof DocumentImpl)) {
            clone.coreSetOwnerDocument(this.ownerDocument());
        }
        return clone;
    }

    public String getBaseURI() {
        throw new UnsupportedOperationException("TODO");
    }

    public short compareDocumentPosition(Node other) throws DOMException {
        throw DOMExceptionTranslator.newDOMException((short)9);
    }

    public boolean isSameNode(Node node) {
        return this == node;
    }

    public boolean isEqualNode(Node node) {
        if (this.getNodeType() != node.getNodeType()) {
            return false;
        }
        if (this.checkStringAttributeEquality(node)) {
            return this.checkNamedNodeMapEquality(node);
        }
        return false;
    }

    private boolean checkStringAttributeEquality(Node node) {
        if (node.getNodeName() == null ^ this.getNodeName() == null) {
            return false;
        }
        if (node.getNodeName() != null && !node.getNodeName().equals(this.getNodeName())) {
            return false;
        }
        if (node.getLocalName() == null ^ this.getLocalName() == null) {
            return false;
        }
        if (node.getLocalName() != null && !node.getLocalName().equals(this.getLocalName())) {
            return false;
        }
        if (node.getNamespaceURI() == null ^ this.getNamespaceURI() == null) {
            return false;
        }
        if (node.getNamespaceURI() != null && !node.getNamespaceURI().equals(this.getNamespaceURI())) {
            return false;
        }
        if (node.getPrefix() == null ^ this.getPrefix() == null) {
            return false;
        }
        if (node.getPrefix() != null && !node.getPrefix().equals(this.getPrefix())) {
            return false;
        }
        if (node.getNodeValue() == null ^ this.getNodeValue() == null) {
            return false;
        }
        return node.getNodeValue() == null || node.getNodeValue().equals(this.getNodeValue());
    }

    private boolean checkNamedNodeMapEquality(Node node) {
        NamedNodeMap nodeNamedNodeMap;
        if (node.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        NamedNodeMap thisNamedNodeMap = this.getAttributes();
        if (thisNamedNodeMap == null ^ (nodeNamedNodeMap = node.getAttributes()) == null) {
            return false;
        }
        if (thisNamedNodeMap != null) {
            if (thisNamedNodeMap.getLength() != nodeNamedNodeMap.getLength()) {
                return false;
            }
            int itemCount = thisNamedNodeMap.getLength();
            int a = 0;
            while (a < itemCount) {
                NodeImpl thisNode = (NodeImpl)thisNamedNodeMap.item(a);
                NodeImpl tmpNode = (NodeImpl)nodeNamedNodeMap.getNamedItem(thisNode.getNodeName());
                if (tmpNode == null) {
                    return false;
                }
                if (!thisNode.isEqualNode(tmpNode)) {
                    return false;
                }
                ++a;
            }
        }
        return true;
    }

    public Object getFeature(String feature, String version) {
        throw new UnsupportedOperationException("TODO");
    }

    public Object setUserData(String key, Object value, UserDataHandler userDataHandler) {
        if (this.userData == null) {
            this.userData = new Hashtable();
        }
        return this.userData.put(key, value);
    }

    public Object getUserData(String key) {
        if (this.userData != null) {
            return this.userData.get(key);
        }
        return null;
    }

    public final OMFactory getOMFactory() {
        if (this.factory == null) {
            this.factory = ((StAXSOAPModelBuilder)this.getBuilder()).getSOAPFactory();
        }
        return this.factory;
    }

    final DocumentImpl ownerDocument() {
        return (DocumentImpl)CoreNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreNodeSupport$org_apache_axiom_core_CoreNode$coreGetOwnerDocument(this, true);
    }

    void checkSameOwnerDocument(Node otherNode) {
        if (!(otherNode instanceof NodeImpl) || !CoreNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreNodeSupport$org_apache_axiom_core_CoreNode$coreHasSameOwnerDocument(this, (NodeImpl)otherNode)) {
            throw DOMExceptionTranslator.newDOMException((short)4);
        }
    }

    public abstract OMXMLParserWrapper getBuilder();

    public final OMInformationItem clone(OMCloneOptions options) {
        return (OMInformationItem)this.clone(options, null, org.apache.axiom.om.impl.common.Policies.CLONE_POLICY);
    }

    abstract NodeImpl clone(OMCloneOptions var1, ParentNode var2, ClonePolicy var3);

    public /* synthetic */ int ajc$interFieldGet$org_apache_axiom_core_CoreNodeSupport$org_apache_axiom_core_CoreNode$flags() {
        return this.flags;
    }

    public /* synthetic */ void ajc$interFieldSet$org_apache_axiom_core_CoreNodeSupport$org_apache_axiom_core_CoreNode$flags(int n) {
        this.flags = n;
    }

    public /* synthetic */ boolean ajc$interMethodDispatch2$org_apache_axiom_core$getFlag(int n) {
        return CoreNodeSupport.ajc$interMethod$org_apache_axiom_core_CoreNodeSupport$org_apache_axiom_core_CoreNode$getFlag(this, n);
    }

    public /* synthetic */ void ajc$interMethodDispatch2$org_apache_axiom_core$setFlag(int n, boolean bl) {
        CoreNodeSupport.ajc$interMethod$org_apache_axiom_core_CoreNodeSupport$org_apache_axiom_core_CoreNode$setFlag(this, n, bl);
    }

    public final CoreNode coreClone(ClonePolicy clonePolicy, Object object) {
        return CoreNodeSupport.ajc$interMethod$org_apache_axiom_core_CoreNodeSupport$org_apache_axiom_core_CoreNode$coreClone(this, clonePolicy, object);
    }

    public final CoreDocument coreGetOwnerDocument(boolean bl) {
        return CoreNodeSupport.ajc$interMethod$org_apache_axiom_core_CoreNodeSupport$org_apache_axiom_core_CoreNode$coreGetOwnerDocument(this, bl);
    }

    public final boolean coreHasSameOwnerDocument(CoreNode coreNode) {
        return CoreNodeSupport.ajc$interMethod$org_apache_axiom_core_CoreNodeSupport$org_apache_axiom_core_CoreNode$coreHasSameOwnerDocument(this, coreNode);
    }

    public final boolean isDefaultNamespace(String string) {
        return DOMNodeSupport.ajc$interMethod$org_apache_axiom_dom_DOMNodeSupport$org_apache_axiom_dom_DOMNode$isDefaultNamespace(this, string);
    }

    public final boolean isSupported(String string, String string2) {
        return DOMNodeSupport.ajc$interMethod$org_apache_axiom_dom_DOMNodeSupport$org_apache_axiom_dom_DOMNode$isSupported(this, string, string2);
    }

    public final String lookupNamespaceURI(String string) {
        return DOMNodeSupport.ajc$interMethod$org_apache_axiom_dom_DOMNodeSupport$org_apache_axiom_dom_DOMNode$lookupNamespaceURI(this, string);
    }

    public final String lookupPrefix(String string) {
        return DOMNodeSupport.ajc$interMethod$org_apache_axiom_dom_DOMNodeSupport$org_apache_axiom_dom_DOMNode$lookupPrefix(this, string);
    }

    public void normalize(DOMConfigurationImpl dOMConfigurationImpl) {
        DOMNodeSupport.ajc$interMethod$org_apache_axiom_dom_DOMNodeSupport$org_apache_axiom_dom_DOMNode$normalize(this, dOMConfigurationImpl);
    }
}

