/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.dom;

import org.apache.axiom.dom.DOMExceptionTranslator;
import org.w3c.dom.DOMException;

public final class NSUtil {
    private NSUtil() {
    }

    private static boolean isNameStartChar(char c) {
        return c == ':' || 'A' <= c && c <= 'Z' || c == '_' || 'a' <= c && c <= 'z' || '\u00c0' <= c && c <= '\u00d6' || '\u00d8' <= c && c <= '\u00f6' || '\u00f8' <= c && c <= '\u02ff' || '\u0370' <= c && c <= '\u037d' || '\u037f' <= c && c <= '\u1fff' || '\u200c' <= c && c <= '\u200d' || '\u2070' <= c && c <= '\u218f' || '\u2c00' <= c && c <= '\u2fef' || '\u3001' <= c && c <= '\ud7ff' || '\uf900' <= c && c <= '\ufdcf' || '\ufdf0' <= c && c <= '\ufffd' || '\u10000' <= c && c <= '\ueffff';
    }

    private static boolean isNameChar(char c) {
        return NSUtil.isNameStartChar(c) || c == '-' || c == '.' || '0' <= c && c <= '9' || c == '\u00b7' || '\u0300' <= c && c <= '\u036f' || '\u203f' <= c && c <= '\u2040';
    }

    public static void validateName(String name) throws DOMException {
        if (name.length() == 0) {
            throw DOMExceptionTranslator.newDOMException((short)5);
        }
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (i == 0 && !NSUtil.isNameStartChar(c) || i > 0 && !NSUtil.isNameChar(c)) {
                throw DOMExceptionTranslator.newDOMException((short)5);
            }
            ++i;
        }
    }

    public static void validatePrefix(String prefix) throws DOMException {
        int i = 0;
        while (i < prefix.length()) {
            char c = prefix.charAt(i);
            if (c == ':') {
                throw DOMExceptionTranslator.newDOMException((short)14);
            }
            if (i == 0 && !NSUtil.isNameStartChar(c) || i > 0 && !NSUtil.isNameChar(c)) {
                throw DOMExceptionTranslator.newDOMException((short)5);
            }
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int validateQualifiedName(String qualifiedName) throws DOMException {
        if (qualifiedName.length() == 0) {
            throw DOMExceptionTranslator.newDOMException((short)5);
        }
        int colonPosition = -1;
        boolean checkNameStart = true;
        int i = 0;
        while (i < qualifiedName.length()) {
            char c = qualifiedName.charAt(i);
            if (c == ':') {
                if (colonPosition != -1 || i <= 0) throw DOMExceptionTranslator.newDOMException((short)14);
                colonPosition = i;
                checkNameStart = true;
            } else if (checkNameStart) {
                if (!NSUtil.isNameStartChar(c)) {
                    throw DOMExceptionTranslator.newDOMException(NSUtil.isNameChar(c) ? (short)14 : 5);
                }
                checkNameStart = false;
            } else if (!NSUtil.isNameChar(c)) {
                throw DOMExceptionTranslator.newDOMException((short)5);
            }
            ++i;
        }
        if (!checkNameStart) return colonPosition;
        throw DOMExceptionTranslator.newDOMException((short)14);
    }

    public static String normalizeNamespaceURI(String namespaceURI) {
        return namespaceURI == null ? "" : namespaceURI;
    }

    public static void validateNamespace(String namespaceURI, String prefix) {
        if (prefix.length() != 0 && namespaceURI.length() == 0) {
            throw DOMExceptionTranslator.newDOMException((short)14);
        }
        if ("xml".equals(prefix) && !"http://www.w3.org/XML/1998/namespace".equals(namespaceURI)) {
            throw DOMExceptionTranslator.newDOMException((short)14);
        }
    }

    public static void validateAttributeName(String namespaceURI, String localName, String prefix) {
        NSUtil.validateNamespace(namespaceURI, prefix);
        if (prefix.length() == 0 && localName.equals("xmlns") && !namespaceURI.equals("http://www.w3.org/2000/xmlns/")) {
            throw DOMExceptionTranslator.newDOMException((short)14);
        }
        if ("xmlns".equals(prefix)) {
            throw DOMExceptionTranslator.newDOMException((short)14);
        }
    }

    public static String getDeclaredPrefix(String localName, String prefix) {
        if (prefix.equals("xmlns")) {
            return localName;
        }
        if (prefix.length() == 0 && localName.equals("xmlns")) {
            return "";
        }
        throw DOMExceptionTranslator.newDOMException((short)14);
    }
}

