/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.common.serializer.pull;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.core.CoreAttribute;
import org.apache.axiom.core.CoreCharacterDataContainer;
import org.apache.axiom.core.CoreChildNode;
import org.apache.axiom.core.CoreDocument;
import org.apache.axiom.core.CoreElement;
import org.apache.axiom.core.CoreNSAwareAttribute;
import org.apache.axiom.core.CoreNamespaceDeclaration;
import org.apache.axiom.core.CoreNode;
import org.apache.axiom.core.CoreParentNode;
import org.apache.axiom.ext.stax.CharacterDataReader;
import org.apache.axiom.ext.stax.DTDReader;
import org.apache.axiom.ext.stax.datahandler.DataHandlerProvider;
import org.apache.axiom.ext.stax.datahandler.DataHandlerReader;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMDocType;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMEntityReference;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMProcessingInstruction;
import org.apache.axiom.om.OMSerializable;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.common.OMDataSourceUtil;
import org.apache.axiom.om.impl.common.serializer.pull.EndDocumentState;
import org.apache.axiom.om.impl.common.serializer.pull.IncludeWrapper;
import org.apache.axiom.om.impl.common.serializer.pull.PullSerializer;
import org.apache.axiom.om.impl.common.serializer.pull.PullSerializerState;
import org.apache.axiom.om.impl.common.serializer.pull.PullThroughWrapper;
import org.apache.axiom.util.namespace.MapBasedNamespaceContext;
import org.apache.axiom.util.stax.XMLEventUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class Navigator
extends PullSerializerState
implements DataHandlerReader,
CharacterDataReader,
DTDReader,
XMLStreamConstants {
    private static final Log log = LogFactory.getLog(Navigator.class);
    private final PullSerializer serializer;
    private CoreNode node;
    private boolean visited;
    private final CoreParentNode rootNode;
    private int currentEvent;
    private final boolean cache;
    private final boolean preserveNamespaceContext;
    private int attributeCount = -1;
    private CoreNSAwareAttribute[] attributes = new CoreNSAwareAttribute[16];
    private int namespaceCount = -1;
    private CoreNamespaceDeclaration[] namespaces = new CoreNamespaceDeclaration[16];
    private OMDataSource ds;

    Navigator(PullSerializer serializer, CoreParentNode startNode, boolean cache, boolean preserveNamespaceContext) {
        this.serializer = serializer;
        this.rootNode = startNode;
        this.cache = cache;
        this.preserveNamespaceContext = preserveNamespaceContext;
        if (startNode instanceof CoreDocument) {
            this.node = startNode;
        }
        this.currentEvent = 7;
    }

    DTDReader getDTDReader() {
        return this;
    }

    DataHandlerReader getDataHandlerReader() {
        return this;
    }

    CharacterDataReader getCharacterDataReader() {
        return this;
    }

    String getPrefix() {
        if (this.currentEvent == 1 || this.currentEvent == 2) {
            return ((OMElement)this.node).getPrefix();
        }
        throw new IllegalStateException();
    }

    String getNamespaceURI() {
        if (this.currentEvent == 1 || this.currentEvent == 2) {
            return ((OMElement)this.node).getNamespaceURI();
        }
        throw new IllegalStateException();
    }

    String getLocalName() {
        switch (this.currentEvent) {
            case 1: 
            case 2: {
                return ((OMElement)this.node).getLocalName();
            }
            case 9: {
                return ((OMEntityReference)this.node).getName();
            }
        }
        throw new IllegalStateException();
    }

    QName getName() {
        if (this.currentEvent == 1 || this.currentEvent == 2) {
            if (this.node instanceof OMSourcedElement) {
                ((OMElement)this.node).getFirstOMChild();
            }
            return ((OMElement)this.node).getQName();
        }
        throw new IllegalStateException();
    }

    int getTextLength() {
        return this.getTextFromNode().length();
    }

    int getTextStart() {
        switch (this.currentEvent) {
            case 4: 
            case 5: 
            case 6: 
            case 12: {
                return 0;
            }
        }
        throw new IllegalStateException();
    }

    int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        String text = this.getTextFromNode();
        int copied = Math.min(length, text.length() - sourceStart);
        text.getChars(sourceStart, sourceStart + copied, target, targetStart);
        return copied;
    }

    char[] getTextCharacters() {
        return this.getTextFromNode().toCharArray();
    }

    String getText() {
        switch (this.currentEvent) {
            case 11: {
                String internalSubset = ((OMDocType)this.node).getInternalSubset();
                return internalSubset != null ? internalSubset : "";
            }
            case 9: {
                return ((OMEntityReference)this.node).getReplacementText();
            }
        }
        return this.getTextFromNode();
    }

    private String getTextFromNode() {
        switch (this.currentEvent) {
            case 4: 
            case 5: 
            case 6: 
            case 12: {
                return ((CoreCharacterDataContainer)this.node).coreGetCharacterData().toString();
            }
        }
        throw new IllegalStateException();
    }

    public void writeTextTo(Writer writer) throws XMLStreamException, IOException {
        switch (this.currentEvent) {
            case 4: 
            case 6: 
            case 12: {
                OMText text = (OMText)this.node;
                if (text.isCharacters()) {
                    writer.write(text.getTextCharacters());
                    break;
                }
                writer.write(text.getText());
                break;
            }
            case 5: {
                writer.write(((OMComment)this.node).getValue());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    int getEventType() {
        return this.currentEvent;
    }

    private void loadAttributes() {
        if (this.attributeCount == -1) {
            this.attributeCount = 0;
            CoreAttribute attr = ((CoreElement)this.node).coreGetFirstAttribute();
            while (attr != null) {
                if (attr instanceof CoreNSAwareAttribute) {
                    if (this.attributeCount == this.attributes.length) {
                        CoreNSAwareAttribute[] newAttributes = new CoreNSAwareAttribute[this.attributes.length * 2];
                        System.arraycopy(this.attributes, 0, newAttributes, 0, this.attributes.length);
                        this.attributes = newAttributes;
                    }
                    this.attributes[this.attributeCount] = (CoreNSAwareAttribute)attr;
                    ++this.attributeCount;
                }
                attr = attr.coreGetNextAttribute();
            }
        }
    }

    private CoreNSAwareAttribute getAttribute(int index) {
        this.loadAttributes();
        return this.attributes[index];
    }

    private void loadNamespaces() {
        if (this.namespaceCount == -1) {
            this.namespaceCount = 0;
            CoreAttribute attr = ((CoreElement)this.node).coreGetFirstAttribute();
            while (attr != null) {
                if (attr instanceof CoreNamespaceDeclaration) {
                    this.addNamespace((CoreNamespaceDeclaration)attr);
                }
                attr = attr.coreGetNextAttribute();
            }
            if (this.preserveNamespaceContext && this.node == this.rootNode) {
                CoreParentNode parent;
                CoreElement element = (CoreElement)this.node;
                while ((parent = element.coreGetParent()) instanceof CoreElement) {
                    element = (CoreElement)parent;
                    attr = element.coreGetFirstAttribute();
                    block2: while (attr != null) {
                        if (attr instanceof CoreNamespaceDeclaration) {
                            CoreNamespaceDeclaration ns = (CoreNamespaceDeclaration)attr;
                            String prefix = ns.coreGetDeclaredPrefix();
                            int i = 0;
                            while (i < this.namespaceCount) {
                                if (this.namespaces[i].coreGetDeclaredPrefix().equals(prefix)) continue block2;
                                ++i;
                            }
                            this.addNamespace(ns);
                        }
                        attr = attr.coreGetNextAttribute();
                    }
                }
            }
        }
    }

    private CoreNamespaceDeclaration getNamespace(int index) {
        this.loadNamespaces();
        return this.namespaces[index];
    }

    private void addNamespace(CoreNamespaceDeclaration ns) {
        if (!"xml".equals(ns.coreGetDeclaredPrefix())) {
            if (this.namespaceCount == this.namespaces.length) {
                CoreNamespaceDeclaration[] newNamespaces = new CoreNamespaceDeclaration[this.namespaces.length * 2];
                System.arraycopy(this.namespaces, 0, newNamespaces, 0, this.namespaces.length);
                this.namespaces = newNamespaces;
            }
            this.namespaces[this.namespaceCount] = ns;
            ++this.namespaceCount;
        }
    }

    String getNamespaceURI(int i) {
        if (this.currentEvent == 1 || this.currentEvent == 2) {
            return this.getNamespace(i).coreGetCharacterData().toString();
        }
        throw new IllegalStateException();
    }

    String getNamespacePrefix(int i) {
        if (this.currentEvent == 1 || this.currentEvent == 2) {
            String prefix = this.getNamespace(i).coreGetDeclaredPrefix();
            return prefix.length() == 0 ? null : prefix;
        }
        throw new IllegalStateException();
    }

    int getNamespaceCount() {
        if (this.currentEvent == 1 || this.currentEvent == 2) {
            this.loadNamespaces();
            return this.namespaceCount;
        }
        throw new IllegalStateException();
    }

    boolean isAttributeSpecified(int i) {
        if (this.currentEvent == 1) {
            return true;
        }
        throw new IllegalStateException("attribute type accessed in illegal event!");
    }

    String getAttributeValue(int i) {
        if (this.currentEvent == 1) {
            return this.getAttribute(i).coreGetCharacterData().toString();
        }
        throw new IllegalStateException("attribute type accessed in illegal event!");
    }

    String getAttributeType(int i) {
        if (this.currentEvent == 1) {
            return this.getAttribute(i).coreGetType();
        }
        throw new IllegalStateException("attribute type accessed in illegal event!");
    }

    String getAttributePrefix(int i) {
        if (this.currentEvent == 1) {
            String prefix = this.getAttribute(i).coreGetPrefix();
            return prefix.length() == 0 ? null : prefix;
        }
        throw new IllegalStateException("attribute prefix accessed in illegal event!");
    }

    String getAttributeLocalName(int i) {
        if (this.currentEvent == 1) {
            return this.getAttribute(i).coreGetLocalName();
        }
        throw new IllegalStateException("attribute localName accessed in illegal event!");
    }

    String getAttributeNamespace(int i) {
        if (this.currentEvent == 1) {
            String namespaceURI = this.getAttribute(i).coreGetNamespaceURI();
            return namespaceURI.length() == 0 ? null : namespaceURI;
        }
        throw new IllegalStateException("attribute nameSpace accessed in illegal event!");
    }

    QName getAttributeName(int i) {
        if (this.currentEvent == 1) {
            return ((OMAttribute)this.getAttribute(i)).getQName();
        }
        throw new IllegalStateException("attribute count accessed in illegal event!");
    }

    int getAttributeCount() {
        if (this.currentEvent == 1) {
            this.loadAttributes();
            return this.attributeCount;
        }
        throw new IllegalStateException("attribute count accessed in illegal event (" + this.currentEvent + ")!");
    }

    String getAttributeValue(String s, String s1) {
        if (this.currentEvent == 1) {
            QName qname = new QName(s, s1);
            OMAttribute attr = ((OMElement)this.node).getAttribute(qname);
            return attr == null ? null : attr.getAttributeValue();
        }
        throw new IllegalStateException("attribute type accessed in illegal event!");
    }

    Boolean isWhiteSpace() {
        return null;
    }

    String getNamespaceURI(String prefix) {
        if ((this.currentEvent == 1 || this.currentEvent == 2) && this.node instanceof OMElement) {
            OMNamespace namespaceURI = ((OMElement)this.node).findNamespaceURI(prefix);
            return namespaceURI != null ? namespaceURI.getNamespaceURI() : null;
        }
        return null;
    }

    boolean hasNext() throws XMLStreamException {
        return true;
    }

    String getElementText() throws XMLStreamException {
        return null;
    }

    private boolean nextNode() {
        CoreChildNode nextSibling;
        if (this.node == null) {
            assert (!this.visited);
            this.node = this.rootNode;
            return true;
        }
        if (this.node instanceof OMContainer && !this.visited) {
            CoreChildNode firstChild;
            CoreParentNode current = (CoreParentNode)this.node;
            CoreChildNode coreChildNode = firstChild = this.cache ? current.coreGetFirstChild() : current.coreGetFirstChildIfAvailable();
            if (firstChild != null) {
                this.node = firstChild;
                this.visited = false;
                return true;
            }
            if (current.getState() == 0 || current.getState() == 3) {
                this.visited = true;
                return true;
            }
            return false;
        }
        if (this.node == this.rootNode) {
            this.node = null;
            this.visited = true;
            return true;
        }
        CoreChildNode current = (CoreChildNode)this.node;
        CoreChildNode coreChildNode = nextSibling = this.cache ? current.coreGetNextSibling() : current.coreGetNextSiblingIfAvailable();
        if (nextSibling != null) {
            this.node = nextSibling;
            this.visited = false;
            return true;
        }
        CoreParentNode parent = current.coreGetParent();
        this.node = parent;
        if (parent.getState() == 0 || parent.getState() == 3 || parent.getBuilder() == null) {
            this.visited = true;
            return true;
        }
        return false;
    }

    void next() throws XMLStreamException {
        if (this.nextNode()) {
            OMDataSource ds;
            OMSourcedElement element;
            if (this.node instanceof OMSourcedElement && !(element = (OMSourcedElement)this.node).isExpanded() && (ds = element.getDataSource()) != null) {
                if (this.serializer.isDataSourceALeaf()) {
                    this.ds = ds;
                    this.currentEvent = -1;
                    this.visited = true;
                    return;
                }
                if (!(OMDataSourceUtil.isPushDataSource(ds) || this.cache && OMDataSourceUtil.isDestructiveRead(ds))) {
                    XMLStreamReader reader = ds.getReader();
                    while (reader.next() != 1) {
                    }
                    this.serializer.pushState(new IncludeWrapper(this.serializer, reader));
                    this.visited = true;
                    return;
                }
            }
            if (this.node == null || this.node instanceof OMDocument) {
                assert (this.visited);
                this.serializer.switchState(EndDocumentState.INSTANCE);
                return;
            }
            this.currentEvent = this.node instanceof OMElement ? (this.visited ? 2 : 1) : ((OMNode)this.node).getType();
            this.ds = null;
            this.attributeCount = -1;
            this.namespaceCount = -1;
        } else {
            CoreParentNode container = (CoreParentNode)this.node;
            StAXOMBuilder builder = (StAXOMBuilder)container.getBuilder();
            int depth = 1;
            while (container != this.rootNode && container instanceof CoreElement) {
                CoreParentNode parent = ((CoreElement)container).coreGetParent();
                if (parent.getBuilder() != builder) break;
                container = parent;
                ++depth;
            }
            XMLStreamReader reader = builder.disableCaching();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Switching to pull-through mode; first event is " + XMLEventUtils.getEventTypeString((int)reader.getEventType()) + "; depth is " + depth));
            }
            PullThroughWrapper wrapper = new PullThroughWrapper(this.serializer, builder, (OMContainer)container, reader, depth);
            this.serializer.pushState(wrapper);
            this.node = container;
            this.visited = true;
        }
    }

    int nextTag() throws XMLStreamException {
        return -1;
    }

    Object getProperty(String s) throws IllegalArgumentException {
        StAXBuilder staxBuilder;
        CoreParentNode container = this.node == null ? this.rootNode : (this.node instanceof OMContainer ? (CoreParentNode)this.node : ((CoreChildNode)this.node).coreGetParent());
        OMXMLParserWrapper builder = container.getBuilder();
        if (builder != null && builder instanceof StAXBuilder && !(staxBuilder = (StAXBuilder)builder).isClosed()) {
            try {
                return ((StAXBuilder)builder).getReaderProperty(s);
            }
            catch (IllegalStateException illegalStateException) {
                return null;
            }
        }
        return null;
    }

    NamespaceContext getNamespaceContext() {
        return new MapBasedNamespaceContext(this.getAllNamespaces((OMSerializable)this.node));
    }

    String getEncoding() {
        if (this.currentEvent == 7) {
            if (this.node instanceof OMDocument) {
                return ((OMDocument)this.node).getCharsetEncoding();
            }
            return null;
        }
        throw new IllegalStateException();
    }

    String getVersion() {
        return "1.0";
    }

    boolean isStandalone() {
        return true;
    }

    boolean standaloneSet() {
        return false;
    }

    String getCharacterEncodingScheme() {
        if (this.currentEvent == 7) {
            if (this.node instanceof OMDocument) {
                return ((OMDocument)this.node).getXMLEncoding();
            }
            return null;
        }
        throw new IllegalStateException();
    }

    String getPITarget() {
        if (this.currentEvent == 3) {
            return ((OMProcessingInstruction)this.node).getTarget();
        }
        throw new IllegalStateException();
    }

    String getPIData() {
        if (this.currentEvent == 3) {
            return ((OMProcessingInstruction)this.node).getValue();
        }
        throw new IllegalStateException();
    }

    public boolean isBinary() {
        if (this.node instanceof OMText) {
            return ((OMText)this.node).isBinary();
        }
        return false;
    }

    public boolean isOptimized() {
        if (this.node instanceof OMText) {
            return ((OMText)this.node).isOptimized();
        }
        throw new IllegalStateException();
    }

    public boolean isDeferred() {
        if (this.node instanceof OMText) {
            return false;
        }
        throw new IllegalStateException();
    }

    public String getContentID() {
        if (this.node instanceof OMText) {
            return ((OMText)this.node).getContentID();
        }
        throw new IllegalStateException();
    }

    public DataHandler getDataHandler() throws XMLStreamException {
        if (this.node instanceof OMText) {
            return (DataHandler)((OMText)this.node).getDataHandler();
        }
        throw new IllegalStateException();
    }

    public DataHandlerProvider getDataHandlerProvider() {
        throw new IllegalStateException();
    }

    public String getRootName() {
        if (this.currentEvent == 11) {
            return ((OMDocType)this.node).getRootName();
        }
        throw new IllegalStateException();
    }

    public String getPublicId() {
        if (this.currentEvent == 11) {
            return ((OMDocType)this.node).getPublicId();
        }
        throw new IllegalStateException();
    }

    public String getSystemId() {
        if (this.currentEvent == 11) {
            return ((OMDocType)this.node).getSystemId();
        }
        throw new IllegalStateException();
    }

    private Map getAllNamespaces(OMSerializable contextNode) {
        if (contextNode == null) {
            return Collections.EMPTY_MAP;
        }
        OMContainer context = contextNode instanceof OMContainer ? (OMContainer)contextNode : ((OMNode)contextNode).getParent();
        LinkedHashMap nsMap = new LinkedHashMap();
        while (context != null && !(context instanceof OMDocument)) {
            OMElement element = (OMElement)context;
            Iterator it = element.getAllDeclaredNamespaces();
            while (it.hasNext()) {
                this.addNamespaceToMap((OMNamespace)it.next(), nsMap);
            }
            if (element.getNamespace() != null) {
                this.addNamespaceToMap(element.getNamespace(), nsMap);
            }
            it = element.getAllAttributes();
            while (it.hasNext()) {
                OMAttribute attr = (OMAttribute)it.next();
                if (attr.getNamespace() == null) continue;
                this.addNamespaceToMap(attr.getNamespace(), nsMap);
            }
            context = element.getParent();
        }
        return nsMap;
    }

    private void addNamespaceToMap(OMNamespace ns, Map map) {
        if (map.get(ns.getPrefix()) == null) {
            map.put(ns.getPrefix(), ns.getNamespaceURI());
        }
    }

    OMDataSource getDataSource() {
        if (log.isDebugEnabled() && this.ds != null) {
            log.debug((Object)("Exposed OMDataSource: " + this.ds));
        }
        return this.ds;
    }

    void released() throws XMLStreamException {
    }

    void restored() throws XMLStreamException {
        this.next();
    }

    public String toString() {
        return String.valueOf(super.toString()) + "[cache=" + this.cache + ",document=" + (this.rootNode instanceof OMDocument) + "]";
    }
}

