/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.core;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.axiom.core.CoreAttribute;
import org.apache.axiom.core.CoreAttributeSupport;
import org.apache.axiom.core.CoreElement;
import org.apache.axiom.core.CoreElementSupport;
import org.apache.axiom.core.Mapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AttributeIterator<T extends CoreAttribute, S>
implements Iterator<S> {
    private final Class<T> type;
    private final Mapper<T, S> mapper;
    private CoreAttribute currentAttribute;
    private CoreAttribute nextAttribute;
    private boolean nextAttributeSet;

    private AttributeIterator(CoreAttribute firstAttribute, Class<T> type, Mapper<T, S> mapper) {
        this.type = type;
        this.mapper = mapper;
        this.nextAttribute = firstAttribute;
        this.nextAttributeSet = true;
    }

    static <T extends CoreAttribute, S> Iterator<S> create(CoreElement element, Class<T> type, Mapper<T, S> mapper) {
        CoreAttribute attribute = CoreElementSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreElementSupport$org_apache_axiom_core_CoreElement$coreGetFirstAttribute(element);
        while (attribute != null && !type.isInstance(attribute)) {
            attribute = CoreAttributeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreAttributeSupport$org_apache_axiom_core_CoreAttribute$coreGetNextAttribute(attribute);
        }
        if (attribute == null) {
            return Collections.emptyList().iterator();
        }
        return new AttributeIterator<T, S>(attribute, type, mapper);
    }

    @Override
    public final boolean hasNext() {
        if (!this.nextAttributeSet) {
            CoreAttribute attribute = this.currentAttribute;
            while ((attribute = CoreAttributeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreAttributeSupport$org_apache_axiom_core_CoreAttribute$coreGetNextAttribute(attribute)) != null && !this.type.isInstance(attribute)) {
            }
            this.nextAttribute = attribute;
            this.nextAttributeSet = true;
        }
        return this.nextAttribute != null;
    }

    @Override
    public final S next() {
        if (this.hasNext()) {
            CoreAttribute attribute;
            this.currentAttribute = attribute = this.nextAttribute;
            this.nextAttribute = null;
            this.nextAttributeSet = false;
            return this.mapper.map((CoreAttribute)this.type.cast(attribute));
        }
        throw new NoSuchElementException();
    }

    @Override
    public final void remove() {
        if (this.currentAttribute == null) {
            throw new IllegalStateException();
        }
        this.hasNext();
        CoreAttributeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreAttributeSupport$org_apache_axiom_core_CoreAttribute$coreRemove(this.currentAttribute);
        this.currentAttribute = null;
    }
}

