/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.common.factory;

import javax.xml.namespace.QName;
import org.apache.axiom.core.NodeFactory;
import org.apache.axiom.ext.stax.datahandler.DataHandlerProvider;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMDocType;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMEntityReference;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMProcessingInstruction;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.OMContainerEx;
import org.apache.axiom.om.impl.builder.OMFactoryEx;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.common.AxiomAttribute;
import org.apache.axiom.om.impl.common.AxiomCDATASection;
import org.apache.axiom.om.impl.common.AxiomCharacterDataNode;
import org.apache.axiom.om.impl.common.AxiomComment;
import org.apache.axiom.om.impl.common.AxiomContainer;
import org.apache.axiom.om.impl.common.AxiomContainerSupport;
import org.apache.axiom.om.impl.common.AxiomDocType;
import org.apache.axiom.om.impl.common.AxiomDocument;
import org.apache.axiom.om.impl.common.AxiomElement;
import org.apache.axiom.om.impl.common.AxiomElementSupport;
import org.apache.axiom.om.impl.common.AxiomEntityReference;
import org.apache.axiom.om.impl.common.AxiomNamedInformationItemSupport;
import org.apache.axiom.om.impl.common.AxiomProcessingInstruction;
import org.apache.axiom.om.impl.common.AxiomSourcedElement;
import org.apache.axiom.om.impl.common.AxiomSourcedElementSupport;
import org.apache.axiom.om.impl.common.AxiomText;
import org.apache.axiom.om.impl.common.OMNamespaceImpl;
import org.apache.axiom.om.impl.common.Policies;
import org.apache.axiom.om.impl.common.TextContent;
import org.apache.axiom.om.impl.util.OMSerializerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMFactoryImpl
implements OMFactoryEx {
    protected final OMMetaFactory metaFactory;
    protected final NodeFactory nodeFactory;

    public OMFactoryImpl(OMMetaFactory metaFactory, NodeFactory nodeFactory) {
        this.metaFactory = metaFactory;
        this.nodeFactory = nodeFactory == null ? (NodeFactory)((Object)this) : nodeFactory;
    }

    public final OMMetaFactory getMetaFactory() {
        return this.metaFactory;
    }

    public final OMNamespace createOMNamespace(String uri, String prefix) {
        return new OMNamespaceImpl(uri, prefix);
    }

    public final OMDocument createOMDocument() {
        return this.nodeFactory.createNode(AxiomDocument.class);
    }

    public final OMDocument createOMDocument(OMXMLParserWrapper builder) {
        AxiomDocument document = this.nodeFactory.createNode(AxiomDocument.class);
        document.coreSetBuilder(builder);
        return document;
    }

    public final OMDocType createOMDocType(OMContainer parent, String rootName, String publicId, String systemId, String internalSubset) {
        return this.createOMDocType(parent, rootName, publicId, systemId, internalSubset, false);
    }

    public final OMDocType createOMDocType(OMContainer parent, String rootName, String publicId, String systemId, String internalSubset, boolean fromBuilder) {
        AxiomDocType node = this.nodeFactory.createNode(AxiomDocType.class);
        node.coreSetRootName(rootName);
        node.coreSetPublicId(publicId);
        node.coreSetSystemId(systemId);
        node.coreSetInternalSubset(internalSubset);
        if (parent != null) {
            ((OMContainerEx)parent).addChild((OMNode)node, fromBuilder);
        }
        return node;
    }

    private AxiomText createAxiomText(OMContainer parent, Object content, int type, boolean fromBuilder) {
        AxiomText node;
        switch (type) {
            case 4: {
                node = this.nodeFactory.createNode(AxiomCharacterDataNode.class);
                break;
            }
            case 6: {
                AxiomCharacterDataNode cdata = this.nodeFactory.createNode(AxiomCharacterDataNode.class);
                cdata.coreSetIgnorable(true);
                node = cdata;
                break;
            }
            case 12: {
                node = this.nodeFactory.createNode(AxiomCDATASection.class);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid node type");
            }
        }
        if (parent != null) {
            ((OMContainerEx)parent).addChild((OMNode)node, fromBuilder);
        }
        node.coreSetCharacterData(content, Policies.DETACH_POLICY);
        return node;
    }

    public final OMText createOMText(OMContainer parent, String text, int type, boolean fromBuilder) {
        return this.createAxiomText(parent, text, type, fromBuilder);
    }

    public final OMText createOMText(String s, int type) {
        return this.createAxiomText(null, s, type, false);
    }

    public final OMText createOMText(String s) {
        return this.createAxiomText(null, s, 4, false);
    }

    public final OMText createOMText(OMContainer parent, String text, int type) {
        return this.createAxiomText(parent, text, type, false);
    }

    public final OMText createOMText(OMContainer parent, String text) {
        return this.createAxiomText(parent, text, 4, false);
    }

    public final OMText createOMText(OMContainer parent, char[] charArray, int type) {
        return this.createAxiomText(parent, new String(charArray), type, false);
    }

    public final OMText createOMText(OMContainer parent, QName text, int type) {
        if (text == null) {
            throw new IllegalArgumentException("QName text arg cannot be null!");
        }
        OMNamespace ns = AxiomElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_common_AxiomElement$handleNamespace((AxiomElement)parent, text.getNamespaceURI(), text.getPrefix());
        return this.createAxiomText(parent, ns == null ? text.getLocalPart() : String.valueOf(ns.getPrefix()) + ":" + text.getLocalPart(), type, false);
    }

    public final OMText createOMText(OMContainer parent, QName text) {
        return this.createAxiomText(parent, text, 4, false);
    }

    public final OMText createOMText(OMContainer parent, String s, String mimeType, boolean optimize) {
        return this.createAxiomText(parent, new TextContent(s, mimeType, optimize), 4, false);
    }

    public final OMText createOMText(String s, String mimeType, boolean optimize) {
        return this.createOMText(null, s, mimeType, optimize);
    }

    public final OMText createOMText(OMContainer parent, OMText source) {
        return (AxiomText)((AxiomText)source).coreClone(Policies.CLONE_POLICY, null, (AxiomContainer)parent);
    }

    public final OMText createOMText(Object dataHandler, boolean optimize) {
        return this.createOMText(null, dataHandler, optimize, false);
    }

    public final OMText createOMText(OMContainer parent, Object dataHandler, boolean optimize, boolean fromBuilder) {
        return this.createAxiomText(parent, new TextContent(dataHandler, optimize), 4, fromBuilder);
    }

    public final OMText createOMText(String contentID, DataHandlerProvider dataHandlerProvider, boolean optimize) {
        return this.createAxiomText(null, new TextContent(contentID, dataHandlerProvider, optimize), 4, false);
    }

    public final OMProcessingInstruction createOMProcessingInstruction(OMContainer parent, String piTarget, String piData) {
        return this.createOMProcessingInstruction(parent, piTarget, piData, false);
    }

    public final OMProcessingInstruction createOMProcessingInstruction(OMContainer parent, String piTarget, String piData, boolean fromBuilder) {
        AxiomProcessingInstruction node = this.nodeFactory.createNode(AxiomProcessingInstruction.class);
        node.coreSetTarget(piTarget);
        node.coreSetCharacterData(piData, Policies.DETACH_POLICY);
        if (parent != null) {
            ((OMContainerEx)parent).addChild((OMNode)node, fromBuilder);
        }
        return node;
    }

    public final OMEntityReference createOMEntityReference(OMContainer parent, String name) {
        return this.createOMEntityReference(parent, name, null, false);
    }

    public final OMEntityReference createOMEntityReference(OMContainer parent, String name, String replacementText, boolean fromBuilder) {
        AxiomEntityReference node = this.nodeFactory.createNode(AxiomEntityReference.class);
        node.coreSetName(name);
        node.coreSetReplacementText(replacementText);
        if (parent != null) {
            ((OMContainerEx)parent).addChild((OMNode)node, fromBuilder);
        }
        return node;
    }

    public final OMComment createOMComment(OMContainer parent, String content) {
        return this.createOMComment(parent, content, false);
    }

    public final OMComment createOMComment(OMContainer parent, String content, boolean fromBuilder) {
        AxiomComment node = this.nodeFactory.createNode(AxiomComment.class);
        node.coreSetCharacterData(content, Policies.DETACH_POLICY);
        if (parent != null) {
            ((OMContainerEx)parent).addChild((OMNode)node, fromBuilder);
        }
        return node;
    }

    public final OMElement createOMElement(String localName, OMNamespace ns) {
        return this.createOMElement(localName, ns, null);
    }

    public final <T extends AxiomElement> T createAxiomElement(Class<T> type, OMContainer parent, String localName, OMNamespace ns, OMXMLParserWrapper builder, boolean generateNSDecl) {
        AxiomElement element = (AxiomElement)this.nodeFactory.createNode(type);
        element.coreSetBuilder(builder);
        if (parent != null) {
            AxiomContainerSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_impl_common_AxiomContainer$addChild((AxiomContainer)parent, (OMNode)element, builder != null);
        }
        AxiomElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_common_AxiomElement$initName(element, localName, ns, generateNSDecl);
        return (T)element;
    }

    public final OMElement createOMElement(String localName, OMNamespace ns, OMContainer parent) {
        return this.createAxiomElement(AxiomElement.class, parent, localName, ns, null, true);
    }

    public final OMElement createOMElement(String localName, OMContainer parent, OMXMLParserWrapper builder) {
        return this.createAxiomElement(AxiomElement.class, parent, localName, null, builder, false);
    }

    public final OMElement createOMElement(QName qname, OMContainer parent) {
        AxiomElement element = this.nodeFactory.createNode(AxiomElement.class);
        if (parent != null) {
            parent.addChild((OMNode)element);
        }
        AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$internalSetLocalName(element, qname.getLocalPart());
        String prefix = qname.getPrefix();
        String namespaceURI = qname.getNamespaceURI();
        if (namespaceURI.length() > 0) {
            OMNamespace ns = AxiomElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_common_AxiomElement$findNamespace(element, namespaceURI, prefix.length() == 0 ? null : prefix);
            if (ns == null) {
                if ("".equals(prefix)) {
                    prefix = OMSerializerUtil.getNextNSPrefix();
                }
                ns = AxiomElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_common_AxiomElement$declareNamespace(element, namespaceURI, prefix);
            }
            AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$internalSetNamespace(element, ns);
        } else {
            if (prefix.length() > 0) {
                throw new IllegalArgumentException("Cannot create a prefixed element with an empty namespace name");
            }
            if (AxiomElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_common_AxiomElement$getDefaultNamespace(element) != null) {
                AxiomElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_common_AxiomElement$declareDefaultNamespace(element, "");
            }
            AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$internalSetNamespace(element, null);
        }
        return element;
    }

    public final OMElement createOMElement(QName qname) {
        return this.createOMElement(qname, null);
    }

    public final OMElement createOMElement(String localName, String namespaceURI, String prefix) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("namespaceURI must not be null");
        }
        if (namespaceURI.length() == 0) {
            if (prefix != null && prefix.length() > 0) {
                throw new IllegalArgumentException("Cannot create a prefixed element with an empty namespace name");
            }
            return this.createOMElement(localName, null);
        }
        return this.createOMElement(localName, this.createOMNamespace(namespaceURI, prefix));
    }

    public final OMSourcedElement createOMElement(OMDataSource source) {
        AxiomSourcedElement element = this.nodeFactory.createNode(AxiomSourcedElement.class);
        AxiomSourcedElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomSourcedElementSupport$org_apache_axiom_om_impl_common_AxiomSourcedElement$init(element, source);
        return element;
    }

    public final OMSourcedElement createOMElement(OMDataSource source, String localName, OMNamespace ns) {
        AxiomSourcedElement element = this.nodeFactory.createNode(AxiomSourcedElement.class);
        AxiomSourcedElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomSourcedElementSupport$org_apache_axiom_om_impl_common_AxiomSourcedElement$init(element, localName, ns, source);
        return element;
    }

    public final OMSourcedElement createOMElement(OMDataSource source, QName qname) {
        AxiomSourcedElement element = this.nodeFactory.createNode(AxiomSourcedElement.class);
        AxiomSourcedElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomSourcedElementSupport$org_apache_axiom_om_impl_common_AxiomSourcedElement$init(element, qname, source);
        return element;
    }

    public final OMAttribute createOMAttribute(String localName, OMNamespace ns, String value) {
        if (ns != null && ns.getPrefix() == null) {
            String namespaceURI = ns.getNamespaceURI();
            ns = namespaceURI.length() == 0 ? null : new OMNamespaceImpl(namespaceURI, OMSerializerUtil.getNextNSPrefix());
        }
        if (ns != null) {
            if (ns.getNamespaceURI().length() == 0) {
                if (ns.getPrefix().length() > 0) {
                    throw new IllegalArgumentException("Cannot create a prefixed attribute with an empty namespace name");
                }
                ns = null;
            } else if (ns.getPrefix().length() == 0) {
                throw new IllegalArgumentException("Cannot create an unprefixed attribute with a namespace");
            }
        }
        AxiomAttribute attr = this.nodeFactory.createNode(AxiomAttribute.class);
        AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$internalSetLocalName(attr, localName);
        attr.coreSetCharacterData(value, Policies.DETACH_POLICY);
        AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$internalSetNamespace(attr, ns);
        attr.coreSetType("CDATA");
        return attr;
    }

    public final OMNode importNode(OMNode child) {
        int type = child.getType();
        switch (type) {
            case 1: {
                OMElement childElement = (OMElement)child;
                OMElement newElement = new StAXOMBuilder((OMFactory)this, childElement.getXMLStreamReader()).getDocumentElement();
                newElement.buildWithAttachments();
                return newElement;
            }
            case 4: {
                OMText newText;
                OMText importedText = (OMText)child;
                if (importedText.isBinary()) {
                    boolean isOptimize = importedText.isOptimized();
                    newText = this.createOMText(importedText.getDataHandler(), isOptimize);
                } else {
                    newText = importedText.isCharacters() ? this.createOMText(null, importedText.getTextCharacters(), importedText.getType()) : this.createOMText(null, importedText.getText());
                }
                return newText;
            }
            case 3: {
                OMProcessingInstruction importedPI = (OMProcessingInstruction)child;
                return this.createOMProcessingInstruction(null, importedPI.getTarget(), importedPI.getValue());
            }
            case 5: {
                OMComment importedComment = (OMComment)child;
                return this.createOMComment(null, importedComment.getValue());
            }
            case 11: {
                OMDocType importedDocType = (OMDocType)child;
                return this.createOMDocType(null, importedDocType.getRootName(), importedDocType.getPublicId(), importedDocType.getSystemId(), importedDocType.getInternalSubset());
            }
        }
        throw new UnsupportedOperationException("Not Implemented Yet for the given node type");
    }
}

