/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.common;

import org.apache.axiom.core.AttributeMatcher;
import org.apache.axiom.core.ClonePolicy;
import org.apache.axiom.core.CoreAttribute;
import org.apache.axiom.core.CoreDocument;
import org.apache.axiom.core.CoreNode;
import org.apache.axiom.core.CoreParentNode;
import org.apache.axiom.core.DetachPolicy;
import org.apache.axiom.core.NSAwareAttributeMatcher;
import org.apache.axiom.core.NamespaceDeclarationMatcher;
import org.apache.axiom.core.NodeMigrationPolicy;
import org.apache.axiom.core.NodeType;
import org.apache.axiom.om.OMCloneOptions;
import org.apache.axiom.om.impl.common.AxiomAttribute;
import org.apache.axiom.om.impl.common.AxiomElement;
import org.apache.axiom.om.impl.common.AxiomNamedInformationItemSupport;
import org.apache.axiom.om.impl.common.AxiomSourcedElement;
import org.apache.axiom.om.impl.common.NSUtil;

public final class Policies {
    public static final DetachPolicy DETACH_POLICY = new DetachPolicy(){

        public CoreDocument getNewOwnerDocument(CoreParentNode owner) {
            return null;
        }
    };
    public static final AttributeMatcher ATTRIBUTE_MATCHER = new NSAwareAttributeMatcher(DETACH_POLICY, false, false);
    public static final AttributeMatcher NAMESPACE_DECLARATION_MATCHER = new NamespaceDeclarationMatcher(DETACH_POLICY);
    public static final NodeMigrationPolicy ATTRIBUTE_MIGRATION_POLICY = new NodeMigrationPolicy(){

        public NodeMigrationPolicy.Action getAction(boolean hasParent, boolean isForeignDocument, boolean isForeignModel) {
            return NodeMigrationPolicy.Action.CLONE;
        }
    };
    public static final NodeMigrationPolicy NODE_MIGRATION_POLICY = new NodeMigrationPolicy(){

        public NodeMigrationPolicy.Action getAction(boolean hasParent, boolean isForeignDocument, boolean isForeignModel) {
            return isForeignModel ? NodeMigrationPolicy.Action.CLONE : NodeMigrationPolicy.Action.MOVE;
        }
    };
    public static final ClonePolicy<OMCloneOptions> CLONE_POLICY = new ClonePolicy<OMCloneOptions>(){

        @Override
        public Class<? extends CoreNode> getTargetNodeClass(OMCloneOptions options, CoreNode node) {
            if (options != null && options.isPreserveModel()) {
                return node.coreGetNodeClass();
            }
            if (options != null && options.isCopyOMDataSources() && node instanceof AxiomSourcedElement) {
                return AxiomSourcedElement.class;
            }
            return node.coreGetNodeType().getInterface();
        }

        @Override
        public boolean repairNamespaces(OMCloneOptions options) {
            return true;
        }

        @Override
        public boolean cloneAttributes(OMCloneOptions options) {
            return true;
        }

        @Override
        public boolean cloneChildren(OMCloneOptions options, NodeType nodeType) {
            return true;
        }

        @Override
        public void postProcess(OMCloneOptions options, CoreNode clone) {
            if (clone instanceof AxiomElement && ((AxiomElement)clone).isExpanded()) {
                AxiomElement element = (AxiomElement)clone;
                NSUtil.handleNamespace(element, AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$getNamespace(element), false, true);
                CoreAttribute attr = element.coreGetFirstAttribute();
                while (attr != null) {
                    if (attr instanceof AxiomAttribute) {
                        NSUtil.handleNamespace(element, AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$getNamespace((AxiomAttribute)attr), true, true);
                    }
                    attr = attr.coreGetNextAttribute();
                }
            }
        }
    };

    private Policies() {
    }
}

