/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.testutils.io;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import junit.framework.Assert;

public class CharacterStreamComparator
extends Writer {
    private final Reader in;
    private final char[] compareBuffer = new char[1024];
    private int position;

    public CharacterStreamComparator(Reader in) {
        this.in = in;
    }

    @Override
    public void write(char[] buffer, int off, int len) throws IOException {
        while (len > 0) {
            int c = this.in.read(this.compareBuffer, 0, Math.min(this.compareBuffer.length, len));
            if (c == -1) {
                Assert.fail((String)"The two streams have different lengths");
            }
            for (int i = 0; i < c; ++i) {
                if (buffer[off] != this.compareBuffer[i]) {
                    Assert.fail((String)("Character mismatch at position " + this.position));
                }
                ++off;
                --len;
                ++this.position;
            }
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        if (this.in.read() != -1) {
            Assert.fail((String)"The two streams have different lengths");
        }
    }
}

