/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.codec.tiff;

import java.awt.image.BufferedImage;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFEncodeParam;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFField;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFImageEncoder;
import org.apache.batik.ext.awt.image.rendered.FormatRed;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.TIFFTranscoder;

public class TIFFTranscoderInternalCodecWriteAdapter
implements TIFFTranscoder.WriteAdapter {
    public void writeImage(TIFFTranscoder transcoder, BufferedImage img, TranscoderOutput output) throws TranscoderException {
        TranscodingHints hints = transcoder.getTranscodingHints();
        TIFFEncodeParam params = new TIFFEncodeParam();
        float PixSzMM = transcoder.getUserAgent().getPixelUnitToMillimeter();
        int numPix = (int)((double)(100000.0f / PixSzMM) + 0.5);
        int denom = 10000;
        long[] rational = new long[]{numPix, denom};
        TIFFField[] fields = new TIFFField[]{new TIFFField(296, 3, 1, new char[]{'\u0003'}), new TIFFField(282, 5, 1, new long[][]{rational}), new TIFFField(283, 5, 1, new long[][]{rational})};
        params.setExtraFields(fields);
        if (hints.containsKey((Object)TIFFTranscoder.KEY_COMPRESSION_METHOD)) {
            String method = (String)hints.get((Object)TIFFTranscoder.KEY_COMPRESSION_METHOD);
            if ("packbits".equals(method)) {
                params.setCompression(32773);
            } else if ("deflate".equals(method)) {
                params.setCompression(32946);
            }
        }
        try {
            int w = img.getWidth();
            int h = img.getHeight();
            SinglePixelPackedSampleModel sppsm = (SinglePixelPackedSampleModel)img.getSampleModel();
            OutputStream ostream = output.getOutputStream();
            TIFFImageEncoder tiffEncoder = new TIFFImageEncoder(ostream, params);
            int bands = sppsm.getNumBands();
            int[] off = new int[bands];
            for (int i = 0; i < bands; ++i) {
                off[i] = i;
            }
            PixelInterleavedSampleModel sm = new PixelInterleavedSampleModel(0, w, h, bands, w * bands, off);
            FormatRed rimg = new FormatRed(GraphicsUtil.wrap((RenderedImage)img), (SampleModel)sm);
            tiffEncoder.encode((RenderedImage)rimg);
            ostream.flush();
        }
        catch (IOException ex) {
            throw new TranscoderException((Exception)ex);
        }
    }
}

