/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.loader.batik;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.fop.svg.SVGUserAgent;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageProcessingHints;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageConverter;
import org.apache.xmlgraphics.image.loader.impl.ImageGraphics2D;
import org.apache.xmlgraphics.image.loader.impl.ImageXMLDOM;
import org.apache.xmlgraphics.java2d.Graphics2DImagePainter;

public class ImageConverterSVG2G2D
extends AbstractImageConverter {
    public Image convert(Image src, Map hints) throws ImageException {
        GraphicsNode root;
        this.checkSourceFlavor(src);
        final ImageXMLDOM svg = (ImageXMLDOM)src;
        if (!"http://www.w3.org/2000/svg".equals(svg.getRootNamespace())) {
            throw new IllegalArgumentException("XML DOM is not in the SVG namespace: " + svg.getRootNamespace());
        }
        float pxToMillimeter = 0.35277778f;
        Number ptm = (Number)hints.get(ImageProcessingHints.SOURCE_RESOLUTION);
        if (ptm != null) {
            pxToMillimeter = (float)((double)25.4f / ptm.doubleValue());
        }
        SVGUserAgent ua = new SVGUserAgent(pxToMillimeter, new AffineTransform());
        GVTBuilder builder = new GVTBuilder();
        final BridgeContext ctx = new BridgeContext((UserAgent)ua);
        try {
            root = builder.build(ctx, svg.getDocument());
        }
        catch (Exception e) {
            throw new ImageException("GVT tree could not be built for SVG graphic", (Throwable)e);
        }
        Graphics2DImagePainter painter = new Graphics2DImagePainter(){

            public void paint(Graphics2D g2d, Rectangle2D area) {
                float iw = (float)ctx.getDocumentSize().getWidth();
                float ih = (float)ctx.getDocumentSize().getHeight();
                float w = (float)area.getWidth();
                float h = (float)area.getHeight();
                g2d.translate(area.getX(), area.getY());
                g2d.scale(w / iw, h / ih);
                root.paint(g2d);
            }

            public Dimension getImageSize() {
                return new Dimension(svg.getSize().getWidthMpt(), svg.getSize().getHeightMpt());
            }
        };
        ImageGraphics2D g2dImage = new ImageGraphics2D(src.getInfo(), painter);
        return g2dImage;
    }

    public ImageFlavor getSourceFlavor() {
        return ImageFlavor.XML_DOM;
    }

    public ImageFlavor getTargetFlavor() {
        return ImageFlavor.GRAPHICS2D;
    }
}

