/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.fonts;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.afp.fonts.AFPFont;
import org.apache.fop.afp.fonts.CharacterSet;
import org.apache.fop.afp.fonts.FontRuntimeException;

public class RasterFont
extends AFPFont {
    protected static final Log log = LogFactory.getLog((String)"org.apache.fop.afp.fonts");
    private final Map charSets = new HashMap();
    private CharacterSet charSet = null;
    public static final String MPT = "mpt";

    public RasterFont(String name) {
        super(name);
    }

    public void addCharacterSet(int size, CharacterSet characterSet) {
        this.charSets.put(String.valueOf(size), characterSet);
        this.charSet = characterSet;
    }

    public CharacterSet getCharacterSet(int size) {
        String pointsize = String.valueOf(size / 1000);
        CharacterSet csm = (CharacterSet)this.charSets.get(pointsize);
        if (csm == null) {
            csm = (CharacterSet)this.charSets.get(size + MPT);
        }
        if (csm == null) {
            int distance = Integer.MAX_VALUE;
            Iterator it = this.charSets.entrySet().iterator();
            while (it.hasNext()) {
                int mpt;
                Map.Entry me = it.next();
                String key = (String)me.getKey();
                if (key.endsWith(MPT) || Math.abs(size - (mpt = Integer.parseInt(key) * 1000)) >= distance) continue;
                distance = Math.abs(size - mpt);
                pointsize = (String)me.getKey();
                csm = (CharacterSet)me.getValue();
            }
            if (csm != null) {
                this.charSets.put(size + MPT, csm);
                String msg = "No " + size / 1000 + "pt font " + this.getFontName() + " found, substituted with " + pointsize + "pt font";
                log.warn((Object)msg);
            }
        }
        if (csm == null) {
            String msg = "No font found for font " + this.getFontName() + " with point size " + pointsize;
            log.error((Object)msg);
            throw new FontRuntimeException(msg);
        }
        return csm;
    }

    public int getFirstChar() {
        Iterator it = this.charSets.values().iterator();
        if (it.hasNext()) {
            CharacterSet csm = (CharacterSet)it.next();
            return csm.getFirstChar();
        }
        String msg = "getFirstChar() - No character set found for font:" + this.getFontName();
        log.error((Object)msg);
        throw new FontRuntimeException(msg);
    }

    public int getLastChar() {
        Iterator it = this.charSets.values().iterator();
        if (it.hasNext()) {
            CharacterSet csm = (CharacterSet)it.next();
            return csm.getLastChar();
        }
        String msg = "getLastChar() - No character set found for font:" + this.getFontName();
        log.error((Object)msg);
        throw new FontRuntimeException(msg);
    }

    public int getAscender(int size) {
        return this.getCharacterSet(size).getAscender() * size;
    }

    public int getCapHeight(int size) {
        return this.getCharacterSet(size).getCapHeight() * size;
    }

    public int getDescender(int size) {
        return this.getCharacterSet(size).getDescender() * size;
    }

    public int getXHeight(int size) {
        return this.getCharacterSet(size).getXHeight() * size;
    }

    public int getWidth(int character, int size) {
        return this.getCharacterSet(size).getWidth(character) * size;
    }

    public int[] getWidths(int size) {
        return this.getCharacterSet(size).getWidths();
    }

    public int[] getWidths() {
        return this.getWidths(1000);
    }

    public boolean hasChar(char c) {
        return this.charSet.hasChar(c);
    }

    public char mapChar(char c) {
        return this.charSet.mapChar(c);
    }

    public String getEncodingName() {
        return this.charSet.getEncoding();
    }
}

