/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.fop.afp.modca.AbstractAFPObject;
import org.apache.fop.afp.util.BinaryUtils;

public class TagLogicalElement
extends AbstractAFPObject {
    private String name = null;
    private String value = null;
    private int tleID;

    public TagLogicalElement(String name, String value, int tleID) {
        this.name = name;
        this.value = value;
        this.tleID = tleID;
    }

    public void writeToStream(OutputStream os) throws IOException {
        byte[] tleByteName = null;
        byte[] tleByteValue = null;
        try {
            tleByteName = this.name.getBytes("Cp1146");
            tleByteValue = this.value.getBytes("Cp1146");
        }
        catch (UnsupportedEncodingException usee) {
            tleByteName = this.name.getBytes();
            tleByteValue = this.value.getBytes();
            log.warn((Object)("Constructor:: UnsupportedEncodingException translating the name " + this.name));
        }
        byte[] data = new byte[27 + tleByteName.length + tleByteValue.length];
        data[0] = 90;
        byte[] rl1 = BinaryUtils.convert(26 + tleByteName.length + tleByteValue.length, 2);
        data[1] = rl1[0];
        data[2] = rl1[1];
        data[3] = -45;
        data[4] = -96;
        data[5] = -112;
        data[6] = 0;
        data[7] = 0;
        data[8] = 0;
        byte[] rl2 = BinaryUtils.convert(tleByteName.length + 4, 1);
        data[9] = rl2[0];
        data[10] = 2;
        data[11] = 11;
        data[12] = 0;
        int pos = 13;
        for (int i = 0; i < tleByteName.length; ++i) {
            data[pos++] = tleByteName[i];
        }
        byte[] rl3 = BinaryUtils.convert(tleByteValue.length + 4, 1);
        data[pos++] = rl3[0];
        data[pos++] = 54;
        data[pos++] = 0;
        data[pos++] = 0;
        for (int i = 0; i < tleByteValue.length; ++i) {
            data[pos++] = tleByteValue[i];
        }
        data[pos++] = 16;
        data[pos++] = -128;
        byte[] id = BinaryUtils.convert(this.tleID, 4);
        for (int i = 0; i < id.length; ++i) {
            data[pos++] = id[i];
        }
        byte[] level = BinaryUtils.convert(1, 4);
        for (int i = 0; i < level.length; ++i) {
            data[pos++] = level[i];
        }
        os.write(data);
    }
}

