/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.bitmap;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.fonts.FontCollection;
import org.apache.fop.fonts.FontEventAdapter;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontManager;
import org.apache.fop.render.DefaultFontResolver;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.bitmap.BitmapRenderingSettings;
import org.apache.fop.render.bitmap.TIFFDocumentHandler;
import org.apache.fop.render.bitmap.TIFFRenderer;
import org.apache.fop.render.intermediate.IFDocumentHandler;
import org.apache.fop.render.intermediate.IFDocumentHandlerConfigurator;
import org.apache.fop.render.java2d.Base14FontCollection;
import org.apache.fop.render.java2d.ConfiguredFontCollection;
import org.apache.fop.render.java2d.InstalledFontCollection;
import org.apache.fop.render.java2d.Java2DFontMetrics;
import org.apache.fop.render.java2d.Java2DRendererConfigurator;
import org.apache.fop.util.ColorUtil;

public class TIFFRendererConfigurator
extends Java2DRendererConfigurator
implements IFDocumentHandlerConfigurator {
    public TIFFRendererConfigurator(FOUserAgent userAgent) {
        super(userAgent);
    }

    public void configure(Renderer renderer) throws FOPException {
        Configuration cfg = super.getRendererConfig(renderer);
        if (cfg != null) {
            TIFFRenderer tiffRenderer = (TIFFRenderer)renderer;
            String name = cfg.getChild("compression").getValue("PackBits");
            tiffRenderer.setBufferedImageType(this.getBufferedImageTypeFor(name));
            if (!"NONE".equalsIgnoreCase(name)) {
                tiffRenderer.getWriterParams().setCompressionMethod(name);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("TIFF compression set to " + name));
            }
        }
        super.configure(renderer);
    }

    private int getBufferedImageTypeFor(String compressionName) {
        if (compressionName.equalsIgnoreCase("CCITT T.6")) {
            return 12;
        }
        if (compressionName.equalsIgnoreCase("CCITT T.4")) {
            return 12;
        }
        return 2;
    }

    public void configure(IFDocumentHandler documentHandler) throws FOPException {
        Configuration cfg = super.getRendererConfig(documentHandler.getMimeType());
        if (cfg != null) {
            boolean transparent;
            TIFFDocumentHandler tiffHandler = (TIFFDocumentHandler)documentHandler;
            BitmapRenderingSettings settings = tiffHandler.getSettings();
            String name = cfg.getChild("compression").getValue("PackBits");
            settings.setBufferedImageType(this.getBufferedImageTypeFor(name));
            if (!"NONE".equalsIgnoreCase(name)) {
                settings.getWriterParams().setCompressionMethod(name);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("TIFF compression set to " + name));
            }
            if (transparent = cfg.getChild("transparent-page-background").getValueAsBoolean(settings.hasTransparentPageBackground())) {
                settings.setPageBackgroundColor(null);
            } else {
                String background = cfg.getChild("background-color").getValue(null);
                if (background != null) {
                    settings.setPageBackgroundColor(ColorUtil.parseColorString(this.userAgent, background));
                } else {
                    settings.setPageBackgroundColor(Color.WHITE);
                }
            }
            boolean antiAliasing = cfg.getChild("anti-aliasing").getValueAsBoolean(settings.isAntiAliasingEnabled());
            settings.setAntiAliasing(antiAliasing);
            String optimization = cfg.getChild("rendering").getValue(null);
            if ("quality".equalsIgnoreCase(optimization)) {
                settings.setQualityRendering(true);
            } else if ("speed".equalsIgnoreCase(optimization)) {
                settings.setQualityRendering(false);
            }
            String color = cfg.getChild("color-mode").getValue(null);
            if (color != null) {
                if ("rgba".equalsIgnoreCase(color)) {
                    settings.setBufferedImageType(2);
                } else if ("rgb".equalsIgnoreCase(color)) {
                    settings.setBufferedImageType(1);
                } else if ("gray".equalsIgnoreCase(color)) {
                    settings.setBufferedImageType(10);
                } else if ("binary".equalsIgnoreCase(color)) {
                    settings.setBufferedImageType(12);
                } else {
                    throw new FOPException("Invalid value for color-mode: " + color);
                }
            }
        }
    }

    public void setupFontInfo(IFDocumentHandler documentHandler, FontInfo fontInfo) throws FOPException {
        FontManager fontManager = this.userAgent.getFactory().getFontManager();
        Graphics2D graphics2D = Java2DFontMetrics.createFontMetricsGraphics2D();
        ArrayList<FontCollection> fontCollections = new ArrayList<FontCollection>();
        fontCollections.add(new Base14FontCollection(graphics2D));
        fontCollections.add(new InstalledFontCollection(graphics2D));
        Configuration cfg = super.getRendererConfig(documentHandler.getMimeType());
        if (cfg != null) {
            DefaultFontResolver fontResolver = new DefaultFontResolver(this.userAgent);
            FontEventAdapter listener = new FontEventAdapter(this.userAgent.getEventBroadcaster());
            List fontList = this.buildFontList(cfg, fontResolver, listener);
            fontCollections.add(new ConfiguredFontCollection(fontResolver, fontList));
        }
        fontManager.setup(fontInfo, fontCollections.toArray(new FontCollection[fontCollections.size()]));
        documentHandler.setFontInfo(fontInfo);
    }
}

