/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.intermediate.extensions;

import java.awt.Point;
import org.apache.fop.render.intermediate.extensions.AbstractAction;
import org.apache.fop.render.intermediate.extensions.DocumentNavigationExtensionConstants;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class GoToXYAction
extends AbstractAction
implements DocumentNavigationExtensionConstants {
    private int pageIndex = -1;
    private Point targetLocation;

    public GoToXYAction(String id) {
        this(id, -1, null);
    }

    public GoToXYAction(String id, int pageIndex, Point targetLocation) {
        this.setID(id);
        if (pageIndex < 0 && targetLocation != null) {
            throw new IllegalArgumentException("Page index may not be null if target location is known!");
        }
        this.setPageIndex(pageIndex);
        this.setTargetLocation(targetLocation);
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public Point getTargetLocation() {
        return this.targetLocation;
    }

    public void setTargetLocation(Point location) {
        this.targetLocation = location;
    }

    public boolean isComplete() {
        return this.getPageIndex() >= 0 && this.getTargetLocation() != null;
    }

    public boolean isSame(AbstractAction other) {
        if (other == null) {
            throw new NullPointerException("other must not be null");
        }
        if (!(other instanceof GoToXYAction)) {
            return false;
        }
        GoToXYAction otherAction = (GoToXYAction)other;
        if (this.getPageIndex() != otherAction.getPageIndex()) {
            return false;
        }
        if (this.getTargetLocation() == null || otherAction.getTargetLocation() == null) {
            return false;
        }
        return this.getTargetLocation().equals(otherAction.getTargetLocation());
    }

    public void toSAX(ContentHandler handler) throws SAXException {
        if (this.getTargetLocation() == null) {
            this.setTargetLocation(new Point(0, 0));
        }
        AttributesImpl atts = new AttributesImpl();
        if (this.isComplete()) {
            atts.addAttribute(null, "id", "id", "CDATA", this.getID());
            atts.addAttribute(null, "page-index", "page-index", "CDATA", Integer.toString(this.pageIndex));
            atts.addAttribute(null, "x", "x", "CDATA", Integer.toString(this.targetLocation.x));
            atts.addAttribute(null, "y", "y", "CDATA", Integer.toString(this.targetLocation.y));
        } else {
            atts.addAttribute(null, "idref", "idref", "CDATA", this.getID());
        }
        handler.startElement(GOTO_XY.getNamespaceURI(), GOTO_XY.getLocalName(), GOTO_XY.getQName(), atts);
        handler.endElement(GOTO_XY.getNamespaceURI(), GOTO_XY.getLocalName(), GOTO_XY.getQName());
    }

    public String toString() {
        return "GoToXY: ID=" + this.getID() + ", page=" + this.getPageIndex() + ", loc=" + this.getTargetLocation() + ", " + (this.isComplete() ? "complete" : "INCOMPLETE");
    }
}

