/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.goca;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.fop.afp.goca.AbstractGraphicsCoord;

public class GraphicsCharacterString
extends AbstractGraphicsCoord {
    protected static final int MAX_STR_LEN = 255;
    protected final String str;

    public GraphicsCharacterString(String str, int x, int y) {
        super(x, y);
        this.str = this.truncate(str);
    }

    public GraphicsCharacterString(String str) {
        super(null);
        this.str = this.truncate(str);
    }

    byte getOrderCode() {
        if (this.isRelative()) {
            return -125;
        }
        return -61;
    }

    public int getDataLength() {
        return super.getDataLength() + this.str.length();
    }

    public void writeToStream(OutputStream os) throws IOException {
        byte[] data = this.getData();
        byte[] strData = this.getStringAsBytes();
        System.arraycopy(strData, 0, data, 6, strData.length);
        os.write(data);
    }

    private String truncate(String str) {
        if (str.length() > 255) {
            str = str.substring(0, 255);
            log.warn((Object)"truncated character string, longer than 255 chars");
        }
        return str;
    }

    private byte[] getStringAsBytes() throws UnsupportedEncodingException {
        return this.str.getBytes("Cp1146");
    }

    public String toString() {
        return "GraphicsCharacterString{" + (this.coords != null ? "x=" + this.coords[0] + ", y=" + this.coords[1] : "") + "str='" + this.str + "'" + "}";
    }
}

