/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.events.model;

import java.io.InputStream;
import java.util.MissingResourceException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.fop.events.DefaultEventBroadcaster;
import org.apache.fop.events.model.EventModel;
import org.apache.fop.events.model.EventModelFactory;
import org.apache.fop.events.model.EventModelParser;

public abstract class AbstractEventModelFactory
implements EventModelFactory {
    public EventModel loadModel(Class resourceBaseClass, String resourceName) {
        InputStream in = resourceBaseClass.getResourceAsStream(resourceName);
        if (in == null) {
            throw new MissingResourceException("File " + resourceName + " not found", DefaultEventBroadcaster.class.getName(), "");
        }
        try {
            EventModel eventModel = EventModelParser.parse(new StreamSource(in));
            return eventModel;
        }
        catch (TransformerException e) {
            throw new MissingResourceException("Error reading " + resourceName + ": " + e.getMessage(), DefaultEventBroadcaster.class.getName(), "");
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }
}

