/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.afp.AFPDataObjectInfo;
import org.apache.fop.afp.AFPImageObjectInfo;
import org.apache.fop.afp.AFPObjectAreaInfo;
import org.apache.fop.afp.AFPPaintingState;
import org.apache.fop.afp.AFPResourceInfo;
import org.apache.fop.afp.AFPResourceManager;
import org.apache.fop.render.ImageHandler;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.afp.AFPImageHandler;
import org.apache.fop.render.afp.AFPInfo;
import org.apache.fop.render.afp.AFPRendererContext;
import org.apache.fop.render.afp.AFPRendererImageInfo;
import org.apache.fop.render.afp.AFPRenderingContext;
import org.apache.fop.util.bitmap.BitmapImageUtil;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.apache.xmlgraphics.image.loader.impl.ImageRendered;
import org.apache.xmlgraphics.ps.ImageEncodingHelper;
import org.apache.xmlgraphics.util.UnitConv;

public class AFPImageHandlerRenderedImage
extends AFPImageHandler
implements ImageHandler {
    private static Log log = LogFactory.getLog((Class)AFPImageHandlerRenderedImage.class);
    private static final ImageFlavor[] FLAVORS = new ImageFlavor[]{ImageFlavor.BUFFERED_IMAGE, ImageFlavor.RENDERED_IMAGE};

    public AFPDataObjectInfo generateDataObjectInfo(AFPRendererImageInfo rendererImageInfo) throws IOException {
        AFPImageObjectInfo imageObjectInfo = (AFPImageObjectInfo)super.generateDataObjectInfo(rendererImageInfo);
        AFPRendererContext rendererContext = (AFPRendererContext)rendererImageInfo.getRendererContext();
        AFPInfo afpInfo = rendererContext.getInfo();
        this.setDefaultResourceLevel(imageObjectInfo, afpInfo.getResourceManager());
        AFPPaintingState paintingState = afpInfo.getPaintingState();
        ImageRendered imageRendered = (ImageRendered)rendererImageInfo.img;
        Dimension targetSize = new Dimension(afpInfo.getWidth(), afpInfo.getHeight());
        this.updateDataObjectInfo(imageObjectInfo, paintingState, imageRendered, targetSize);
        return imageObjectInfo;
    }

    private AFPDataObjectInfo updateDataObjectInfo(AFPImageObjectInfo imageObjectInfo, AFPPaintingState paintingState, ImageRendered imageRendered, Dimension targetSize) throws IOException {
        int resolution = paintingState.getResolution();
        int maxPixelSize = paintingState.getBitsPerPixel();
        if (paintingState.isColorImages()) {
            maxPixelSize *= 3;
        }
        RenderedImage renderedImage = imageRendered.getRenderedImage();
        ImageInfo imageInfo = imageRendered.getInfo();
        ImageSize intrinsicSize = imageInfo.getSize();
        boolean useFS10 = maxPixelSize == 1 || BitmapImageUtil.isMonochromeImage(renderedImage);
        boolean usePageSegments = useFS10 && !imageObjectInfo.getResourceInfo().getLevel().isInline();
        ImageSize effIntrinsicSize = intrinsicSize;
        if (usePageSegments) {
            boolean resample;
            Dimension resampledDim = new Dimension((int)Math.ceil(UnitConv.mpt2px((double)targetSize.getWidth(), (int)resolution)), (int)Math.ceil(UnitConv.mpt2px((double)targetSize.getHeight(), (int)resolution)));
            imageObjectInfo.setCreatePageSegment(true);
            imageObjectInfo.getResourceInfo().setImageDimension(resampledDim);
            boolean bl = resample = resampledDim.width < renderedImage.getWidth() && resampledDim.height < renderedImage.getHeight();
            if (resample) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Resample from " + intrinsicSize.getDimensionPx() + " to " + resampledDim));
                }
                renderedImage = BitmapImageUtil.convertToMonochrome(renderedImage, resampledDim);
                effIntrinsicSize = new ImageSize(resampledDim.width, resampledDim.height, (double)resolution);
            }
        }
        if (useFS10) {
            imageObjectInfo.setMimeType("image/x-afp+fs10");
        } else {
            imageObjectInfo.setMimeType("image/x-afp+fs11");
        }
        imageObjectInfo.setDataHeightRes((int)Math.round(effIntrinsicSize.getDpiHorizontal() * 10.0));
        imageObjectInfo.setDataWidthRes((int)Math.round(effIntrinsicSize.getDpiVertical() * 10.0));
        int dataHeight = renderedImage.getHeight();
        imageObjectInfo.setDataHeight(dataHeight);
        int dataWidth = renderedImage.getWidth();
        imageObjectInfo.setDataWidth(dataWidth);
        ColorModel cm = renderedImage.getColorModel();
        if (log.isTraceEnabled()) {
            log.trace((Object)("ColorModel: " + cm));
        }
        int pixelSize = cm.getPixelSize();
        if (cm.hasAlpha()) {
            pixelSize -= 8;
        }
        byte[] imageData = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean allowDirectEncoding = true;
        if (allowDirectEncoding && pixelSize <= maxPixelSize) {
            ImageEncodingHelper helper = new ImageEncodingHelper(renderedImage);
            ColorModel encodedColorModel = helper.getEncodedColorModel();
            boolean directEncode = true;
            if (helper.getEncodedColorModel().getPixelSize() > maxPixelSize) {
                directEncode = false;
            }
            if (BitmapImageUtil.getColorIndexSize(renderedImage) > 2) {
                directEncode = false;
            }
            if (useFS10 && BitmapImageUtil.isMonochromeImage(renderedImage) && BitmapImageUtil.isZeroBlack(renderedImage)) {
                directEncode = false;
            }
            if (directEncode) {
                log.debug((Object)"Encoding image directly...");
                imageObjectInfo.setBitsPerPixel(encodedColorModel.getPixelSize());
                if (BitmapImageUtil.isMonochromeImage(renderedImage) && BitmapImageUtil.isZeroBlack(renderedImage)) {
                    log.trace((Object)"set subtractive mode");
                    imageObjectInfo.setSubtractive(true);
                }
                helper.encode((OutputStream)baos);
                imageData = baos.toByteArray();
            }
        }
        if (imageData == null) {
            log.debug((Object)"Encoding image via RGB...");
            ImageEncodingHelper.encodeRenderedImageAsRGB((RenderedImage)renderedImage, (OutputStream)baos);
            imageData = baos.toByteArray();
            boolean colorImages = paintingState.isColorImages();
            imageObjectInfo.setColor(colorImages);
            if (!colorImages) {
                log.debug((Object)"Converting RGB image to grayscale...");
                baos.reset();
                int bitsPerPixel = paintingState.getBitsPerPixel();
                imageObjectInfo.setBitsPerPixel(bitsPerPixel);
                ImageEncodingHelper.encodeRGBAsGrayScale((byte[])imageData, (int)dataWidth, (int)dataHeight, (int)bitsPerPixel, (OutputStream)baos);
                imageData = baos.toByteArray();
                if (bitsPerPixel == 1) {
                    imageObjectInfo.setSubtractive(true);
                }
            }
        }
        imageObjectInfo.setData(imageData);
        AFPObjectAreaInfo objectAreaInfo = imageObjectInfo.getObjectAreaInfo();
        objectAreaInfo.setWidthRes(resolution);
        objectAreaInfo.setHeightRes(resolution);
        return imageObjectInfo;
    }

    private void setDefaultResourceLevel(AFPImageObjectInfo imageObjectInfo, AFPResourceManager resourceManager) {
        AFPResourceInfo resourceInfo = imageObjectInfo.getResourceInfo();
        if (!resourceInfo.levelChanged()) {
            resourceInfo.setLevel(resourceManager.getResourceLevelDefaults().getDefaultResourceLevel((byte)6));
        }
    }

    protected AFPDataObjectInfo createDataObjectInfo() {
        return new AFPImageObjectInfo();
    }

    public int getPriority() {
        return 300;
    }

    public Class getSupportedImageClass() {
        return ImageRendered.class;
    }

    public ImageFlavor[] getSupportedImageFlavors() {
        return FLAVORS;
    }

    public void handleImage(RenderingContext context, Image image, Rectangle pos) throws IOException {
        AFPRenderingContext afpContext = (AFPRenderingContext)context;
        AFPImageObjectInfo imageObjectInfo = (AFPImageObjectInfo)this.createDataObjectInfo();
        this.setResourceInformation(imageObjectInfo, image.getInfo().getOriginalURI(), afpContext.getForeignAttributes());
        this.setDefaultResourceLevel(imageObjectInfo, afpContext.getResourceManager());
        imageObjectInfo.setObjectAreaInfo(AFPImageHandlerRenderedImage.createObjectAreaInfo(afpContext.getPaintingState(), pos));
        Dimension targetSize = pos.getSize();
        ImageRendered imageRend = (ImageRendered)image;
        this.updateDataObjectInfo(imageObjectInfo, afpContext.getPaintingState(), imageRend, targetSize);
        afpContext.getResourceManager().createObject(imageObjectInfo);
    }

    public boolean isCompatible(RenderingContext targetContext, Image image) {
        return (image == null || image instanceof ImageRendered) && targetContext instanceof AFPRenderingContext;
    }
}

