/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.Map;
import org.apache.yoko.rmi.impl.CopyState;
import org.apache.yoko.rmi.impl.FieldDescriptor;
import org.apache.yoko.rmi.impl.ObjectReader;
import org.apache.yoko.rmi.impl.ObjectWriter;

class ByteFieldDescriptor
extends FieldDescriptor {
    ByteFieldDescriptor(Class owner, Class type, String name, Field f) {
        super(owner, type, name, f);
    }

    public void read(ObjectReader reader, Object obj) throws IOException {
        if (this.field == null) {
            throw new IOException("cannot read/write using serialPersistentFields");
        }
        try {
            byte value = reader.readByte();
            this.field.setByte(obj, value);
        }
        catch (IllegalAccessException ex) {
            throw (IOException)new IOException(ex.getMessage()).initCause(ex);
        }
    }

    public void write(ObjectWriter writer, Object obj) throws IOException {
        if (this.field == null) {
            throw new IOException("cannot read/write using serialPersistentFields");
        }
        try {
            writer.writeByte(this.field.getByte(obj));
        }
        catch (IllegalAccessException ex) {
            throw (IOException)new IOException(ex.getMessage()).initCause(ex);
        }
    }

    void copyState(Object orig, Object copy, CopyState state) {
        try {
            this.field.setByte(copy, this.field.getByte(orig));
        }
        catch (IllegalAccessException ex) {
            throw (InternalError)new InternalError(ex.getMessage()).initCause(ex);
        }
    }

    void print(PrintWriter pw, Map recurse, Object val) {
        try {
            pw.print(this.getJavaName());
            pw.print("=");
            pw.print(this.field.getByte(val));
        }
        catch (IllegalAccessException ex) {
            // empty catch block
        }
    }

    void readFieldIntoMap(ObjectReader reader, Map map) throws IOException {
        Byte value = new Byte(reader.readByte());
        map.put(this.getJavaName(), value);
    }

    void writeFieldFromMap(ObjectWriter writer, Map map) throws IOException {
        Byte value = (Byte)map.get(this.getJavaName());
        if (value == null) {
            writer.writeByte(0);
        } else {
            writer.writeByte(value.byteValue());
        }
    }
}

