/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.config;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.captcha.GoogleRecaptchaProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.web.CaptchaActivationStrategy;
import org.apereo.cas.web.CaptchaValidator;
import org.apereo.cas.web.DefaultCaptchaActivationStrategy;
import org.apereo.cas.web.flow.CasCaptchaWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.InitializeCaptchaAction;
import org.apereo.cas.web.flow.ValidateCaptchaAction;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnProperty(prefix="cas.google-recaptcha", name={"enabled"}, havingValue="true", matchIfMissing=true)
@Configuration(value="CasCaptchaConfiguration", proxyBeanMethods=false)
public class CasCaptchaConfiguration {
    @ConditionalOnMissingBean(name={"captchaWebflowConfigurer"})
    @Bean
    public CasWebflowConfigurer captchaWebflowConfigurer(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry loginFlowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices) {
        return new CasCaptchaWebflowConfigurer(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
    }

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    @ConditionalOnMissingBean(name={"captchaValidator"})
    public CaptchaValidator captchaValidator(CasConfigurationProperties casProperties) {
        return CaptchaValidator.getInstance((GoogleRecaptchaProperties)casProperties.getGoogleRecaptcha());
    }

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    @ConditionalOnMissingBean(name={"validateCaptchaAction"})
    public Action validateCaptchaAction(@Qualifier(value="captchaActivationStrategy") CaptchaActivationStrategy captchaActivationStrategy, @Qualifier(value="captchaValidator") CaptchaValidator captchaValidator) {
        return new ValidateCaptchaAction(captchaValidator, captchaActivationStrategy);
    }

    @Bean
    @ConditionalOnMissingBean(name={"captchaActivationStrategy"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public CaptchaActivationStrategy captchaActivationStrategy(@Qualifier(value="servicesManager") ServicesManager servicesManager) {
        return new DefaultCaptchaActivationStrategy(servicesManager);
    }

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    @ConditionalOnMissingBean(name={"initializeCaptchaAction"})
    public Action initializeCaptchaAction(CasConfigurationProperties casProperties, @Qualifier(value="captchaActivationStrategy") CaptchaActivationStrategy captchaActivationStrategy) {
        return new InitializeCaptchaAction(captchaActivationStrategy, requestContext -> requestContext.getFlowScope().put("recaptchaLoginEnabled", (Object)casProperties.getGoogleRecaptcha().isEnabled()), casProperties.getGoogleRecaptcha());
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"captchaCasWebflowExecutionPlanConfigurer"})
    public CasWebflowExecutionPlanConfigurer captchaCasWebflowExecutionPlanConfigurer(@Qualifier(value="captchaWebflowConfigurer") CasWebflowConfigurer captchaWebflowConfigurer) {
        return plan -> plan.registerWebflowConfigurer(captchaWebflowConfigurer);
    }
}

