/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.discovery;

import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.discovery.CasServerProfile;
import org.apereo.cas.services.BaseRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.ticket.TicketCatalog;
import org.apereo.cas.ticket.TicketDefinition;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.ReflectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.Clients;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class CasServerProfileRegistrar
implements ApplicationContextAware {
    private final CasConfigurationProperties casProperties;
    private final Clients clients;
    private final Set<String> availableAttributes;
    private final AuthenticationEventExecutionPlan authenticationEventExecutionPlan;
    private ApplicationContext applicationContext;

    private static Set<String> locateRegisteredServiceTypesSupported() {
        Collection subTypes = ReflectionUtils.findSubclassesInPackage(BaseRegisteredService.class, (String)CentralAuthenticationService.NAMESPACE);
        return subTypes.stream().filter(type -> !type.isInterface() && !Modifier.isAbstract(type.getModifiers())).map(type -> (String)FunctionUtils.doAndHandle(() -> {
            RegisteredService service = (RegisteredService)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return service.getFriendlyName() + "@" + service.getClass().getName();
        })).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public CasServerProfile getProfile() {
        CasServerProfile profile = new CasServerProfile();
        profile.setRegisteredServiceTypesSupported(CasServerProfileRegistrar.locateRegisteredServiceTypesSupported());
        profile.setMultifactorAuthenticationProviderTypesSupported(this.locateMultifactorAuthenticationProviderTypesSupported());
        profile.setDelegatedClientTypesSupported(this.locateDelegatedClientTypesSupported());
        profile.setAvailableAttributes(this.availableAttributes);
        profile.setUserDefinedScopes(this.casProperties.getAuthn().getOidc().getCore().getUserDefinedScopes().keySet());
        profile.setAvailableAuthenticationHandlers(this.locateAvailableAuthenticationHandlers());
        profile.setTicketTypesSupported(this.locateTicketTypesSupported());
        return profile;
    }

    private Map<String, Map<String, Object>> locateTicketTypesSupported() {
        TicketCatalog catalog = (TicketCatalog)this.applicationContext.getBean("ticketCatalog", TicketCatalog.class);
        return catalog.findAll().stream().collect(Collectors.toMap(TicketDefinition::getPrefix, value -> CollectionUtils.wrap((String)"storageName", (Object)value.getProperties().getStorageName(), (String)"storageTimeout", (Object)value.getProperties().getStorageTimeout())));
    }

    private Map<String, String> locateMultifactorAuthenticationProviderTypesSupported() {
        Map providers = MultifactorAuthenticationUtils.getAvailableMultifactorAuthenticationProviders((ApplicationContext)this.applicationContext);
        return providers.values().stream().collect(Collectors.toMap(MultifactorAuthenticationProvider::getId, MultifactorAuthenticationProvider::getFriendlyName));
    }

    private Set<String> locateDelegatedClientTypesSupported() {
        return this.clients == null ? new LinkedHashSet<String>(0) : this.clients.findAllClients().stream().map(Client::getName).collect(Collectors.toSet());
    }

    private Set<String> locateAvailableAuthenticationHandlers() {
        return this.authenticationEventExecutionPlan.getAuthenticationHandlers().stream().map(AuthenticationHandler::getName).collect(Collectors.toSet());
    }

    @Generated
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Generated
    public CasServerProfileRegistrar(CasConfigurationProperties casProperties, Clients clients, Set<String> availableAttributes, AuthenticationEventExecutionPlan authenticationEventExecutionPlan) {
        this.casProperties = casProperties;
        this.clients = clients;
        this.availableAttributes = availableAttributes;
        this.authenticationEventExecutionPlan = authenticationEventExecutionPlan;
    }
}

