/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import lombok.Generated;
import org.apereo.cas.services.AbstractServiceRegistry;
import org.apereo.cas.services.JpaRegisteredServiceEntity;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServiceRegistryListener;
import org.apereo.cas.support.events.service.CasRegisteredServiceLoadedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@EnableTransactionManagement
@Transactional(transactionManager="transactionManagerServiceReg")
public class JpaServiceRegistry
extends AbstractServiceRegistry {
    public static final String BEAN_NAME_TRANSACTION_MANAGER = "transactionManagerServiceReg";
    private final TransactionTemplate transactionTemplate;
    @PersistenceContext(unitName="serviceEntityManagerFactory")
    private EntityManager entityManager;

    public JpaServiceRegistry(ConfigurableApplicationContext applicationContext, Collection<ServiceRegistryListener> serviceRegistryListeners, TransactionTemplate transactionTemplate) {
        super(applicationContext, serviceRegistryListeners);
        this.transactionTemplate = transactionTemplate;
    }

    public boolean delete(RegisteredService registeredService) {
        JpaRegisteredServiceEntity entity = JpaRegisteredServiceEntity.fromRegisteredService(registeredService);
        if (this.entityManager.contains((Object)entity)) {
            this.entityManager.remove((Object)entity);
        } else {
            this.entityManager.remove(this.entityManager.merge((Object)entity));
        }
        return true;
    }

    public void deleteAll() {
        String query = String.format("DELETE FROM %s s", "JpaRegisteredServiceEntity");
        this.entityManager.createQuery(query).executeUpdate();
    }

    @Transactional(transactionManager="transactionManagerServiceReg", readOnly=true)
    public Collection<RegisteredService> load() {
        String query = String.format("SELECT r FROM %s r", "JpaRegisteredServiceEntity");
        List list = this.entityManager.createQuery(query, JpaRegisteredServiceEntity.class).getResultList();
        return list.stream().map(JpaRegisteredServiceEntity::toRegisteredService).sorted().map(arg_0 -> ((JpaServiceRegistry)this).invokeServiceRegistryListenerPostLoad(arg_0)).filter(Objects::nonNull).peek(s -> this.publishEvent((ApplicationEvent)new CasRegisteredServiceLoadedEvent((Object)this, s))).collect(Collectors.toList());
    }

    public Long save(Supplier<RegisteredService> supplier, Consumer<RegisteredService> andThenConsume, long countExclusive) {
        return (Long)this.transactionTemplate.execute(status -> LongStream.range(0L, countExclusive).mapToObj(arg_0 -> JpaServiceRegistry.lambda$save$1((Supplier)supplier, arg_0)).filter(Objects::nonNull).map(this::saveInternal).peek(andThenConsume).filter(Objects::nonNull).count());
    }

    public RegisteredService save(RegisteredService registeredService) {
        return (RegisteredService)this.transactionTemplate.execute(status -> this.saveInternal(registeredService));
    }

    @Transactional(transactionManager="transactionManagerServiceReg", readOnly=true)
    public RegisteredService findServiceById(long id) {
        return Optional.ofNullable((JpaRegisteredServiceEntity)this.entityManager.find(JpaRegisteredServiceEntity.class, (Object)id)).map(JpaRegisteredServiceEntity::toRegisteredService).stream().peek(arg_0 -> ((JpaServiceRegistry)this).invokeServiceRegistryListenerPostLoad(arg_0)).findFirst().orElse(null);
    }

    @Transactional(transactionManager="transactionManagerServiceReg", readOnly=true)
    public RegisteredService findServiceBy(String id) {
        String query = String.format("SELECT r FROM %s r WHERE r.serviceId LIKE :serviceId", "JpaRegisteredServiceEntity");
        List results = this.entityManager.createQuery(query, JpaRegisteredServiceEntity.class).setParameter("serviceId", (Object)("%" + id + "%")).getResultList();
        return results.stream().map(JpaRegisteredServiceEntity::toRegisteredService).sorted().filter(r -> r.matches(id)).peek(arg_0 -> ((JpaServiceRegistry)this).invokeServiceRegistryListenerPostLoad(arg_0)).findFirst().orElse(null);
    }

    @Transactional(transactionManager="transactionManagerServiceReg", readOnly=true)
    public RegisteredService findServiceByExactServiceId(String id) {
        String query = String.format("SELECT r FROM %s r WHERE r.serviceId=:serviceId", "JpaRegisteredServiceEntity");
        List results = this.entityManager.createQuery(query, JpaRegisteredServiceEntity.class).setParameter("serviceId", (Object)id).getResultList();
        return results.stream().map(JpaRegisteredServiceEntity::toRegisteredService).sorted().peek(arg_0 -> ((JpaServiceRegistry)this).invokeServiceRegistryListenerPostLoad(arg_0)).findFirst().orElse(null);
    }

    @Transactional(transactionManager="transactionManagerServiceReg", readOnly=true)
    public RegisteredService findServiceByExactServiceName(String name) {
        String query = String.format("SELECT r FROM %s r WHERE r.name=:name", "JpaRegisteredServiceEntity");
        List results = this.entityManager.createQuery(query, JpaRegisteredServiceEntity.class).setParameter("name", (Object)name).getResultList();
        return results.stream().map(JpaRegisteredServiceEntity::toRegisteredService).sorted().peek(arg_0 -> ((JpaServiceRegistry)this).invokeServiceRegistryListenerPostLoad(arg_0)).findFirst().orElse(null);
    }

    @Transactional(transactionManager="transactionManagerServiceReg", readOnly=true)
    public long size() {
        String query = String.format("SELECT COUNT(r.id) FROM %s r", "JpaRegisteredServiceEntity");
        return (Long)this.entityManager.createQuery(query, Long.class).getSingleResult();
    }

    private RegisteredService saveInternal(RegisteredService registeredService) {
        boolean isNew = registeredService.getId() == -1L;
        this.invokeServiceRegistryListenerPreSave(registeredService);
        JpaRegisteredServiceEntity entity = JpaRegisteredServiceEntity.fromRegisteredService(registeredService);
        if (isNew) {
            this.entityManager.persist((Object)entity);
            return entity.toRegisteredService();
        }
        JpaRegisteredServiceEntity r = (JpaRegisteredServiceEntity)this.entityManager.merge((Object)entity);
        return r.toRegisteredService();
    }

    @Generated
    public String toString() {
        return "JpaServiceRegistry(transactionTemplate=" + this.transactionTemplate + ", entityManager=" + this.entityManager + ")";
    }

    private static /* synthetic */ RegisteredService lambda$save$1(Supplier supplier, long count) {
        return (RegisteredService)supplier.get();
    }
}

