/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.http.client.utils.URIBuilder;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationConfigurationContext;
import org.apereo.cas.web.view.DynamicHtmlView;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.http.RedirectionAction;
import org.pac4j.core.exception.http.WithContentAction;
import org.pac4j.core.exception.http.WithLocationAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public abstract class BaseDelegatedAuthenticationController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseDelegatedAuthenticationController.class);
    protected static final String ENDPOINT_RESPONSE = "login/{clientName}";
    private final DelegatedClientAuthenticationConfigurationContext configurationContext;

    protected Optional<RedirectionAction> getRedirectionAction(IndirectClient client, WebContext webContext, TransientSessionTicket ticket) {
        Map properties = ticket.getProperties();
        if (properties.containsKey("ForceAuthn")) {
            webContext.setRequestAttribute("ForceAuthn", (Object)true);
        }
        if (properties.containsKey("Passive")) {
            webContext.setRequestAttribute("Passive", (Object)true);
        }
        if (ticket.getService() != null) {
            this.configureWebContextForRegisteredService(webContext, ticket);
        }
        this.configurationContext.getDelegatedClientAuthenticationRequestCustomizers().stream().sorted(AnnotationAwareOrderComparator.INSTANCE).filter(c -> c.supports(client, webContext)).forEach(c -> c.customize(client, webContext));
        return client.getRedirectionActionBuilder().getRedirectionAction(webContext, this.configurationContext.getSessionStore());
    }

    protected void configureWebContextForRegisteredServiceProperties(RegisteredService registeredService, WebContext webContext, List<RegisteredServiceProperty.RegisteredServiceProperties> properties) {
        properties.stream().filter(prop -> prop.isAssignedTo(registeredService)).forEach(prop -> webContext.setRequestAttribute(prop.getPropertyName(), prop.getTypedPropertyValue(registeredService)));
    }

    protected View buildRedirectViewBackToFlow(String clientName, HttpServletRequest request) throws Exception {
        URIBuilder urlBuilder = new URIBuilder(this.configurationContext.getCasProperties().getServer().getLoginUrl());
        request.getParameterMap().forEach((k, v) -> {
            String value = request.getParameter(k);
            urlBuilder.addParameter(k, value);
        });
        urlBuilder.addParameter("client_name", clientName);
        String url = urlBuilder.toString();
        LOGGER.debug("Received response from client [{}]; Redirecting to [{}]", (Object)clientName, (Object)url);
        return new RedirectView(url);
    }

    protected View getResultingView(IndirectClient client, WebContext webContext, TransientSessionTicket ticket) throws Exception {
        client.init();
        if (!client.isInitialized()) {
            throw new IllegalStateException("Unable to initialize client " + client.getName() + ". Verify the client configuration details.");
        }
        Optional<RedirectionAction> actionResult = this.getRedirectionAction(client, webContext, ticket);
        if (actionResult.isPresent()) {
            RedirectionAction action = actionResult.get();
            LOGGER.debug("Determined final redirect action for client [{}] as [{}]", (Object)client, (Object)action);
            if (action instanceof WithLocationAction) {
                WithLocationAction foundAction = (WithLocationAction)WithLocationAction.class.cast(action);
                URIBuilder builder = new URIBuilder(foundAction.getLocation());
                String url = builder.toString();
                LOGGER.debug("Redirecting client [{}] to [{}] based on identifier [{}]", new Object[]{client.getName(), url, ticket.getId()});
                return new RedirectView(url);
            }
            if (action instanceof WithContentAction) {
                WithContentAction seeOtherAction = (WithContentAction)WithContentAction.class.cast(action);
                return new DynamicHtmlView(seeOtherAction.getContent());
            }
        }
        LOGGER.warn("Unable to determine redirect action for client [{}]", (Object)client);
        return null;
    }

    protected void configureWebContextForRegisteredService(WebContext webContext, TransientSessionTicket ticket) {
        RegisteredService registeredService = this.configurationContext.getServicesManager().findServiceBy(ticket.getService());
        AuditableContext audit = AuditableContext.builder().service(ticket.getService()).registeredService(registeredService).build();
        AuditableExecutionResult result = this.configurationContext.getRegisteredServiceAccessStrategyEnforcer().execute(audit);
        result.throwExceptionIfNeeded();
        if (!registeredService.getProperties().isEmpty()) {
            List<RegisteredServiceProperty.RegisteredServiceProperties> delegatedAuthnProperties = Arrays.stream(RegisteredServiceProperty.RegisteredServiceProperties.values()).filter(prop -> prop.isMemberOf(RegisteredServiceProperty.RegisteredServicePropertyGroups.DELEGATED_AUTHN)).collect(Collectors.toList());
            this.configureWebContextForRegisteredServiceProperties(registeredService, webContext, delegatedAuthnProperties);
            List<RegisteredServiceProperty.RegisteredServiceProperties> saml2ServiceProperties = Arrays.stream(RegisteredServiceProperty.RegisteredServiceProperties.values()).filter(prop -> prop.isMemberOf(RegisteredServiceProperty.RegisteredServicePropertyGroups.DELEGATED_AUTHN_SAML2)).collect(Collectors.toList());
            this.configureWebContextForRegisteredServiceProperties(registeredService, webContext, saml2ServiceProperties);
            List<RegisteredServiceProperty.RegisteredServiceProperties> oidcProperties = Arrays.stream(RegisteredServiceProperty.RegisteredServiceProperties.values()).filter(prop -> prop.isMemberOf(RegisteredServiceProperty.RegisteredServicePropertyGroups.DELEGATED_AUTHN_OIDC)).collect(Collectors.toList());
            this.configureWebContextForRegisteredServiceProperties(registeredService, webContext, oidcProperties);
        }
    }

    @Generated
    protected BaseDelegatedAuthenticationController(DelegatedClientAuthenticationConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }

    @Generated
    public DelegatedClientAuthenticationConfigurationContext getConfigurationContext() {
        return this.configurationContext;
    }
}

