/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.Clients;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.core.http.adapter.JEEHttpActionAdapter;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class DelegatedAuthenticationClientLogoutAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedAuthenticationClientLogoutAction.class);
    private final Clients clients;
    private final SessionStore sessionStore;

    protected Event doPreExecute(RequestContext requestContext) {
        Optional clientResult;
        HttpServletResponse response;
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        JEEContext context = new JEEContext(request, response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext));
        UserProfile currentProfile = this.findCurrentProfile(context);
        Optional optional = clientResult = currentProfile == null ? Optional.empty() : this.clients.findClient(currentProfile.getClientName());
        if (clientResult.isPresent()) {
            Client client = (Client)clientResult.get();
            LOGGER.debug("Handling logout for delegated authentication client [{}]", (Object)client);
            WebUtils.putDelegatedAuthenticationClientName((RequestContext)requestContext, (String)client.getName());
            this.sessionStore.set((WebContext)context, "samlRelayState", (Object)client.getName());
        }
        return null;
    }

    protected Event doExecute(RequestContext requestContext) {
        Optional clientResult;
        HttpServletResponse response;
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        JEEContext context = new JEEContext(request, response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext));
        UserProfile currentProfile = this.findCurrentProfile(context);
        Optional optional = clientResult = currentProfile == null ? Optional.empty() : this.clients.findClient(currentProfile.getClientName());
        if (clientResult.isPresent()) {
            Client client = (Client)clientResult.get();
            LOGGER.trace("Located client [{}]", (Object)client);
            WebApplicationService service = WebUtils.getService((RequestContext)requestContext);
            String targetUrl = service != null ? service.getId() : null;
            LOGGER.debug("Logout target url based on service [{}] is [{}]", (Object)service, (Object)targetUrl);
            Optional actionResult = client.getLogoutAction((WebContext)context, this.sessionStore, currentProfile, targetUrl);
            if (actionResult.isPresent()) {
                HttpAction action = (HttpAction)((Object)actionResult.get());
                LOGGER.debug("Adapting logout action [{}] for client [{}]", (Object)action, (Object)client);
                JEEHttpActionAdapter.INSTANCE.adapt(action, (WebContext)context);
            }
        } else {
            LOGGER.debug("The current client cannot be found; No logout action can execute");
        }
        return null;
    }

    private UserProfile findCurrentProfile(JEEContext webContext) {
        ProfileManager pm = new ProfileManager((WebContext)webContext, this.sessionStore);
        Optional profile = pm.getProfile();
        return profile.orElse(null);
    }

    @Generated
    public DelegatedAuthenticationClientLogoutAction(Clients clients, SessionStore sessionStore) {
        this.clients = clients;
        this.sessionStore = sessionStore;
    }
}

