/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.adaptive.AdaptiveAuthenticationPolicy;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.SpringResourceProperties;
import org.apereo.cas.configuration.model.support.cookie.CookieProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationCookieProperties;
import org.apereo.cas.pac4j.client.ChainingDelegatedClientIdentityProviderRedirectionStrategy;
import org.apereo.cas.pac4j.client.DefaultDelegatedClientIdentityProviderRedirectionStrategy;
import org.apereo.cas.pac4j.client.DelegatedClientAuthenticationRequestCustomizer;
import org.apereo.cas.pac4j.client.DelegatedClientIdentityProviderRedirectionStrategy;
import org.apereo.cas.pac4j.client.GroovyDelegatedClientIdentityProviderRedirectionStrategy;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.util.scripting.WatchableGroovyScriptResource;
import org.apereo.cas.validation.DelegatedAuthenticationAccessStrategyHelper;
import org.apereo.cas.web.DefaultDelegatedAuthenticationNavigationController;
import org.apereo.cas.web.DefaultDelegatedClientAuthenticationWebflowManager;
import org.apereo.cas.web.DelegatedAuthenticationCookieGenerator;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.DefaultDelegatedClientIdentityProviderConfigurationProducer;
import org.apereo.cas.web.flow.DelegatedAuthenticationClientFinishLogoutAction;
import org.apereo.cas.web.flow.DelegatedAuthenticationClientLogoutAction;
import org.apereo.cas.web.flow.DelegatedAuthenticationClientRetryAction;
import org.apereo.cas.web.flow.DelegatedAuthenticationErrorViewResolver;
import org.apereo.cas.web.flow.DelegatedAuthenticationWebflowConfigurer;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationAction;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationConfigurationContext;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationWebflowManager;
import org.apereo.cas.web.flow.DelegatedClientIdentityProviderConfigurationGroovyPostProcessor;
import org.apereo.cas.web.flow.DelegatedClientIdentityProviderConfigurationPostProcessor;
import org.apereo.cas.web.flow.DelegatedClientIdentityProviderConfigurationProducer;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategy;
import org.apereo.cas.web.flow.actions.ConsumerExecutionAction;
import org.apereo.cas.web.flow.configurer.CasMultifactorWebflowCustomizer;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.saml2.DelegatedSaml2ClientMetadataController;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.cas.web.support.CookieUtils;
import org.pac4j.core.client.Clients;
import org.pac4j.core.context.session.SessionStore;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.WebProperties;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcProperties;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorViewResolver;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.io.Resource;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Configuration(value="DelegatedAuthenticationWebflowConfiguration", proxyBeanMethods=false)
public class DelegatedAuthenticationWebflowConfiguration {
    private static DelegatedAuthenticationAccessStrategyHelper getDelegatedAuthenticationAccessStrategyHelper(ServicesManager servicesManager, AuditableExecution delegatedAuthenticationPolicyAuditableEnforcer) {
        return new DelegatedAuthenticationAccessStrategyHelper(servicesManager, delegatedAuthenticationPolicyAuditableEnforcer);
    }

    @Configuration(value="DelegatedAuthenticationWebflowEndpointsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class DelegatedAuthenticationWebflowEndpointsConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public DelegatedSaml2ClientMetadataController delegatedSaml2ClientMetadataController(@Qualifier(value="builtClients") Clients builtClients, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean configBean) {
            return new DelegatedSaml2ClientMetadataController(builtClients, configBean);
        }

        @ConditionalOnMissingBean(name={"delegatedClientNavigationController"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public DefaultDelegatedAuthenticationNavigationController delegatedClientNavigationController(@Qualifier(value="delegatedClientAuthenticationConfigurationContext") DelegatedClientAuthenticationConfigurationContext delegatedClientAuthenticationConfigurationContext, @Qualifier(value="delegatedClientWebflowManager") DelegatedClientAuthenticationWebflowManager delegatedClientWebflowManager) {
            return new DefaultDelegatedAuthenticationNavigationController(delegatedClientAuthenticationConfigurationContext, delegatedClientWebflowManager);
        }
    }

    @Configuration(value="DelegatedAuthenticationWebflowContextConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class DelegatedAuthenticationWebflowContextConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"delegatedClientAuthenticationConfigurationContext"})
        public DelegatedClientAuthenticationConfigurationContext delegatedClientAuthenticationConfigurationContext(@Qualifier(value="registeredServiceDelegatedAuthenticationPolicyAuditableEnforcer") AuditableExecution registeredServiceDelegatedAuthenticationPolicyAuditableEnforcer, @Qualifier(value="serviceTicketRequestWebflowEventResolver") CasWebflowEventResolver serviceTicketRequestWebflowEventResolver, @Qualifier(value="initialAuthenticationAttemptWebflowEventResolver") CasDelegatingWebflowEventResolver initialAuthenticationAttemptWebflowEventResolver, @Qualifier(value="adaptiveAuthenticationPolicy") AdaptiveAuthenticationPolicy adaptiveAuthenticationPolicy, CasConfigurationProperties casProperties, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="builtClients") Clients builtClients, @Qualifier(value="delegatedClientIdentityProviderConfigurationProducer") DelegatedClientIdentityProviderConfigurationProducer delegatedClientIdentityProviderConfigurationProducer, @Qualifier(value="delegatedClientIdentityProviderConfigurationPostProcessor") DelegatedClientIdentityProviderConfigurationPostProcessor delegatedClientIdentityProviderConfigurationPostProcessor, @Qualifier(value="delegatedClientDistributedSessionCookieGenerator") CasCookieBuilder delegatedClientDistributedSessionCookieGenerator, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService, @Qualifier(value="defaultAuthenticationSystemSupport") AuthenticationSystemSupport authenticationSystemSupport, @Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor, @Qualifier(value="delegatedClientDistributedSessionStore") SessionStore delegatedClientDistributedSessionStore, @Qualifier(value="defaultTicketFactory") TicketFactory ticketFactory, @Qualifier(value="registeredServiceAccessStrategyEnforcer") AuditableExecution registeredServiceAccessStrategyEnforcer, @Qualifier(value="singleSignOnParticipationStrategy") SingleSignOnParticipationStrategy webflowSingleSignOnParticipationStrategy, @Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies, @Qualifier(value="delegatedAuthenticationCookieGenerator") CasCookieBuilder delegatedAuthenticationCookieGenerator, @Qualifier(value="delegatedClientAuthenticationRequestCustomizers") ObjectProvider<List<DelegatedClientAuthenticationRequestCustomizer>> delegatedClientAuthenticationRequestCustomizers) {
            DelegatedAuthenticationAccessStrategyHelper helper = DelegatedAuthenticationWebflowConfiguration.getDelegatedAuthenticationAccessStrategyHelper(servicesManager, registeredServiceDelegatedAuthenticationPolicyAuditableEnforcer);
            List customizers = Optional.ofNullable((List)delegatedClientAuthenticationRequestCustomizers.getIfAvailable()).orElseGet(ArrayList::new);
            return ((DelegatedClientAuthenticationConfigurationContext.DelegatedClientAuthenticationConfigurationContextBuilder)((DelegatedClientAuthenticationConfigurationContext.DelegatedClientAuthenticationConfigurationContextBuilder)((DelegatedClientAuthenticationConfigurationContext.DelegatedClientAuthenticationConfigurationContextBuilder)((DelegatedClientAuthenticationConfigurationContext.DelegatedClientAuthenticationConfigurationContextBuilder)((DelegatedClientAuthenticationConfigurationContext.DelegatedClientAuthenticationConfigurationContextBuilder)((DelegatedClientAuthenticationConfigurationContext.DelegatedClientAuthenticationConfigurationContextBuilder)((DelegatedClientAuthenticationConfigurationContext.DelegatedClientAuthenticationConfigurationContextBuilder)((DelegatedClientAuthenticationConfigurationContext.DelegatedClientAuthenticationConfigurationContextBuilder)((DelegatedClientAuthenticationConfigurationContext.DelegatedClientAuthenticationConfigurationContextBuilder)((DelegatedClientAuthenticationConfigurationContext.DelegatedClientAuthenticationConfigurationContextBuilder)((DelegatedClientAuthenticationConfigurationContext.DelegatedClientAuthenticationConfigurationContextBuilder)((DelegatedClientAuthenticationConfigurationContext.DelegatedClientAuthenticationConfigurationContextBuilder)((DelegatedClientAuthenticationConfigurationContext.DelegatedClientAuthenticationConfigurationContextBuilder)((DelegatedClientAuthenticationConfigurationContext.DelegatedClientAuthenticationConfigurationContextBuilder)((DelegatedClientAuthenticationConfigurationContext.DelegatedClientAuthenticationConfigurationContextBuilder)((DelegatedClientAuthenticationConfigurationContext.DelegatedClientAuthenticationConfigurationContextBuilder)((DelegatedClientAuthenticationConfigurationContext.DelegatedClientAuthenticationConfigurationContextBuilder)((DelegatedClientAuthenticationConfigurationContext.DelegatedClientAuthenticationConfigurationContextBuilder)((DelegatedClientAuthenticationConfigurationContext.DelegatedClientAuthenticationConfigurationContextBuilder)((DelegatedClientAuthenticationConfigurationContext.DelegatedClientAuthenticationConfigurationContextBuilder)((DelegatedClientAuthenticationConfigurationContext.DelegatedClientAuthenticationConfigurationContextBuilder)DelegatedClientAuthenticationConfigurationContext.builder().initialAuthenticationAttemptWebflowEventResolver(initialAuthenticationAttemptWebflowEventResolver)).serviceTicketRequestWebflowEventResolver(serviceTicketRequestWebflowEventResolver)).adaptiveAuthenticationPolicy(adaptiveAuthenticationPolicy)).clients(builtClients)).servicesManager(servicesManager)).delegatedAuthenticationPolicyEnforcer(registeredServiceDelegatedAuthenticationPolicyAuditableEnforcer)).authenticationSystemSupport(authenticationSystemSupport)).casProperties(casProperties)).centralAuthenticationService(centralAuthenticationService)).authenticationRequestServiceSelectionStrategies(authenticationRequestServiceSelectionStrategies)).singleSignOnParticipationStrategy(webflowSingleSignOnParticipationStrategy)).sessionStore(delegatedClientDistributedSessionStore)).argumentExtractor(argumentExtractor)).ticketFactory(ticketFactory)).delegatedClientIdentityProvidersProducer(delegatedClientIdentityProviderConfigurationProducer)).delegatedClientIdentityProviderConfigurationPostProcessor(delegatedClientIdentityProviderConfigurationPostProcessor)).delegatedClientCookieGenerator(delegatedAuthenticationCookieGenerator)).delegatedClientDistributedSessionCookieGenerator(delegatedClientDistributedSessionCookieGenerator)).registeredServiceAccessStrategyEnforcer(registeredServiceAccessStrategyEnforcer)).delegatedClientAuthenticationRequestCustomizers(customizers)).delegatedAuthenticationAccessStrategyHelper(helper)).build();
        }
    }

    @Configuration(value="DelegatedAuthenticationWebflowActionsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class DelegatedAuthenticationWebflowActionsConfiguration {
        @ConditionalOnMissingBean(name={"delegatedAuthenticationClientLogoutAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action delegatedAuthenticationClientLogoutAction(CasConfigurationProperties casProperties, @Qualifier(value="builtClients") Clients builtClients, @Qualifier(value="delegatedClientDistributedSessionStore") SessionStore delegatedClientDistributedSessionStore) {
            return casProperties.getSlo().isDisabled() ? ConsumerExecutionAction.NONE : new DelegatedAuthenticationClientLogoutAction(builtClients, delegatedClientDistributedSessionStore);
        }

        @ConditionalOnMissingBean(name={"delegatedAuthenticationClientFinishLogoutAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action delegatedAuthenticationClientFinishLogoutAction(@Qualifier(value="builtClients") Clients builtClients, @Qualifier(value="delegatedClientDistributedSessionStore") SessionStore delegatedClientDistributedSessionStore) {
            return new DelegatedAuthenticationClientFinishLogoutAction(builtClients, delegatedClientDistributedSessionStore);
        }

        @ConditionalOnMissingBean(name={"delegatedAuthenticationClientRetryAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action delegatedAuthenticationClientRetryAction(@Qualifier(value="delegatedClientIdentityProviderConfigurationProducer") DelegatedClientIdentityProviderConfigurationProducer delegatedClientIdentityProviderConfigurationProducer, @Qualifier(value="builtClients") Clients builtClients) {
            return new DelegatedAuthenticationClientRetryAction(builtClients, delegatedClientIdentityProviderConfigurationProducer);
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"delegatedAuthenticationAction"})
        @Bean
        public Action delegatedAuthenticationAction(@Qualifier(value="delegatedClientAuthenticationConfigurationContext") DelegatedClientAuthenticationConfigurationContext delegatedClientAuthenticationConfigurationContext, @Qualifier(value="delegatedClientWebflowManager") DelegatedClientAuthenticationWebflowManager delegatedClientWebflowManager) {
            return new DelegatedClientAuthenticationAction(delegatedClientAuthenticationConfigurationContext, delegatedClientWebflowManager);
        }
    }

    @Configuration(value="DelegatedAuthenticationWebflowClientConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class DelegatedAuthenticationWebflowClientConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"delegatedClientIdentityProviderConfigurationPostProcessor"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public DelegatedClientIdentityProviderConfigurationPostProcessor delegatedClientIdentityProviderConfigurationPostProcessor(CasConfigurationProperties casProperties) {
            Resource resource = casProperties.getAuthn().getPac4j().getCore().getGroovyProviderPostProcessor().getLocation();
            if (resource == null) {
                return DelegatedClientIdentityProviderConfigurationPostProcessor.noOp();
            }
            return new DelegatedClientIdentityProviderConfigurationGroovyPostProcessor(new WatchableGroovyScriptResource(resource));
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"delegatedClientIdentityProviderConfigurationProducer"})
        public DelegatedClientIdentityProviderConfigurationProducer delegatedClientIdentityProviderConfigurationProducer(@Qualifier(value="registeredServiceDelegatedAuthenticationPolicyAuditableEnforcer") AuditableExecution registeredServiceDelegatedAuthenticationPolicyAuditableEnforcer, @Qualifier(value="servicesManager") ServicesManager servicesManager, CasConfigurationProperties casProperties, @Qualifier(value="delegatedClientAuthenticationRequestCustomizers") ObjectProvider<List<DelegatedClientAuthenticationRequestCustomizer>> delegatedClientAuthenticationRequestCustomizers, @Qualifier(value="delegatedClientIdentityProviderRedirectionStrategy") DelegatedClientIdentityProviderRedirectionStrategy delegatedClientIdentityProviderRedirectionStrategy, @Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies, @Qualifier(value="builtClients") Clients builtClients) {
            List customizers = Optional.ofNullable((List)delegatedClientAuthenticationRequestCustomizers.getIfAvailable()).orElseGet(ArrayList::new);
            DelegatedAuthenticationAccessStrategyHelper helper = DelegatedAuthenticationWebflowConfiguration.getDelegatedAuthenticationAccessStrategyHelper(servicesManager, registeredServiceDelegatedAuthenticationPolicyAuditableEnforcer);
            return new DefaultDelegatedClientIdentityProviderConfigurationProducer(authenticationRequestServiceSelectionStrategies, builtClients, helper, casProperties, customizers, delegatedClientIdentityProviderRedirectionStrategy);
        }

        @ConditionalOnMissingBean(name={"delegatedClientIdentityProviderRedirectionStrategy"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public DelegatedClientIdentityProviderRedirectionStrategy delegatedClientIdentityProviderRedirectionStrategy(CasConfigurationProperties casProperties, @Qualifier(value="delegatedAuthenticationCookieGenerator") CasCookieBuilder delegatedAuthenticationCookieGenerator, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            ChainingDelegatedClientIdentityProviderRedirectionStrategy chain = new ChainingDelegatedClientIdentityProviderRedirectionStrategy();
            SpringResourceProperties strategy = casProperties.getAuthn().getPac4j().getCore().getGroovyRedirectionStrategy();
            if (strategy.getLocation() != null) {
                chain.addStrategy((DelegatedClientIdentityProviderRedirectionStrategy)new GroovyDelegatedClientIdentityProviderRedirectionStrategy(servicesManager, new WatchableGroovyScriptResource(strategy.getLocation())));
            }
            chain.addStrategy((DelegatedClientIdentityProviderRedirectionStrategy)new DefaultDelegatedClientIdentityProviderRedirectionStrategy(servicesManager, delegatedAuthenticationCookieGenerator, casProperties));
            return chain;
        }

        @ConditionalOnMissingBean(name={"delegatedAuthenticationCookieGenerator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasCookieBuilder delegatedAuthenticationCookieGenerator(CasConfigurationProperties casProperties) {
            Pac4jDelegatedAuthenticationCookieProperties props = casProperties.getAuthn().getPac4j().getCookie();
            return new DelegatedAuthenticationCookieGenerator(CookieUtils.buildCookieGenerationContext((CookieProperties)props));
        }
    }

    @Configuration(value="DelegatedAuthenticationWebflowManagementConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class DelegatedAuthenticationWebflowManagementConfiguration {
        @ConditionalOnMissingBean(name={"delegatedClientWebflowManager"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public DelegatedClientAuthenticationWebflowManager delegatedClientWebflowManager(@Qualifier(value="delegatedClientAuthenticationConfigurationContext") DelegatedClientAuthenticationConfigurationContext delegatedClientAuthenticationConfigurationContext) {
            return new DefaultDelegatedClientAuthenticationWebflowManager(delegatedClientAuthenticationConfigurationContext);
        }

        @Bean
        @ConditionalOnMissingBean(name={"delegatedAuthenticationCasMultifactorWebflowCustomizer"})
        public CasMultifactorWebflowCustomizer delegatedAuthenticationCasMultifactorWebflowCustomizer() {
            return new CasMultifactorWebflowCustomizer(){

                public Collection<String> getCandidateStatesForMultifactorAuthentication() {
                    return List.of("delegatedAuthentication");
                }
            };
        }
    }

    @Configuration(value="DelegatedAuthenticationWebflowPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class DelegatedAuthenticationWebflowPlanConfiguration {
        @ConditionalOnMissingBean(name={"delegatedAuthenticationWebflowConfigurer"})
        @Bean
        public CasWebflowConfigurer delegatedAuthenticationWebflowConfigurer(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry loginFlowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices, @Qualifier(value="logoutFlowRegistry") FlowDefinitionRegistry logoutFlowDefinitionRegistry) {
            return new DelegatedAuthenticationWebflowConfigurer(flowBuilderServices, loginFlowDefinitionRegistry, logoutFlowDefinitionRegistry, applicationContext, casProperties);
        }
    }

    @Configuration(value="DelegatedAuthenticationWebflowExecutionPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class DelegatedAuthenticationWebflowExecutionPlanConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"delegatedCasWebflowExecutionPlanConfigurer"})
        public CasWebflowExecutionPlanConfigurer delegatedCasWebflowExecutionPlanConfigurer(@Qualifier(value="delegatedAuthenticationWebflowConfigurer") CasWebflowConfigurer delegatedAuthenticationWebflowConfigurer) {
            return plan -> plan.registerWebflowConfigurer(delegatedAuthenticationWebflowConfigurer);
        }
    }

    @Configuration(value="DelegatedAuthenticationWebflowErrorConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class, WebProperties.class, WebMvcProperties.class})
    public static class DelegatedAuthenticationWebflowErrorConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"pac4jErrorViewResolver"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ErrorViewResolver pac4jErrorViewResolver(WebProperties webProperties, ConfigurableApplicationContext applicationContext) {
            return new DelegatedAuthenticationErrorViewResolver((ApplicationContext)applicationContext, webProperties.getResources());
        }
    }
}

