/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.configuration.model.support.pm.PasswordManagementProperties;
import org.apereo.cas.pm.LdapPasswordManagementService;
import org.apereo.cas.pm.PasswordHistoryService;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.util.LdapUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.ldaptive.ConnectionFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@Configuration(value="LdapPasswordManagementConfiguration", proxyBeanMethods=false)
@ConditionalOnProperty(name={"cas.authn.pm.ldap[0].ldap-url"})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class LdapPasswordManagementConfiguration {
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    public PasswordManagementService passwordChangeService(CasConfigurationProperties casProperties, @Qualifier(value="passwordManagementCipherExecutor") CipherExecutor passwordManagementCipherExecutor, @Qualifier(value="passwordHistoryService") PasswordHistoryService passwordHistoryService) {
        ConcurrentHashMap<String, ConnectionFactory> connectionFactoryMap = new ConcurrentHashMap<String, ConnectionFactory>();
        PasswordManagementProperties passwordManagerProperties = casProperties.getAuthn().getPm();
        passwordManagerProperties.getLdap().forEach(ldap -> connectionFactoryMap.put(ldap.getLdapUrl(), LdapUtils.newLdaptiveConnectionFactory((AbstractLdapProperties)ldap)));
        return new LdapPasswordManagementService((CipherExecutor<Serializable, String>)passwordManagementCipherExecutor, casProperties.getServer().getPrefix(), passwordManagerProperties, passwordHistoryService, connectionFactoryMap);
    }
}

