/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.idp.metadata;

import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.configuration.model.support.saml.idp.metadata.JpaSamlMetadataProperties;
import org.apereo.cas.support.saml.idp.metadata.generator.BaseSamlIdPMetadataGenerator;
import org.apereo.cas.support.saml.idp.metadata.generator.SamlIdPMetadataGenerator;
import org.apereo.cas.support.saml.idp.metadata.generator.SamlIdPMetadataGeneratorConfigurationContext;
import org.apereo.cas.support.saml.idp.metadata.jpa.JpaSamlIdPMetadataDocumentFactory;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlIdPMetadataDocument;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@EnableTransactionManagement
@Transactional(transactionManager="transactionManagerSamlMetadataIdP")
public class JpaSamlIdPMetadataGenerator
extends BaseSamlIdPMetadataGenerator
implements InitializingBean {
    private final TransactionTemplate transactionTemplate;
    @PersistenceContext(unitName="samlMetadataIdPEntityManagerFactory")
    private transient EntityManager entityManager;

    public JpaSamlIdPMetadataGenerator(SamlIdPMetadataGeneratorConfigurationContext context, TransactionTemplate transactionTemplate) {
        super(context);
        this.transactionTemplate = transactionTemplate;
    }

    private void saveSamlIdPMetadataDocument(final SamlIdPMetadataDocument doc) {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                JpaSamlIdPMetadataGenerator.this.entityManager.merge((Object)doc);
            }
        });
    }

    public void afterPropertiesSet() throws Exception {
        this.generate(Optional.empty());
    }

    protected SamlIdPMetadataDocument newSamlIdPMetadataDocument() {
        JpaSamlMetadataProperties jpa = this.getConfigurationContext().getCasProperties().getAuthn().getSamlIdp().getMetadata().getJpa();
        return (SamlIdPMetadataDocument)new JpaSamlIdPMetadataDocumentFactory(jpa.getDialect()).newInstance();
    }

    protected SamlIdPMetadataDocument finalizeMetadataDocument(SamlIdPMetadataDocument doc, Optional<SamlRegisteredService> registeredService) {
        doc.setAppliesTo(SamlIdPMetadataGenerator.getAppliesToFor(registeredService));
        this.saveSamlIdPMetadataDocument(doc);
        return doc;
    }

    public Pair<String, String> buildSelfSignedEncryptionCert(Optional<SamlRegisteredService> registeredService) throws Exception {
        return this.generateCertificateAndKey();
    }

    public Pair<String, String> buildSelfSignedSigningCert(Optional<SamlRegisteredService> registeredService) throws Exception {
        return this.generateCertificateAndKey();
    }
}

