/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services;

import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authentication.BaseAuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.ServicesManager;
import org.jasig.cas.client.util.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlIdPEntityIdAuthenticationServiceSelectionStrategy
extends BaseAuthenticationServiceSelectionStrategy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPEntityIdAuthenticationServiceSelectionStrategy.class);
    private static final long serialVersionUID = -2059445756475980894L;
    private final String casServiceUrlPattern;

    public SamlIdPEntityIdAuthenticationServiceSelectionStrategy(ServicesManager servicesManager, ServiceFactory<WebApplicationService> webApplicationServiceFactory, String casServerPrefix) {
        super(servicesManager, webApplicationServiceFactory);
        this.casServiceUrlPattern = "^".concat(casServerPrefix).concat(".*");
    }

    public Service resolveServiceFrom(Service service) {
        String entityId = SamlIdPEntityIdAuthenticationServiceSelectionStrategy.getEntityIdAsParameter(service).orElseThrow().getValue();
        LOGGER.trace("Located entity id [{}] from service authentication request at [{}]", (Object)entityId, (Object)service.getId());
        return this.createService(entityId, service);
    }

    public boolean supports(Service service) {
        return service != null && service.getId().matches(this.casServiceUrlPattern) && SamlIdPEntityIdAuthenticationServiceSelectionStrategy.getEntityIdAsParameter(service).isPresent();
    }

    protected static Optional<URIBuilder.BasicNameValuePair> getEntityIdAsParameter(Service service) {
        URIBuilder builder = new URIBuilder(service.getId());
        return builder.getQueryParams().stream().filter(p -> p.getName().equals("entityId")).findFirst();
    }

    @Generated
    public String getCasServiceUrlPattern() {
        return this.casServiceUrlPattern;
    }
}

