/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.artifact;

import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.web.idp.profile.AbstractSamlIdPProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.SamlProfileHandlerConfigurationContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.AuthenticatedAssertionContext;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.artifact.SamlArtifactTicket;
import org.apereo.cas.ticket.artifact.SamlArtifactTicketFactory;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.saml2.core.ArtifactResolve;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;

public class SamlIdPSaml1ArtifactResolutionProfileHandlerController
extends AbstractSamlIdPProfileHandlerController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPSaml1ArtifactResolutionProfileHandlerController.class);

    public SamlIdPSaml1ArtifactResolutionProfileHandlerController(SamlProfileHandlerConfigurationContext ctx) {
        super(ctx);
    }

    @PostMapping(path={"/idp/profile/SAML1/SOAP/ArtifactResolution"})
    protected void handlePostRequest(HttpServletResponse response, HttpServletRequest request) {
        MessageContext ctx = this.decodeSoapRequest(request);
        ArtifactResolve artifactMsg = (ArtifactResolve)ctx.getMessage();
        try {
            String issuer = Objects.requireNonNull(artifactMsg).getIssuer().getValue();
            SamlRegisteredService registeredService = this.verifySamlRegisteredService(issuer);
            Optional<SamlRegisteredServiceServiceProviderMetadataFacade> adaptor = this.getSamlMetadataFacadeFor(registeredService, (RequestAbstractType)artifactMsg);
            if (adaptor.isEmpty()) {
                throw new UnauthorizedServiceException("screen.service.error.message", "Cannot find metadata linked to " + issuer);
            }
            SamlRegisteredServiceServiceProviderMetadataFacade facade = adaptor.get();
            this.verifyAuthenticationContextSignature(ctx, request, (RequestAbstractType)artifactMsg, facade, registeredService);
            String artifactId = artifactMsg.getArtifact().getValue();
            SamlArtifactTicketFactory factory = (SamlArtifactTicketFactory)this.getConfigurationContext().getTicketFactory().get(SamlArtifactTicket.class);
            String ticketId = factory.createTicketIdFor(artifactId);
            SamlArtifactTicket ticket = (SamlArtifactTicket)this.getConfigurationContext().getTicketRegistry().getTicket(ticketId, SamlArtifactTicket.class);
            if (ticket == null) {
                throw new InvalidTicketException(ticketId);
            }
            WebApplicationService issuerService = (WebApplicationService)this.getConfigurationContext().getWebApplicationServiceFactory().createService(issuer);
            AuthenticatedAssertionContext casAssertion = this.buildCasAssertion(ticket.getTicketGrantingTicket().getAuthentication(), (Service)issuerService, (RegisteredService)registeredService, CollectionUtils.wrap((String)"artifact", (Object)ticket));
            this.getConfigurationContext().getResponseBuilder().build((RequestAbstractType)artifactMsg, request, response, casAssertion, registeredService, facade, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", ctx);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            request.setAttribute("samlError", (Object)("Unable to build SOAP response: " + StringUtils.defaultString((String)e.getMessage())));
            this.getConfigurationContext().getSamlFaultResponseBuilder().build((RequestAbstractType)artifactMsg, request, response, null, null, null, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", ctx);
        }
    }
}

