/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.attr;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.authentication.ProtocolAttributeEncoder;
import org.apereo.cas.authentication.attribute.AttributeDefinition;
import org.apereo.cas.authentication.attribute.AttributeDefinitionStore;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPResponseProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.util.AbstractSaml20ObjectBuilder;
import org.apereo.cas.support.saml.util.Saml20AttributeBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.AuthenticatedAssertionContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.attr.SamlIdPAttributeDefinition;
import org.apereo.cas.support.saml.web.idp.profile.builders.attr.SamlIdPAttributeDefinitionCatalog;
import org.apereo.cas.support.saml.web.idp.profile.builders.attr.SamlProfileSamlRegisteredServiceAttributeBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlIdPObjectEncrypter;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.NameIDType;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class SamlProfileSamlAttributeStatementBuilder
extends AbstractSaml20ObjectBuilder
implements SamlProfileObjectBuilder<AttributeStatement> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlProfileSamlAttributeStatementBuilder.class);
    private static final long serialVersionUID = 1815697787562189088L;
    private final SamlIdPProperties samlIdPProperties;
    private final SamlIdPObjectEncrypter samlObjectEncrypter;
    private final AttributeDefinitionStore attributeDefinitionStore;
    private final ServiceFactory<WebApplicationService> serviceFactory;
    private final SamlProfileObjectBuilder<SAMLObject> samlNameIdBuilder;
    private final MetadataResolver samlIdPMetadataResolver;

    public SamlProfileSamlAttributeStatementBuilder(OpenSamlConfigBean configBean, SamlIdPProperties samlIdPProperties, SamlIdPObjectEncrypter samlObjectEncrypter, AttributeDefinitionStore attributeDefinitionStore, ServiceFactory<WebApplicationService> serviceFactory, SamlProfileObjectBuilder<SAMLObject> samlNameIdBuilder, MetadataResolver samlIdPMetadataResolver) {
        super(configBean);
        this.samlIdPProperties = samlIdPProperties;
        this.samlObjectEncrypter = samlObjectEncrypter;
        this.attributeDefinitionStore = attributeDefinitionStore;
        this.serviceFactory = serviceFactory;
        this.samlNameIdBuilder = samlNameIdBuilder;
        this.samlIdPMetadataResolver = samlIdPMetadataResolver;
    }

    @Override
    public AttributeStatement build(RequestAbstractType authnRequest, HttpServletRequest request, HttpServletResponse response, AuthenticatedAssertionContext assertion, SamlRegisteredService registeredService, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, String binding, MessageContext messageContext) throws SamlException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(assertion.getAttributes());
        WebApplicationService webApplicationService = (WebApplicationService)this.serviceFactory.createService(adaptor.getEntityId(), WebApplicationService.class);
        Map encodedAttrs = ProtocolAttributeEncoder.decodeAttributes(attributes, (RegisteredService)registeredService, (WebApplicationService)webApplicationService);
        SamlProfileSamlRegisteredServiceAttributeBuilder attrBuilder = new SamlProfileSamlRegisteredServiceAttributeBuilder(registeredService, adaptor, this.samlObjectEncrypter);
        return this.newAttributeStatement(authnRequest, request, response, assertion, registeredService, adaptor, binding, messageContext, encodedAttrs, (Saml20AttributeBuilder)attrBuilder);
    }

    public AttributeStatement newAttributeStatement(RequestAbstractType authnRequest, HttpServletRequest request, HttpServletResponse response, AuthenticatedAssertionContext casAssertion, SamlRegisteredService samlRegisteredService, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, String binding, MessageContext messageContext, Map<String, Object> attributes, Saml20AttributeBuilder builder) {
        AttributeStatement attrStatement = (AttributeStatement)SamlUtils.newSamlObject(AttributeStatement.class);
        SamlIdPResponseProperties resp = this.samlIdPProperties.getResponse();
        HashMap nameFormats = new HashMap(resp.configureAttributeNameFormats());
        nameFormats.putAll(samlRegisteredService.getAttributeNameFormats());
        List globalFriendlyNames = this.samlIdPProperties.getCore().getAttributeFriendlyNames();
        HashMap friendlyNames = new HashMap(CollectionUtils.convertDirectedListToMap((Collection)globalFriendlyNames));
        HashMap urns = new HashMap();
        this.attributeDefinitionStore.getAttributeDefinitions().stream().filter(defn -> defn instanceof SamlIdPAttributeDefinition).map(SamlIdPAttributeDefinition.class::cast).forEach(defn -> {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)defn.getFriendlyName())) {
                friendlyNames.put(defn.getKey(), defn.getFriendlyName());
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)defn.getUrn())) {
                urns.put(defn.getKey(), defn.getUrn());
            }
        });
        friendlyNames.putAll(samlRegisteredService.getAttributeFriendlyNames());
        SamlIdPAttributeDefinitionCatalog.load().filter(defn -> !friendlyNames.containsKey(defn.getKey())).forEach(defn -> {
            friendlyNames.put(defn.getKey(), defn.getFriendlyName());
            urns.put(defn.getKey(), defn.getUrn());
        });
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            Object attributeValue = entry.getValue();
            if (attributeValue instanceof Collection && ((Collection)attributeValue).isEmpty()) {
                LOGGER.info("Skipping attribute [{}] because it does not have any values.", (Object)entry.getKey());
                continue;
            }
            String friendlyName = friendlyNames.getOrDefault(entry.getKey(), null);
            Collection<String> attributeNames = urns.containsKey(entry.getKey()) ? List.of((String)urns.get(entry.getKey())) : this.getMappedAttributeNamesFromAttributeDefinitionStore(entry);
            for (String name : attributeNames) {
                SAMLObject nameIdObject;
                LOGGER.trace("Processing SAML attribute [{}] with value [{}], friendlyName [{}]", new Object[]{name, attributeValue, friendlyName});
                String valueType = (String)samlRegisteredService.getAttributeValueTypes().get(name);
                if (NameIDType.class.getSimpleName().equalsIgnoreCase(valueType) && (nameIdObject = this.samlNameIdBuilder.build(authnRequest, request, response, casAssertion, samlRegisteredService, adaptor, binding, messageContext)) instanceof NameID) {
                    NameID nameID = (NameID)this.newSamlObject(NameID.class);
                    NameID nameId = (NameID)nameIdObject;
                    nameID.setFormat(nameId.getFormat());
                    nameID.setNameQualifier(nameId.getNameQualifier());
                    nameID.setSPNameQualifier(nameId.getSPNameQualifier());
                    nameID.setValue(nameId.getValue());
                    attributeValue = nameID;
                }
                if ("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent".equalsIgnoreCase(valueType)) {
                    NameID nameID = (NameID)this.newSamlObject(NameID.class);
                    nameID.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
                    nameID.setNameQualifier(SamlIdPUtils.determineNameIdNameQualifier((SamlRegisteredService)samlRegisteredService, (MetadataResolver)this.samlIdPMetadataResolver));
                    FunctionUtils.doIf((boolean)org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)samlRegisteredService.getServiceProviderNameIdQualifier()), value -> nameID.setSPNameQualifier(samlRegisteredService.getServiceProviderNameIdQualifier()), value -> nameID.setSPNameQualifier(adaptor.getEntityId())).accept(samlRegisteredService);
                    CollectionUtils.firstElement((Object)attributeValue).ifPresent(value -> nameID.setValue(value.toString()));
                    attributeValue = nameID;
                }
                LOGGER.debug("Creating SAML attribute [{}] with value [{}], friendlyName [{}]", new Object[]{name, attributeValue, friendlyName});
                Attribute attribute = this.newAttribute(friendlyName, name, attributeValue, nameFormats, resp.getDefaultAttributeNameFormat(), samlRegisteredService.getAttributeValueTypes());
                LOGGER.trace("Created SAML attribute [{}] with NameID format [{}]", (Object)attribute.getName(), (Object)attribute.getNameFormat());
                builder.build(attrStatement, attribute);
            }
        }
        return attrStatement;
    }

    protected Collection<String> getMappedAttributeNamesFromAttributeDefinitionStore(Map.Entry<String, Object> entry) {
        return StringUtils.commaDelimitedListToSet((String)this.attributeDefinitionStore.locateAttributeDefinition(entry.getKey()).map(AttributeDefinition::getName).filter(org.apache.commons.lang3.StringUtils::isNotBlank).orElseGet(entry::getKey));
    }
}

