/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.authn;

import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.util.AbstractSaml20ObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.AuthenticatedAssertionContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.authn.AuthnContextClassRefBuilder;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.RandomUtils;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.jasig.cas.client.util.CommonUtils;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.SubjectLocality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlProfileSamlAuthNStatementBuilder
extends AbstractSaml20ObjectBuilder
implements SamlProfileObjectBuilder<AuthnStatement> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlProfileSamlAuthNStatementBuilder.class);
    private static final long serialVersionUID = 8761566449790497226L;
    private final transient AuthnContextClassRefBuilder authnContextClassRefBuilder;
    private final CasConfigurationProperties casProperties;

    public SamlProfileSamlAuthNStatementBuilder(OpenSamlConfigBean configBean, AuthnContextClassRefBuilder authnContextClassRefBuilder, CasConfigurationProperties casProperties) {
        super(configBean);
        this.authnContextClassRefBuilder = authnContextClassRefBuilder;
        this.casProperties = casProperties;
    }

    @Override
    public AuthnStatement build(RequestAbstractType authnRequest, HttpServletRequest request, HttpServletResponse response, AuthenticatedAssertionContext assertion, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, String binding, MessageContext messageContext) throws SamlException {
        return this.buildAuthnStatement(assertion, authnRequest, adaptor, service, binding, request);
    }

    protected SubjectLocality buildSubjectLocality(AuthenticatedAssertionContext assertion, RequestAbstractType authnRequest, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, String binding, SamlRegisteredService service) throws SamlException {
        SubjectLocality subjectLocality = (SubjectLocality)SamlUtils.newSamlObject(SubjectLocality.class);
        String issuer = SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)authnRequest);
        String clientRemoteIpAddr = Optional.ofNullable(ClientInfoHolder.getClientInfo()).map(ClientInfo::getClientIpAddress).orElse("");
        String hostAddress = StringUtils.defaultString((String)service.getSubjectLocality(), (String)clientRemoteIpAddr);
        LOGGER.debug("Built SAML2 subject locality address [{}] for [{}]", (Object)hostAddress, (Object)issuer);
        subjectLocality.setAddress(hostAddress);
        return subjectLocality;
    }

    private AuthnStatement buildAuthnStatement(AuthenticatedAssertionContext casAssertion, RequestAbstractType authnRequest, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, SamlRegisteredService service, String binding, HttpServletRequest request) throws SamlException {
        SubjectLocality subjectLocality;
        Object id;
        String authenticationMethod = this.authnContextClassRefBuilder.build(casAssertion, authnRequest, adaptor, service);
        Object object = id = request != null ? CommonUtils.safeGetParameter((HttpServletRequest)request, (String)"ticket") : "";
        if (StringUtils.isBlank((CharSequence)id)) {
            LOGGER.info("Unable to locate service ticket as the session index; Generating random identifier instead...");
            id = "_" + String.valueOf(RandomUtils.nextLong());
        }
        AuthnStatement statement = this.newAuthnStatement(authenticationMethod, DateTimeUtils.zonedDateTimeOf((TemporalAccessor)casAssertion.getAuthenticationDate()), (String)id);
        if (casAssertion.getValidUntilDate() != null) {
            ZonedDateTime dt = DateTimeUtils.zonedDateTimeOf((TemporalAccessor)casAssertion.getValidUntilDate());
            long skewAllowance = service.getSkewAllowance() > 0 ? (long)service.getSkewAllowance() : Beans.newDuration((String)this.casProperties.getAuthn().getSamlIdp().getResponse().getSkewAllowance()).toSeconds();
            statement.setSessionNotOnOrAfter(dt.plusSeconds(skewAllowance).toInstant());
        }
        if ((subjectLocality = this.buildSubjectLocality(casAssertion, authnRequest, adaptor, binding, service)) != null) {
            statement.setSubjectLocality(subjectLocality);
        }
        return statement;
    }
}

