/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.nameid;

import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.profile.AbstractSAML2NameIDGenerator;
import org.opensaml.saml.saml2.profile.SAML2NameIDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlAttributeBasedNameIdGenerator
extends AbstractSAML2NameIDGenerator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlAttributeBasedNameIdGenerator.class);
    private final String attributeValue;

    public static SAML2NameIDGenerator get(Optional<RequestAbstractType> authnRequest, String nameFormat, SamlRegisteredService service, String attributeValue) {
        SamlAttributeBasedNameIdGenerator encoder = new SamlAttributeBasedNameIdGenerator(attributeValue);
        encoder.setId(SamlAttributeBasedNameIdGenerator.class.getSimpleName());
        encoder.setFormat(nameFormat);
        encoder.setDefaultIdPNameQualifierLookupStrategy(baseContexts -> service.getNameIdQualifier());
        encoder.setDefaultSPNameQualifierLookupStrategy(baseContexts -> service.getServiceProviderNameIdQualifier());
        authnRequest.flatMap(SamlIdPUtils::getNameIDPolicy).ifPresent(policy -> {
            String qualifier = policy.getSPNameQualifier();
            LOGGER.debug("NameID SP qualifier is set to [{}]", (Object)qualifier);
            encoder.setSPNameQualifier(qualifier);
        });
        encoder.setIdPNameQualifier(service.getNameIdQualifier());
        encoder.setOmitQualifiers(service.isSkipGeneratingNameIdQualifiers());
        encoder.initialize();
        return encoder;
    }

    protected String getIdentifier(@NonNull ProfileRequestContext profileRequestContext) {
        if (profileRequestContext == null) {
            throw new NullPointerException("profileRequestContext is marked non-null but is null");
        }
        return this.attributeValue;
    }

    @Generated
    public SamlAttributeBasedNameIdGenerator(String attributeValue) {
        this.attributeValue = attributeValue;
    }

    @Generated
    private SamlAttributeBasedNameIdGenerator() {
        this.attributeValue = null;
    }
}

