/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.conditions;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.util.AbstractSaml20ObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.AuthenticatedAssertionContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.springframework.util.StringUtils;

public class SamlProfileSamlConditionsBuilder
extends AbstractSaml20ObjectBuilder
implements SamlProfileObjectBuilder<Conditions> {
    private static final long serialVersionUID = 126393045912318783L;
    private final CasConfigurationProperties casProperties;

    public SamlProfileSamlConditionsBuilder(OpenSamlConfigBean configBean, CasConfigurationProperties casProperties) {
        super(configBean);
        this.casProperties = casProperties;
    }

    @Override
    public Conditions build(RequestAbstractType authnRequest, HttpServletRequest request, HttpServletResponse response, AuthenticatedAssertionContext assertion, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, String binding, MessageContext messageContext) throws SamlException {
        return this.buildConditions(authnRequest, assertion, service, adaptor, messageContext);
    }

    protected Conditions buildConditions(RequestAbstractType authnRequest, AuthenticatedAssertionContext assertion, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, MessageContext messageContext) throws SamlException {
        long skewAllowance;
        ZonedDateTime currentDateTime = ZonedDateTime.now(ZoneOffset.UTC);
        long l = skewAllowance = service.getSkewAllowance() > 0 ? (long)service.getSkewAllowance() : Beans.newDuration((String)this.casProperties.getAuthn().getSamlIdp().getResponse().getSkewAllowance()).toSeconds();
        if (skewAllowance <= 0L) {
            skewAllowance = Beans.newDuration((String)this.casProperties.getSamlCore().getSkewAllowance()).toSeconds();
        }
        ArrayList<String> audienceUrls = new ArrayList<String>(2);
        audienceUrls.add(adaptor.getEntityId());
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)service.getAssertionAudiences())) {
            Set audiences = StringUtils.commaDelimitedListToSet((String)service.getAssertionAudiences());
            audienceUrls.addAll(audiences);
        }
        return this.newConditions(currentDateTime.minusSeconds(skewAllowance), currentDateTime.plusSeconds(skewAllowance), audienceUrls.toArray(ArrayUtils.EMPTY_STRING_ARRAY));
    }
}

