/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.time.Duration;
import org.apache.velocity.app.VelocityEngine;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.audit.AuditPrincipalIdProvider;
import org.apereo.cas.audit.AuditTrailRecordResolutionPlanConfigurer;
import org.apereo.cas.authentication.attribute.AttributeDefinitionStore;
import org.apereo.cas.authentication.principal.PersistentIdGenerator;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.logout.slo.SingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.logout.slo.SingleLogoutServiceLogoutUrlBuilderConfigurer;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.idp.metadata.locator.SamlIdPMetadataLocator;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.support.saml.web.idp.audit.SamlRequestAuditResourceResolver;
import org.apereo.cas.support.saml.web.idp.audit.SamlResponseAuditPrincipalIdProvider;
import org.apereo.cas.support.saml.web.idp.audit.SamlResponseAuditResourceResolver;
import org.apereo.cas.support.saml.web.idp.profile.artifact.CasSamlArtifactMap;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.assertion.SamlProfileSamlAssertionBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.attr.SamlProfileSamlAttributeStatementBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.authn.AuthnContextClassRefBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.authn.DefaultAuthnContextClassRefBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.authn.SamlProfileSamlAuthNStatementBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.conditions.SamlProfileSamlConditionsBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.DefaultSamlIdPObjectSigner;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlIdPObjectEncrypter;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlIdPObjectSigner;
import org.apereo.cas.support.saml.web.idp.profile.builders.nameid.SamlProfileSamlNameIdBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.SamlProfileSaml2ResponseBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.SamlProfileSamlResponseBuilderConfigurationContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.artifact.SamlProfileArtifactFaultResponseBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.artifact.SamlProfileArtifactResponseBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.query.SamlProfileAttributeQueryFaultResponseBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.query.SamlProfileAttributeQueryResponseBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.soap.SamlProfileSamlSoap11FaultResponseBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.soap.SamlProfileSamlSoap11ResponseBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.subject.SamlProfileSamlSubjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.slo.SamlIdPSingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.TicketFactoryExecutionPlanConfigurer;
import org.apereo.cas.ticket.artifact.DefaultSamlArtifactTicketFactory;
import org.apereo.cas.ticket.artifact.SamlArtifactTicketExpirationPolicyBuilder;
import org.apereo.cas.ticket.artifact.SamlArtifactTicketFactory;
import org.apereo.cas.ticket.query.DefaultSamlAttributeQueryTicketFactory;
import org.apereo.cas.ticket.query.SamlAttributeQueryTicketExpirationPolicyBuilder;
import org.apereo.cas.ticket.query.SamlAttributeQueryTicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.web.UrlValidator;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.inspektr.audit.spi.AuditActionResolver;
import org.apereo.inspektr.audit.spi.AuditResourceResolver;
import org.apereo.inspektr.audit.spi.support.DefaultAuditActionResolver;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.artifact.SAMLArtifactMap;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.ecp.Response;
import org.pac4j.core.context.session.SessionStore;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Configuration(value="SamlIdPConfiguration", proxyBeanMethods=false)
public class SamlIdPConfiguration {

    @Configuration(value="SamlIdPAuditConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SamlIdPAuditConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"samlResponseAuditPrincipalIdProvider"})
        public AuditPrincipalIdProvider samlResponseAuditPrincipalIdProvider() {
            return new SamlResponseAuditPrincipalIdProvider();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"casSamlIdPAuditTrailRecordResolutionPlanConfigurer"})
        public AuditTrailRecordResolutionPlanConfigurer casSamlIdPAuditTrailRecordResolutionPlanConfigurer() {
            return plan -> {
                plan.registerAuditResourceResolver("SAML2_RESPONSE_RESOURCE_RESOLVER", (AuditResourceResolver)new SamlResponseAuditResourceResolver());
                plan.registerAuditActionResolver("SAML2_RESPONSE_ACTION_RESOLVER", (AuditActionResolver)new DefaultAuditActionResolver("_CREATED", "_CREATED"));
                plan.registerAuditResourceResolver("SAML2_REQUEST_RESOURCE_RESOLVER", (AuditResourceResolver)new SamlRequestAuditResourceResolver());
                plan.registerAuditActionResolver("SAML2_REQUEST_ACTION_RESOLVER", (AuditActionResolver)new DefaultAuditActionResolver("_CREATED", "_CREATED"));
            };
        }
    }

    @Configuration(value="SamlIdPCryptoConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SamlIdPCryptoConfiguration {
        @ConditionalOnMissingBean(name={"samlObjectEncrypter"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlIdPObjectEncrypter samlObjectEncrypter(@Qualifier(value="samlIdPMetadataLocator") SamlIdPMetadataLocator samlIdPMetadataLocator, CasConfigurationProperties casProperties) {
            return new SamlIdPObjectEncrypter(casProperties.getAuthn().getSamlIdp(), samlIdPMetadataLocator);
        }

        @ConditionalOnMissingBean(name={"samlObjectSigner"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlIdPObjectSigner samlObjectSigner(CasConfigurationProperties casProperties, @Qualifier(value="casSamlIdPMetadataResolver") MetadataResolver casSamlIdPMetadataResolver, @Qualifier(value="samlIdPMetadataLocator") SamlIdPMetadataLocator samlIdPMetadataLocator) {
            return new DefaultSamlIdPObjectSigner(casSamlIdPMetadataResolver, casProperties, samlIdPMetadataLocator);
        }
    }

    @Configuration(value="SamlIdPLogoutConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SamlIdPLogoutConfiguration {
        @ConditionalOnMissingBean(name={"samlSingleLogoutServiceLogoutUrlBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SingleLogoutServiceLogoutUrlBuilder samlSingleLogoutServiceLogoutUrlBuilder(@Qualifier(value="defaultSamlRegisteredServiceCachingMetadataResolver") SamlRegisteredServiceCachingMetadataResolver defaultSamlRegisteredServiceCachingMetadataResolver, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="urlValidator") UrlValidator urlValidator) {
            return new SamlIdPSingleLogoutServiceLogoutUrlBuilder(servicesManager, defaultSamlRegisteredServiceCachingMetadataResolver, urlValidator);
        }

        @ConditionalOnMissingBean(name={"samlSingleLogoutServiceLogoutUrlBuilderConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SingleLogoutServiceLogoutUrlBuilderConfigurer samlSingleLogoutServiceLogoutUrlBuilderConfigurer(@Qualifier(value="samlSingleLogoutServiceLogoutUrlBuilder") SingleLogoutServiceLogoutUrlBuilder samlSingleLogoutServiceLogoutUrlBuilder) {
            return () -> samlSingleLogoutServiceLogoutUrlBuilder;
        }
    }

    @Configuration(value="SamlIdPTicketConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SamlIdPTicketConfiguration {
        @ConditionalOnMissingBean(name={"samlAttributeQueryTicketFactory"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlAttributeQueryTicketFactory samlAttributeQueryTicketFactory(@Qualifier(value="samlAttributeQueryTicketExpirationPolicy") ExpirationPolicyBuilder samlAttributeQueryTicketExpirationPolicy, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean, @Qualifier(value="samlIdPServiceFactory") ServiceFactory samlIdPServiceFactory) {
            return new DefaultSamlAttributeQueryTicketFactory(samlAttributeQueryTicketExpirationPolicy, samlIdPServiceFactory, openSamlConfigBean);
        }

        @ConditionalOnMissingBean(name={"samlArtifactTicketFactory"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlArtifactTicketFactory samlArtifactTicketFactory(@Qualifier(value="samlArtifactTicketExpirationPolicy") ExpirationPolicyBuilder samlArtifactTicketExpirationPolicy, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean, @Qualifier(value="samlIdPServiceFactory") ServiceFactory samlIdPServiceFactory) {
            return new DefaultSamlArtifactTicketFactory(samlArtifactTicketExpirationPolicy, openSamlConfigBean, samlIdPServiceFactory);
        }

        @Bean(initMethod="initialize", destroyMethod="destroy")
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SAMLArtifactMap samlArtifactMap(@Qualifier(value="defaultTicketFactory") TicketFactory ticketFactory, @Qualifier(value="samlArtifactTicketExpirationPolicy") ExpirationPolicyBuilder samlArtifactTicketExpirationPolicy, @Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="samlIdPDistributedSessionStore") SessionStore samlIdPDistributedSessionStore, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService) {
            CasSamlArtifactMap map = new CasSamlArtifactMap(ticketRegistry, ticketFactory, ticketGrantingTicketCookieGenerator, samlIdPDistributedSessionStore, centralAuthenticationService);
            ExpirationPolicy expirationPolicy = samlArtifactTicketExpirationPolicy.buildTicketExpirationPolicy();
            map.setArtifactLifetime(Duration.ofSeconds(expirationPolicy.getTimeToLive()));
            return map;
        }
    }

    @Configuration(value="SamlIdPTicketExpirationPolicyConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SamlIdPTicketExpirationPolicyConfiguration {
        @ConditionalOnMissingBean(name={"samlAttributeQueryTicketExpirationPolicy"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ExpirationPolicyBuilder samlAttributeQueryTicketExpirationPolicy(CasConfigurationProperties casProperties) {
            return new SamlAttributeQueryTicketExpirationPolicyBuilder(casProperties);
        }

        @ConditionalOnMissingBean(name={"samlArtifactTicketExpirationPolicy"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ExpirationPolicyBuilder samlArtifactTicketExpirationPolicy(CasConfigurationProperties casProperties) {
            return new SamlArtifactTicketExpirationPolicyBuilder(casProperties);
        }
    }

    @Configuration(value="SamlIdPTicketFactoryPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SamlIdPTicketFactoryPlanConfiguration {
        @ConditionalOnMissingBean(name={"samlAttributeQueryTicketFactoryConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public TicketFactoryExecutionPlanConfigurer samlAttributeQueryTicketFactoryConfigurer(@Qualifier(value="samlAttributeQueryTicketFactory") SamlAttributeQueryTicketFactory samlAttributeQueryTicketFactory) {
            return () -> samlAttributeQueryTicketFactory;
        }

        @ConditionalOnMissingBean(name={"samlArtifactTicketFactoryConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public TicketFactoryExecutionPlanConfigurer samlArtifactTicketFactoryConfigurer(@Qualifier(value="samlArtifactTicketFactory") SamlArtifactTicketFactory samlArtifactTicketFactory) {
            return () -> samlArtifactTicketFactory;
        }
    }

    @Configuration(value="SamlIdPProfileBuilderConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SamlIdPProfileBuilderConfiguration {
        @ConditionalOnMissingBean(name={"samlProfileSamlAttributeQueryFaultResponseBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlProfileObjectBuilder<org.opensaml.saml.saml2.core.Response> samlProfileSamlAttributeQueryFaultResponseBuilder(CasConfigurationProperties casProperties, @Qualifier(value="casSamlIdPMetadataResolver") MetadataResolver casSamlIdPMetadataResolver, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean, @Qualifier(value="samlObjectSigner") SamlIdPObjectSigner samlObjectSigner, @Qualifier(value="velocityEngineFactory") VelocityEngine velocityEngineFactory, @Qualifier(value="samlProfileSamlAssertionBuilder") SamlProfileObjectBuilder<Assertion> samlProfileSamlAssertionBuilder, @Qualifier(value="samlObjectEncrypter") SamlIdPObjectEncrypter samlObjectEncrypter, @Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="samlIdPDistributedSessionStore") SessionStore samlIdPDistributedSessionStore, @Qualifier(value="samlArtifactMap") SAMLArtifactMap samlArtifactMap, @Qualifier(value="defaultTicketFactory") TicketFactory ticketFactory, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService, @Qualifier(value="samlProfileSamlResponseBuilder") SamlProfileObjectBuilder<org.opensaml.saml.saml2.core.Response> samlProfileSamlResponseBuilder) {
            SamlProfileSamlResponseBuilderConfigurationContext context = SamlProfileSamlResponseBuilderConfigurationContext.builder().samlIdPMetadataResolver(casSamlIdPMetadataResolver).openSamlConfigBean(openSamlConfigBean).samlObjectSigner(samlObjectSigner).velocityEngineFactory(velocityEngineFactory).samlProfileSamlAssertionBuilder(samlProfileSamlAssertionBuilder).samlObjectEncrypter(samlObjectEncrypter).ticketGrantingTicketCookieGenerator(ticketGrantingTicketCookieGenerator).ticketRegistry(ticketRegistry).sessionStore(samlIdPDistributedSessionStore).samlArtifactMap(samlArtifactMap).centralAuthenticationService(centralAuthenticationService).casProperties(casProperties).samlSoapResponseBuilder(samlProfileSamlResponseBuilder).ticketFactory(ticketFactory).build();
            return new SamlProfileAttributeQueryFaultResponseBuilder(context);
        }

        @ConditionalOnMissingBean(name={"samlProfileSamlAttributeQueryResponseBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlProfileObjectBuilder<org.opensaml.saml.saml2.core.Response> samlProfileSamlAttributeQueryResponseBuilder(CasConfigurationProperties casProperties, @Qualifier(value="casSamlIdPMetadataResolver") MetadataResolver casSamlIdPMetadataResolver, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean, @Qualifier(value="samlObjectSigner") SamlIdPObjectSigner samlObjectSigner, @Qualifier(value="velocityEngineFactory") VelocityEngine velocityEngineFactory, @Qualifier(value="samlProfileSamlAssertionBuilder") SamlProfileObjectBuilder<Assertion> samlProfileSamlAssertionBuilder, @Qualifier(value="samlObjectEncrypter") SamlIdPObjectEncrypter samlObjectEncrypter, @Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="samlIdPDistributedSessionStore") SessionStore samlIdPDistributedSessionStore, @Qualifier(value="samlArtifactMap") SAMLArtifactMap samlArtifactMap, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService, @Qualifier(value="defaultTicketFactory") TicketFactory ticketFactory, @Qualifier(value="samlProfileSamlResponseBuilder") SamlProfileObjectBuilder<org.opensaml.saml.saml2.core.Response> samlProfileSamlResponseBuilder) {
            SamlProfileSamlResponseBuilderConfigurationContext context = SamlProfileSamlResponseBuilderConfigurationContext.builder().samlIdPMetadataResolver(casSamlIdPMetadataResolver).openSamlConfigBean(openSamlConfigBean).samlObjectSigner(samlObjectSigner).velocityEngineFactory(velocityEngineFactory).samlProfileSamlAssertionBuilder(samlProfileSamlAssertionBuilder).samlObjectEncrypter(samlObjectEncrypter).ticketGrantingTicketCookieGenerator(ticketGrantingTicketCookieGenerator).ticketRegistry(ticketRegistry).sessionStore(samlIdPDistributedSessionStore).samlArtifactMap(samlArtifactMap).centralAuthenticationService(centralAuthenticationService).casProperties(casProperties).samlSoapResponseBuilder(samlProfileSamlResponseBuilder).ticketFactory(ticketFactory).build();
            return new SamlProfileAttributeQueryResponseBuilder(context);
        }

        @ConditionalOnMissingBean(name={"samlProfileSamlSubjectBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlProfileObjectBuilder<Subject> samlProfileSamlSubjectBuilder(CasConfigurationProperties casProperties, @Qualifier(value="samlProfileSamlNameIdBuilder") SamlProfileObjectBuilder<SAMLObject> samlProfileSamlNameIdBuilder, @Qualifier(value="samlObjectEncrypter") SamlIdPObjectEncrypter samlObjectEncrypter, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean) {
            return new SamlProfileSamlSubjectBuilder(openSamlConfigBean, samlProfileSamlNameIdBuilder, casProperties, samlObjectEncrypter);
        }

        @ConditionalOnMissingBean(name={"samlProfileSamlSoap11FaultResponseBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlProfileObjectBuilder<Response> samlProfileSamlSoap11FaultResponseBuilder(CasConfigurationProperties casProperties, @Qualifier(value="casSamlIdPMetadataResolver") MetadataResolver casSamlIdPMetadataResolver, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean, @Qualifier(value="samlObjectSigner") SamlIdPObjectSigner samlObjectSigner, @Qualifier(value="velocityEngineFactory") VelocityEngine velocityEngineFactory, @Qualifier(value="samlProfileSamlAssertionBuilder") SamlProfileObjectBuilder<Assertion> samlProfileSamlAssertionBuilder, @Qualifier(value="samlObjectEncrypter") SamlIdPObjectEncrypter samlObjectEncrypter, @Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="samlIdPDistributedSessionStore") SessionStore samlIdPDistributedSessionStore, @Qualifier(value="samlArtifactMap") SAMLArtifactMap samlArtifactMap, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService, @Qualifier(value="defaultTicketFactory") TicketFactory ticketFactory, @Qualifier(value="samlProfileSamlResponseBuilder") SamlProfileObjectBuilder<org.opensaml.saml.saml2.core.Response> samlProfileSamlResponseBuilder) {
            SamlProfileSamlResponseBuilderConfigurationContext context = SamlProfileSamlResponseBuilderConfigurationContext.builder().samlIdPMetadataResolver(casSamlIdPMetadataResolver).openSamlConfigBean(openSamlConfigBean).samlObjectSigner(samlObjectSigner).velocityEngineFactory(velocityEngineFactory).samlProfileSamlAssertionBuilder(samlProfileSamlAssertionBuilder).samlObjectEncrypter(samlObjectEncrypter).ticketGrantingTicketCookieGenerator(ticketGrantingTicketCookieGenerator).ticketRegistry(ticketRegistry).sessionStore(samlIdPDistributedSessionStore).samlArtifactMap(samlArtifactMap).centralAuthenticationService(centralAuthenticationService).casProperties(casProperties).samlSoapResponseBuilder(samlProfileSamlResponseBuilder).ticketFactory(ticketFactory).build();
            return new SamlProfileSamlSoap11FaultResponseBuilder(context);
        }

        @ConditionalOnMissingBean(name={"samlProfileSamlSoap11ResponseBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlProfileObjectBuilder<Response> samlProfileSamlSoap11ResponseBuilder(CasConfigurationProperties casProperties, @Qualifier(value="casSamlIdPMetadataResolver") MetadataResolver casSamlIdPMetadataResolver, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean, @Qualifier(value="samlObjectSigner") SamlIdPObjectSigner samlObjectSigner, @Qualifier(value="velocityEngineFactory") VelocityEngine velocityEngineFactory, @Qualifier(value="samlProfileSamlAssertionBuilder") SamlProfileObjectBuilder<Assertion> samlProfileSamlAssertionBuilder, @Qualifier(value="samlObjectEncrypter") SamlIdPObjectEncrypter samlObjectEncrypter, @Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="samlIdPDistributedSessionStore") SessionStore samlIdPDistributedSessionStore, @Qualifier(value="samlArtifactMap") SAMLArtifactMap samlArtifactMap, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService, @Qualifier(value="defaultTicketFactory") TicketFactory ticketFactory, @Qualifier(value="samlProfileSamlResponseBuilder") SamlProfileObjectBuilder<org.opensaml.saml.saml2.core.Response> samlProfileSamlResponseBuilder) {
            SamlProfileSamlResponseBuilderConfigurationContext context = SamlProfileSamlResponseBuilderConfigurationContext.builder().samlIdPMetadataResolver(casSamlIdPMetadataResolver).openSamlConfigBean(openSamlConfigBean).samlObjectSigner(samlObjectSigner).velocityEngineFactory(velocityEngineFactory).samlProfileSamlAssertionBuilder(samlProfileSamlAssertionBuilder).samlObjectEncrypter(samlObjectEncrypter).ticketGrantingTicketCookieGenerator(ticketGrantingTicketCookieGenerator).ticketRegistry(ticketRegistry).sessionStore(samlIdPDistributedSessionStore).samlArtifactMap(samlArtifactMap).centralAuthenticationService(centralAuthenticationService).casProperties(casProperties).samlSoapResponseBuilder(samlProfileSamlResponseBuilder).ticketFactory(ticketFactory).build();
            return new SamlProfileSamlSoap11ResponseBuilder(context);
        }

        @ConditionalOnMissingBean(name={"samlProfileSamlArtifactFaultResponseBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlProfileObjectBuilder<org.opensaml.saml.saml2.core.Response> samlProfileSamlArtifactFaultResponseBuilder(CasConfigurationProperties casProperties, @Qualifier(value="casSamlIdPMetadataResolver") MetadataResolver casSamlIdPMetadataResolver, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean, @Qualifier(value="samlObjectSigner") SamlIdPObjectSigner samlObjectSigner, @Qualifier(value="velocityEngineFactory") VelocityEngine velocityEngineFactory, @Qualifier(value="samlProfileSamlAssertionBuilder") SamlProfileObjectBuilder<Assertion> samlProfileSamlAssertionBuilder, @Qualifier(value="samlObjectEncrypter") SamlIdPObjectEncrypter samlObjectEncrypter, @Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="samlIdPDistributedSessionStore") SessionStore samlIdPDistributedSessionStore, @Qualifier(value="samlArtifactMap") SAMLArtifactMap samlArtifactMap, @Qualifier(value="defaultTicketFactory") TicketFactory ticketFactory, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService, @Qualifier(value="samlProfileSamlResponseBuilder") SamlProfileObjectBuilder<org.opensaml.saml.saml2.core.Response> samlProfileSamlResponseBuilder) {
            SamlProfileSamlResponseBuilderConfigurationContext context = SamlProfileSamlResponseBuilderConfigurationContext.builder().samlIdPMetadataResolver(casSamlIdPMetadataResolver).openSamlConfigBean(openSamlConfigBean).samlObjectSigner(samlObjectSigner).velocityEngineFactory(velocityEngineFactory).samlProfileSamlAssertionBuilder(samlProfileSamlAssertionBuilder).samlObjectEncrypter(samlObjectEncrypter).ticketGrantingTicketCookieGenerator(ticketGrantingTicketCookieGenerator).ticketRegistry(ticketRegistry).sessionStore(samlIdPDistributedSessionStore).samlArtifactMap(samlArtifactMap).centralAuthenticationService(centralAuthenticationService).casProperties(casProperties).samlSoapResponseBuilder(samlProfileSamlResponseBuilder).ticketFactory(ticketFactory).build();
            return new SamlProfileArtifactFaultResponseBuilder(context);
        }

        @ConditionalOnMissingBean(name={"samlProfileSamlArtifactResponseBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlProfileObjectBuilder<org.opensaml.saml.saml2.core.Response> samlProfileSamlArtifactResponseBuilder(CasConfigurationProperties casProperties, @Qualifier(value="casSamlIdPMetadataResolver") MetadataResolver casSamlIdPMetadataResolver, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean, @Qualifier(value="samlObjectSigner") SamlIdPObjectSigner samlObjectSigner, @Qualifier(value="velocityEngineFactory") VelocityEngine velocityEngineFactory, @Qualifier(value="samlProfileSamlAssertionBuilder") SamlProfileObjectBuilder<Assertion> samlProfileSamlAssertionBuilder, @Qualifier(value="samlObjectEncrypter") SamlIdPObjectEncrypter samlObjectEncrypter, @Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="samlIdPDistributedSessionStore") SessionStore samlIdPDistributedSessionStore, @Qualifier(value="samlArtifactMap") SAMLArtifactMap samlArtifactMap, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService, @Qualifier(value="defaultTicketFactory") TicketFactory ticketFactory, @Qualifier(value="samlProfileSamlResponseBuilder") SamlProfileObjectBuilder<org.opensaml.saml.saml2.core.Response> samlProfileSamlResponseBuilder) {
            SamlProfileSamlResponseBuilderConfigurationContext context = SamlProfileSamlResponseBuilderConfigurationContext.builder().samlIdPMetadataResolver(casSamlIdPMetadataResolver).openSamlConfigBean(openSamlConfigBean).samlObjectSigner(samlObjectSigner).velocityEngineFactory(velocityEngineFactory).samlProfileSamlAssertionBuilder(samlProfileSamlAssertionBuilder).samlObjectEncrypter(samlObjectEncrypter).ticketGrantingTicketCookieGenerator(ticketGrantingTicketCookieGenerator).ticketRegistry(ticketRegistry).sessionStore(samlIdPDistributedSessionStore).samlArtifactMap(samlArtifactMap).centralAuthenticationService(centralAuthenticationService).casProperties(casProperties).samlSoapResponseBuilder(samlProfileSamlResponseBuilder).ticketFactory(ticketFactory).build();
            return new SamlProfileArtifactResponseBuilder(context);
        }

        @ConditionalOnMissingBean(name={"samlProfileSamlNameIdBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlProfileObjectBuilder<SAMLObject> samlProfileSamlNameIdBuilder(@Qualifier(value="casSamlIdPMetadataResolver") MetadataResolver casSamlIdPMetadataResolver, @Qualifier(value="shibbolethCompatiblePersistentIdGenerator") PersistentIdGenerator shibbolethCompatiblePersistentIdGenerator, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean, @Qualifier(value="samlObjectEncrypter") SamlIdPObjectEncrypter samlObjectEncrypter) {
            return new SamlProfileSamlNameIdBuilder(openSamlConfigBean, shibbolethCompatiblePersistentIdGenerator, casSamlIdPMetadataResolver, samlObjectEncrypter);
        }

        @ConditionalOnMissingBean(name={"samlProfileSamlConditionsBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlProfileObjectBuilder<Conditions> samlProfileSamlConditionsBuilder(CasConfigurationProperties casProperties, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean) {
            return new SamlProfileSamlConditionsBuilder(openSamlConfigBean, casProperties);
        }

        @ConditionalOnMissingBean(name={"defaultAuthnContextClassRefBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthnContextClassRefBuilder defaultAuthnContextClassRefBuilder(CasConfigurationProperties casProperties) {
            return new DefaultAuthnContextClassRefBuilder(casProperties);
        }

        @ConditionalOnMissingBean(name={"samlProfileSamlAssertionBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlProfileObjectBuilder<Assertion> samlProfileSamlAssertionBuilder(@Qualifier(value="samlProfileSamlAuthNStatementBuilder") SamlProfileObjectBuilder<AuthnStatement> samlProfileSamlAuthNStatementBuilder, @Qualifier(value="samlProfileSamlAttributeStatementBuilder") SamlProfileObjectBuilder<AttributeStatement> samlProfileSamlAttributeStatementBuilder, @Qualifier(value="samlProfileSamlSubjectBuilder") SamlProfileObjectBuilder<Subject> samlProfileSamlSubjectBuilder, @Qualifier(value="samlProfileSamlConditionsBuilder") SamlProfileObjectBuilder<Conditions> samlProfileSamlConditionsBuilder, @Qualifier(value="samlObjectSigner") SamlIdPObjectSigner samlObjectSigner, @Qualifier(value="casSamlIdPMetadataResolver") MetadataResolver casSamlIdPMetadataResolver, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean) {
            return new SamlProfileSamlAssertionBuilder(openSamlConfigBean, samlProfileSamlAuthNStatementBuilder, samlProfileSamlAttributeStatementBuilder, samlProfileSamlSubjectBuilder, samlProfileSamlConditionsBuilder, samlObjectSigner, casSamlIdPMetadataResolver);
        }

        @ConditionalOnMissingBean(name={"samlProfileSamlAuthNStatementBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlProfileObjectBuilder<AuthnStatement> samlProfileSamlAuthNStatementBuilder(CasConfigurationProperties casProperties, @Qualifier(value="defaultAuthnContextClassRefBuilder") AuthnContextClassRefBuilder defaultAuthnContextClassRefBuilder, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean) {
            return new SamlProfileSamlAuthNStatementBuilder(openSamlConfigBean, defaultAuthnContextClassRefBuilder, casProperties);
        }

        @ConditionalOnMissingBean(name={"samlProfileSamlAttributeStatementBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlProfileObjectBuilder<AttributeStatement> samlProfileSamlAttributeStatementBuilder(CasConfigurationProperties casProperties, @Qualifier(value="samlObjectEncrypter") SamlIdPObjectEncrypter samlObjectEncrypter, @Qualifier(value="samlProfileSamlNameIdBuilder") SamlProfileObjectBuilder<SAMLObject> samlProfileSamlNameIdBuilder, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean, @Qualifier(value="samlIdPServiceFactory") ServiceFactory samlIdPServiceFactory, @Qualifier(value="attributeDefinitionStore") AttributeDefinitionStore attributeDefinitionStore, @Qualifier(value="casSamlIdPMetadataResolver") MetadataResolver casSamlIdPMetadataResolver) {
            return new SamlProfileSamlAttributeStatementBuilder(openSamlConfigBean, casProperties.getAuthn().getSamlIdp(), samlObjectEncrypter, attributeDefinitionStore, samlIdPServiceFactory, samlProfileSamlNameIdBuilder, casSamlIdPMetadataResolver);
        }

        @ConditionalOnMissingBean(name={"samlProfileSamlResponseBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlProfileObjectBuilder<org.opensaml.saml.saml2.core.Response> samlProfileSamlResponseBuilder(CasConfigurationProperties casProperties, @Qualifier(value="casSamlIdPMetadataResolver") MetadataResolver casSamlIdPMetadataResolver, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean, @Qualifier(value="samlObjectSigner") SamlIdPObjectSigner samlObjectSigner, @Qualifier(value="velocityEngineFactory") VelocityEngine velocityEngineFactory, @Qualifier(value="samlProfileSamlAssertionBuilder") SamlProfileObjectBuilder<Assertion> samlProfileSamlAssertionBuilder, @Qualifier(value="samlObjectEncrypter") SamlIdPObjectEncrypter samlObjectEncrypter, @Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="samlIdPDistributedSessionStore") SessionStore samlIdPDistributedSessionStore, @Qualifier(value="defaultTicketFactory") TicketFactory ticketFactory, @Qualifier(value="samlArtifactMap") SAMLArtifactMap samlArtifactMap, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService) {
            SamlProfileSamlResponseBuilderConfigurationContext context = SamlProfileSamlResponseBuilderConfigurationContext.builder().samlIdPMetadataResolver(casSamlIdPMetadataResolver).openSamlConfigBean(openSamlConfigBean).samlObjectSigner(samlObjectSigner).velocityEngineFactory(velocityEngineFactory).samlProfileSamlAssertionBuilder(samlProfileSamlAssertionBuilder).samlObjectEncrypter(samlObjectEncrypter).ticketGrantingTicketCookieGenerator(ticketGrantingTicketCookieGenerator).ticketRegistry(ticketRegistry).sessionStore(samlIdPDistributedSessionStore).samlArtifactMap(samlArtifactMap).centralAuthenticationService(centralAuthenticationService).casProperties(casProperties).ticketFactory(ticketFactory).build();
            return new SamlProfileSaml2ResponseBuilder(context);
        }
    }
}

