/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.spnego.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReverseDNSRunnable
implements Runnable {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ReverseDNSRunnable.class);
    private final String ipAddress;
    private String hostName;

    public ReverseDNSRunnable(String ipAddress) {
        this.ipAddress = ipAddress;
        this.hostName = ipAddress;
    }

    @Override
    public void run() {
        try {
            LOGGER.debug("Attempting to resolve [{}]", (Object)this.ipAddress);
            InetAddress address = InetAddress.getByName(this.ipAddress);
            this.set(address.getCanonicalHostName());
        }
        catch (UnknownHostException e) {
            LOGGER.debug("Unable to identify the canonical hostname for ip address.", (Throwable)e);
        }
    }

    public synchronized void set(String hostName) {
        LOGGER.trace("ReverseDNS -- Found hostName: [{}].", (Object)hostName);
        this.hostName = hostName;
    }

    @Generated
    public String toString() {
        return "ReverseDNSRunnable(ipAddress=" + this.ipAddress + ", hostName=" + this.hostName + ")";
    }

    @Generated
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Generated
    public String getHostName() {
        return this.hostName;
    }
}

