/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ws.idp;

import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.util.CollectionUtils;

public enum WSFederationClaims {
    EMAIL_ADDRESS_2005("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress"),
    EMAIL_ADDRESS("http://schemas.xmlsoap.org/claims/EmailAddress"),
    GIVEN_NAME("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/givenname"),
    NAME("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/name"),
    USER_PRINCIPAL_NAME_2005("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/upn"),
    USER_PRINCIPAL_NAME("http://schemas.xmlsoap.org/claims/UPN"),
    COMMON_NAME("http://schemas.xmlsoap.org/claims/CommonName"),
    GROUP("http://schemas.xmlsoap.org/claims/Group"),
    MS_ROLE("http://schemas.microsoft.com/ws/2008/06/identity/claims/role"),
    ROLE("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/role"),
    SURNAME("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/surname"),
    PRIVATE_ID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier"),
    NAME_IDENTIFIER("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/nameidentifier"),
    AUTHENTICATION_METHOD("http://schemas.microsoft.com/ws/2008/06/identity/claims/authenticationmethod"),
    DENY_ONLY_GROUP_SID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/denyonlysid"),
    DENY_ONLY_PRIMARY_SID("http://schemas.microsoft.com/ws/2008/06/identity/claims/denyonlyprimarysid"),
    DENY_ONLY_PRIMARY_GROUP_SID("http://schemas.microsoft.com/ws/2008/06/identity/claims/denyonlyprimarygroupsid"),
    GROUP_SID("http://schemas.microsoft.com/ws/2008/06/identity/claims/groupsid"),
    PRIMARY_GROUP_SID("http://schemas.microsoft.com/ws/2008/06/identity/claims/primarygroupsid"),
    PRIMARY_SID("http://schemas.microsoft.com/ws/2008/06/identity/claims/primarysid"),
    WINDOWS_ACCOUNT_NAME("http://schemas.microsoft.com/ws/2008/06/identity/claims/windowsaccountname"),
    PUID("http://schemas.xmlsoap.org/claims/PUID");

    public static final List<WSFederationClaims> ALL_CLAIMS;
    private final String uri;

    private WSFederationClaims(String str) {
        this.uri = str;
    }

    public static boolean contains(String claimName) {
        return EnumUtils.isValidEnum(WSFederationClaims.class, (String)claimName);
    }

    public static boolean containsUri(String claimUri) {
        return Arrays.stream(WSFederationClaims.values()).anyMatch(c -> c.getUri().equalsIgnoreCase(claimUri));
    }

    public String getClaim() {
        int idx = StringUtils.lastIndexOf((CharSequence)this.uri, (int)47);
        return this.uri.substring(idx + 1);
    }

    @Generated
    public String getUri() {
        return this.uri;
    }

    static {
        ALL_CLAIMS = CollectionUtils.wrapList((Object[])new WSFederationClaims[]{EMAIL_ADDRESS_2005, EMAIL_ADDRESS, GIVEN_NAME, NAME, USER_PRINCIPAL_NAME_2005, USER_PRINCIPAL_NAME, COMMON_NAME, GROUP, ROLE, MS_ROLE, SURNAME, PRIVATE_ID, NAME_IDENTIFIER, AUTHENTICATION_METHOD, DENY_ONLY_GROUP_SID, DENY_ONLY_PRIMARY_SID, DENY_ONLY_PRIMARY_GROUP_SID, GROUP_SID, PRIMARY_GROUP_SID, PRIMARY_SID, WINDOWS_ACCOUNT_NAME, PUID});
    }
}

