/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ws.idp.services;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import lombok.Generated;
import org.apereo.cas.services.AbstractRegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.scripting.ExecutableCompiledGroovyScript;
import org.apereo.cas.util.scripting.ScriptingUtils;
import org.apereo.cas.util.spring.ApplicationContextProvider;
import org.apereo.cas.ws.idp.WSFederationClaims;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSFederationClaimsReleasePolicy
extends AbstractRegisteredServiceAttributeReleasePolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WSFederationClaimsReleasePolicy.class);
    private static final long serialVersionUID = -2814928645221579489L;
    private Map<String, String> allowedAttributes = new LinkedHashMap<String, String>();

    public WSFederationClaimsReleasePolicy(Map<String, String> allowedAttributes) {
        this.setAllowedAttributes(allowedAttributes);
    }

    public Map<String, List<Object>> getAttributesInternal(RegisteredServiceAttributeReleasePolicyContext context, Map<String, List<Object>> attrs) {
        TreeMap<String, List<Object>> resolvedAttributes = new TreeMap<String, List<Object>>(String.CASE_INSENSITIVE_ORDER);
        resolvedAttributes.putAll(attrs);
        HashMap attributesToRelease = Maps.newHashMapWithExpectedSize((int)resolvedAttributes.size());
        this.getAllowedAttributes().entrySet().stream().filter(entry -> WSFederationClaims.contains(((String)entry.getKey()).toUpperCase())).forEach(entry -> {
            String claimName = (String)entry.getKey();
            List attributeValue = (List)resolvedAttributes.get(entry.getValue());
            WSFederationClaims claim = WSFederationClaims.valueOf(claimName.toUpperCase());
            if (resolvedAttributes.containsKey(claim.getUri())) {
                attributesToRelease.put(claim.getUri(), (List)resolvedAttributes.get(claim.getUri()));
            } else {
                LOGGER.trace("Evaluating claim [{}] mapped to attribute value [{}]", (Object)claim.getUri(), (Object)attributeValue);
                WSFederationClaimsReleasePolicy.mapSingleAttributeDefinition(claim.getUri(), (String)entry.getValue(), attributeValue, resolvedAttributes, attributesToRelease);
            }
        });
        return attributesToRelease;
    }

    private static void mapSimpleSingleAttributeDefinition(String attributeName, String mappedAttributeName, List<Object> attributeValue, Map<String, List<Object>> attributesToRelease) {
        if (attributeValue != null) {
            LOGGER.debug("Found attribute [{}] in the list of allowed attributes, mapped to the name [{}]", (Object)attributeName, (Object)mappedAttributeName);
            ArrayList values = (ArrayList)CollectionUtils.toCollection(attributeValue, ArrayList.class);
            attributesToRelease.put(attributeName, values);
        } else {
            LOGGER.warn("Could not find value for mapped attribute [{}] that is based off of [{}] in the allowed attributes list. Ensure the original attribute [{}] is retrieved and contains at least a single value. Attribute [{}] will and can not be released without the presence of a value.", new Object[]{mappedAttributeName, attributeName, attributeName, mappedAttributeName});
        }
    }

    private static void mapSingleAttributeDefinition(String attributeName, String mappedAttributeName, List<Object> attributeValue, Map<String, List<Object>> resolvedAttributes, Map<String, List<Object>> attributesToRelease) {
        Matcher matcherInline = ScriptingUtils.getMatcherForInlineGroovyScript((String)mappedAttributeName);
        Matcher matcherFile = ScriptingUtils.getMatcherForExternalGroovyScript((String)mappedAttributeName);
        if (matcherInline.find()) {
            String inlineGroovy = matcherInline.group(1);
            WSFederationClaimsReleasePolicy.fetchAttributeValueAsInlineGroovyScript(attributeName, resolvedAttributes, attributesToRelease, inlineGroovy);
        } else if (matcherFile.find()) {
            String file = matcherFile.group();
            WSFederationClaimsReleasePolicy.fetchAttributeValueFromExternalGroovyScript(attributeName, resolvedAttributes, attributesToRelease, file);
        } else {
            WSFederationClaimsReleasePolicy.mapSimpleSingleAttributeDefinition(attributeName, mappedAttributeName, attributeValue, attributesToRelease);
        }
    }

    private static void fetchAttributeValueFromExternalGroovyScript(String attributeName, Map<String, List<Object>> resolvedAttributes, Map<String, List<Object>> attributesToRelease, String file) {
        ApplicationContextProvider.getScriptResourceCacheManager().ifPresentOrElse(cacheMgr -> {
            ExecutableCompiledGroovyScript script = cacheMgr.resolveScriptableResource(file, new String[]{attributeName, file});
            if (script != null) {
                WSFederationClaimsReleasePolicy.fetchAttributeValueFromScript(script, attributeName, resolvedAttributes, attributesToRelease);
            }
        }, () -> {
            throw new RuntimeException("No groovy script cache manager is available to execute attribute mappings");
        });
    }

    private static void fetchAttributeValueAsInlineGroovyScript(String attributeName, Map<String, List<Object>> resolvedAttributes, Map<String, List<Object>> attributesToRelease, String inlineGroovy) {
        ApplicationContextProvider.getScriptResourceCacheManager().ifPresentOrElse(cacheMgr -> {
            ExecutableCompiledGroovyScript script = cacheMgr.resolveScriptableResource(inlineGroovy, new String[]{attributeName, inlineGroovy});
            WSFederationClaimsReleasePolicy.fetchAttributeValueFromScript(script, attributeName, resolvedAttributes, attributesToRelease);
        }, () -> {
            throw new RuntimeException("No groovy script cache manager is available to execute attribute mappings");
        });
    }

    private static void fetchAttributeValueFromScript(ExecutableCompiledGroovyScript script, String attributeName, Map<String, List<Object>> resolvedAttributes, Map<String, List<Object>> attributesToRelease) {
        Map args = CollectionUtils.wrap((String)"attributes", resolvedAttributes, (String)"logger", (Object)LOGGER);
        script.setBinding(args);
        Object result = script.execute(args.values().toArray(), Object.class);
        if (result != null) {
            LOGGER.debug("Mapped attribute [{}] to [{}] from script", (Object)attributeName, result);
            attributesToRelease.put(attributeName, CollectionUtils.wrapList((Object[])new Object[]{result}));
        } else {
            LOGGER.warn("Groovy-scripted attribute returned no value for [{}]", (Object)attributeName);
        }
    }

    public List<String> determineRequestedAttributeDefinitions(RegisteredServiceAttributeReleasePolicyContext context) {
        return new ArrayList<String>(this.getAllowedAttributes().keySet());
    }

    @Generated
    public Map<String, String> getAllowedAttributes() {
        return this.allowedAttributes;
    }

    @Generated
    public void setAllowedAttributes(Map<String, String> allowedAttributes) {
        this.allowedAttributes = allowedAttributes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WSFederationClaimsReleasePolicy)) {
            return false;
        }
        WSFederationClaimsReleasePolicy other = (WSFederationClaimsReleasePolicy)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, String> this$allowedAttributes = this.allowedAttributes;
        Map<String, String> other$allowedAttributes = other.allowedAttributes;
        return !(this$allowedAttributes == null ? other$allowedAttributes != null : !((Object)this$allowedAttributes).equals(other$allowedAttributes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WSFederationClaimsReleasePolicy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, String> $allowedAttributes = this.allowedAttributes;
        result = result * 59 + ($allowedAttributes == null ? 43 : ((Object)$allowedAttributes).hashCode());
        return result;
    }

    @Generated
    public WSFederationClaimsReleasePolicy() {
    }
}

