/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ws.idp.authentication;

import java.util.Optional;
import lombok.Generated;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apereo.cas.authentication.BaseAuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.ServicesManager;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSFederationAuthenticationServiceSelectionStrategy
extends BaseAuthenticationServiceSelectionStrategy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WSFederationAuthenticationServiceSelectionStrategy.class);
    private static final long serialVersionUID = 8035218407906419228L;

    public WSFederationAuthenticationServiceSelectionStrategy(ServicesManager servicesManager, ServiceFactory<WebApplicationService> webApplicationServiceFactory) {
        super(servicesManager, webApplicationServiceFactory);
    }

    private static Optional<NameValuePair> getRealmAsParameter(Service service) {
        URIBuilder builder = new URIBuilder(service.getId());
        return builder.getQueryParams().stream().filter(p -> p.getName().equals("wtrealm")).findFirst();
    }

    private static Optional<NameValuePair> getReplyAsParameter(Service service) {
        return Optional.ofNullable(service).map(Unchecked.function(svc -> {
            URIBuilder builder = new URIBuilder(svc.getId());
            return builder.getQueryParams().stream().filter(p -> p.getName().equals("wreply")).findFirst().orElse(null);
        }));
    }

    public Service resolveServiceFrom(Service service) {
        Optional<NameValuePair> replyParamRes = WSFederationAuthenticationServiceSelectionStrategy.getReplyAsParameter(service);
        if (replyParamRes.isPresent()) {
            String serviceReply = replyParamRes.get().getValue();
            LOGGER.trace("Located service id [{}] from service authentication request at [{}]", (Object)serviceReply, (Object)service.getId());
            return this.createService(serviceReply, service);
        }
        LOGGER.trace("Resolved final service as [{}]", (Object)service);
        return service;
    }

    public boolean supports(Service service) {
        if (service == null) {
            LOGGER.trace("Provided service is undefined");
            return false;
        }
        LOGGER.trace("Evaluating service requested identified as [{}]", (Object)service.getId());
        Optional<NameValuePair> realmAsParameter = WSFederationAuthenticationServiceSelectionStrategy.getRealmAsParameter(service);
        if (realmAsParameter.isEmpty()) {
            LOGGER.trace("Parameter [{}] is undefined in the request", (Object)"wtrealm");
            return false;
        }
        return WSFederationAuthenticationServiceSelectionStrategy.getReplyAsParameter(service).isPresent();
    }
}

