/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ws.idp.metadata;

import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.wss4j.common.util.DOM2Writer;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.ws.idp.metadata.WSFederationMetadataWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Controller(value="WSFederationMetadataController")
public class WSFederationMetadataController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WSFederationMetadataController.class);
    private final CasConfigurationProperties casProperties;

    @GetMapping(path={"/ws/idpmetadata"})
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            Document metadata = WSFederationMetadataWriter.produceMetadataDocument(this.casProperties);
            out.write(DOM2Writer.nodeToString((Node)metadata));
        }
        catch (Exception ex) {
            LoggingUtils.error((Logger)LOGGER, (String)"Failed to get metadata document", (Throwable)ex);
            response.sendError(500);
        }
    }

    @Generated
    public WSFederationMetadataController(CasConfigurationProperties casProperties) {
        this.casProperties = casProperties;
    }
}

