/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ws.idp.web;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apereo.cas.authentication.adaptive.UnauthorizedAuthenticationException;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.ws.idp.services.WSFederationRegisteredService;
import org.apereo.cas.ws.idp.web.BaseWSFederationRequestController;
import org.apereo.cas.ws.idp.web.WSFederationRequest;
import org.apereo.cas.ws.idp.web.WSFederationRequestConfigurationContext;
import org.jasig.cas.client.authentication.DefaultAuthenticationRedirectStrategy;
import org.jasig.cas.client.util.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;

public class WSFederationValidateRequestController
extends BaseWSFederationRequestController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WSFederationValidateRequestController.class);

    public WSFederationValidateRequestController(WSFederationRequestConfigurationContext ctx) {
        super(ctx);
    }

    @GetMapping(path={"/ws/idp/federation"})
    public void handleFederationRequest(HttpServletResponse response, HttpServletRequest request) throws Exception {
        WSFederationRequest fedRequest = WSFederationRequest.of(request);
        String wa = fedRequest.getWa();
        if (StringUtils.isBlank((CharSequence)wa)) {
            throw new UnauthorizedAuthenticationException("Unable to determine the [WA] parameter", new HashMap(0));
        }
        switch (wa.toLowerCase()) {
            case "wsignout1.0": 
            case "wsignoutcleanup1.0": {
                this.handleLogoutRequest(fedRequest, request, response);
                break;
            }
            case "wsignin1.0": {
                this.handleInitialAuthenticationRequest(fedRequest, response, request);
                break;
            }
            default: {
                throw new UnauthorizedAuthenticationException("The authentication request is not recognized", new HashMap(0));
            }
        }
    }

    private void handleLogoutRequest(WSFederationRequest fedRequest, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String logoutUrl = (String)FunctionUtils.doIf((boolean)StringUtils.isNotBlank((CharSequence)fedRequest.getWreply()), () -> {
            WebApplicationService service = this.createService(fedRequest);
            WSFederationRegisteredService registeredService = this.getWsFederationRegisteredService((Service)service);
            LOGGER.debug("Invoking logout operation for request [{}], redirecting next to [{}] matched against [{}]", new Object[]{fedRequest, fedRequest.getWreply(), registeredService});
            String logoutParam = this.getConfigContext().getCasProperties().getLogout().getRedirectParameter();
            return this.getConfigContext().getCasProperties().getServer().getLogoutUrl().concat("?").concat(logoutParam).concat("=").concat(service.getId());
        }, () -> this.getConfigContext().getCasProperties().getServer().getLogoutUrl()).get();
        DefaultAuthenticationRedirectStrategy authenticationRedirectStrategy = new DefaultAuthenticationRedirectStrategy();
        authenticationRedirectStrategy.redirect(request, response, logoutUrl);
    }

    private void handleInitialAuthenticationRequest(WSFederationRequest fedRequest, HttpServletResponse response, HttpServletRequest request) throws Exception {
        WebApplicationService targetService = this.createService(fedRequest);
        WSFederationRegisteredService registeredService = this.findAndValidateFederationRequestForRegisteredService((Service)targetService, fedRequest);
        LOGGER.debug("Redirecting to identity provider for initial authentication [{}]", (Object)fedRequest);
        this.redirectToIdentityProvider(fedRequest, response, request, targetService, registeredService);
    }

    private WebApplicationService createService(WSFederationRequest fedRequest) {
        WebApplicationService targetService = (WebApplicationService)this.getConfigContext().getWebApplicationServiceFactory().createService(fedRequest.getWreply());
        targetService.getAttributes().put("wreply", CollectionUtils.wrapList((Object[])new Object[]{fedRequest.getWreply()}));
        targetService.getAttributes().put("wtrealm", CollectionUtils.wrapList((Object[])new Object[]{fedRequest.getWtrealm()}));
        targetService.getAttributes().put("wctx", CollectionUtils.wrapList((Object[])new Object[]{fedRequest.getWctx()}));
        return targetService;
    }

    private void redirectToIdentityProvider(WSFederationRequest fedRequest, HttpServletResponse response, HttpServletRequest request, WebApplicationService service, WSFederationRegisteredService registeredService) throws Exception {
        String serviceUrl = this.constructServiceUrl(request, response, fedRequest);
        LOGGER.debug("Created service url [{}] mapped to [{}]", (Object)serviceUrl, (Object)registeredService);
        boolean renew = this.shouldRenewAuthentication(fedRequest, request);
        String initialUrl = CommonUtils.constructRedirectUrl((String)this.getConfigContext().getCasProperties().getServer().getLoginUrl(), (String)"service", (String)serviceUrl, (boolean)renew, (boolean)false);
        URIBuilder builder = new URIBuilder(initialUrl);
        service.getAttributes().forEach((key, value) -> CollectionUtils.firstElement((Object)value).map(Object::toString).ifPresent(v -> builder.addParameter(key, v)));
        initialUrl = builder.toString();
        LOGGER.debug("Redirecting authN request to [{}]", (Object)initialUrl);
        response.sendRedirect(initialUrl);
    }
}

