/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.claims;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.rt.security.claims.Claim;
import org.apache.cxf.sts.claims.ClaimsParameters;
import org.apereo.cas.support.claims.NonWSFederationClaimsClaimsHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomNamespaceWSFederationClaimsClaimsHandler
extends NonWSFederationClaimsClaimsHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomNamespaceWSFederationClaimsClaimsHandler.class);
    private final List<String> supportedClaimTypes;

    public CustomNamespaceWSFederationClaimsClaimsHandler(String handlerRealm, String issuer, List<String> namespaces) {
        super(handlerRealm, issuer);
        this.supportedClaimTypes = new CustomNamespaceWSFederationClaimsList(namespaces);
    }

    @Override
    protected String createProcessedClaimType(Claim requestClaim, ClaimsParameters parameters) {
        String tokenType = parameters.getTokenRequirements().getTokenType();
        if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equalsIgnoreCase(tokenType)) {
            String claimType = requestClaim.getClaimType();
            int idx = claimType.lastIndexOf(47);
            String claimName = claimType.substring(idx + 1).trim();
            LOGGER.debug("Converted full claim type from [{}] to [{}]", (Object)claimType, (Object)claimName);
            return claimName;
        }
        return requestClaim.getClaimType();
    }

    @Override
    @Generated
    public List<String> getSupportedClaimTypes() {
        return this.supportedClaimTypes;
    }

    private static class CustomNamespaceWSFederationClaimsList
    extends ArrayList<String> {
        private static final long serialVersionUID = 8368878016992806802L;
        private final List<String> namespaces;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean contains(Object o) {
            String uri = "";
            uri = o instanceof URI ? ((URI)o).toASCIIString() : o.toString();
            if (!StringUtils.isNotBlank((CharSequence)uri)) return false;
            if (!this.namespaces.stream().anyMatch(uri::startsWith)) return false;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return this.namespaces.isEmpty();
        }

        @Generated
        public CustomNamespaceWSFederationClaimsList(List<String> namespaces) {
            this.namespaces = namespaces;
        }
    }
}

