/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml;

import java.security.cert.X509Certificate;
import java.util.regex.Matcher;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.sts.token.realm.SAMLRealmCodec;
import org.apache.wss4j.common.saml.SAMLKeyInfo;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apereo.cas.util.RegexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlAssertionRealmCodec
implements SAMLRealmCodec {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlAssertionRealmCodec.class);
    private final String realm;
    private final boolean uppercase = true;

    public String getRealmFromToken(SamlAssertionWrapper assertion) {
        SAMLKeyInfo ki = assertion.getSignatureKeyInfo();
        X509Certificate[] certs = ki.getCerts();
        String parsed = this.parseCNValue(certs[0].getSubjectX500Principal().getName());
        LOGGER.debug("Realm parsed from certificate CN of the SAML assertion: [{}]", (Object)parsed);
        if (StringUtils.equals((CharSequence)parsed, (CharSequence)this.realm)) {
            return parsed;
        }
        LOGGER.warn("Retrieved realm from CN of SAML assertion certificate [{}] does not match the CAS realm [{}]. Beware that realm mismatch does requires configuration to implement realm relationships or identity mapping", (Object)parsed, (Object)this.realm);
        return parsed;
    }

    private String parseCNValue(String name) {
        Matcher matcher = RegexUtils.createPattern((String)"cn=(\\w+)").matcher(name);
        if (matcher.find()) {
            String commonName = matcher.group(1);
            return commonName.toUpperCase();
        }
        return null;
    }

    @Generated
    public SamlAssertionRealmCodec(String realm) {
        this.realm = realm;
    }
}

