/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.x509;

import lombok.Generated;
import org.apache.cxf.sts.request.ReceivedToken;
import org.apache.cxf.sts.token.delegation.TokenDelegationHandler;
import org.apache.cxf.sts.token.delegation.TokenDelegationParameters;
import org.apache.cxf.sts.token.delegation.TokenDelegationResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class X509TokenDelegationHandler
implements TokenDelegationHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(X509TokenDelegationHandler.class);

    public boolean canHandleToken(ReceivedToken delegateTarget) {
        Object token = delegateTarget.getToken();
        if (token instanceof Element) {
            Element tokenElement = (Element)token;
            String namespace = tokenElement.getNamespaceURI();
            String localname = tokenElement.getLocalName();
            return "http://www.w3.org/2000/09/xmldsig#".equals(namespace) && "X509Data".equals(localname);
        }
        return false;
    }

    public TokenDelegationResponse isDelegationAllowed(TokenDelegationParameters tokenParameters) {
        TokenDelegationResponse response = new TokenDelegationResponse();
        ReceivedToken delegateTarget = tokenParameters.getToken();
        response.setToken(delegateTarget);
        if (!delegateTarget.isDOMElement()) {
            return response;
        }
        if (delegateTarget.getState() == ReceivedToken.STATE.VALID && delegateTarget.getPrincipal() != null) {
            response.setDelegationAllowed(true);
            LOGGER.debug("Delegation is allowed for [{}]", (Object)delegateTarget.getPrincipal());
        } else {
            LOGGER.debug("Delegation is not allowed; token is invalid or the principal is undefined");
        }
        return response;
    }
}

